/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.function.Supplier;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.assertions.FluentByteArrayAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.http.entity.HttpEntityBuilder;
import org.apache.juneau.http.header.ContentEncoding;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.internal.IOUtils;

@BeanIgnore
public class BasicHttpEntity
implements HttpEntity {
    public static final BasicHttpEntity EMPTY = BasicHttpEntity.create(BasicHttpEntity.class).build();
    final boolean cached;
    final boolean chunked;
    final Object content;
    final Supplier<?> contentSupplier;
    final ContentType contentType;
    final ContentEncoding contentEncoding;
    final Charset charset;
    final long contentLength;

    public static <T extends BasicHttpEntity> HttpEntityBuilder<T> create(Class<T> implClass) {
        return new HttpEntityBuilder<Class<T>>(implClass);
    }

    public BasicHttpEntity(HttpEntityBuilder<?> builder) {
        this.cached = builder.cached;
        this.chunked = builder.chunked;
        this.content = builder.content;
        this.contentSupplier = builder.contentSupplier;
        this.contentType = builder.contentType;
        this.contentEncoding = builder.contentEncoding;
        this.charset = builder.charset;
        this.contentLength = builder.contentLength;
    }

    public HttpEntityBuilder<? extends BasicHttpEntity> copy() {
        return new HttpEntityBuilder<BasicHttpEntity>(this);
    }

    public String asString() throws IOException {
        return IOUtils.read(this.getContent());
    }

    public byte[] asBytes() throws IOException {
        return IOUtils.readBytes(this.getContent());
    }

    public FluentStringAssertion<BasicHttpEntity> assertString() throws IOException {
        return new FluentStringAssertion<BasicHttpEntity>(this.asString(), this);
    }

    public FluentByteArrayAssertion<BasicHttpEntity> assertBytes() throws IOException {
        return new FluentByteArrayAssertion<BasicHttpEntity>(this.asBytes(), this);
    }

    protected <T> T contentOrElse(T def) {
        Object o = this.content;
        if (o == null && this.contentSupplier != null) {
            o = this.contentSupplier.get();
        }
        return (T)(o == null ? def : o);
    }

    protected boolean isSupplied() {
        return this.contentSupplier != null;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    public boolean isChunked() {
        return this.chunked;
    }

    @Override
    public Header getContentType() {
        return this.contentType;
    }

    @Override
    public Header getContentEncoding() {
        return this.contentEncoding;
    }

    @Override
    public boolean isStreaming() {
        return false;
    }

    @Override
    public void consumeContent() throws IOException {
    }

    @Override
    public InputStream getContent() throws IOException, UnsupportedOperationException {
        return IOUtils.EMPTY_INPUT_STREAM;
    }

    @Override
    public void writeTo(OutputStream outStream) throws IOException {
    }
}

