/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.annotation;

import org.apache.juneau.annotation.AnnotationBuilder;
import org.apache.juneau.annotation.AnnotationImpl;
import org.apache.juneau.http.annotation.Contact;

public class ContactAnnotation {
    public static final Contact DEFAULT = ContactAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static boolean empty(Contact a) {
        return a == null || DEFAULT.equals(a);
    }

    private static class Impl
    extends AnnotationImpl
    implements Contact {
        private final String email;
        private final String name;
        private final String url;

        Impl(Builder b) {
            super(b);
            this.email = b.email;
            this.name = b.name;
            this.url = b.url;
            this.postConstruct();
        }

        @Override
        public String email() {
            return this.email;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String url() {
            return this.url;
        }
    }

    public static class Builder
    extends AnnotationBuilder {
        String email = "";
        String name = "";
        String url = "";

        protected Builder() {
            super(Contact.class);
        }

        public Contact build() {
            return new Impl(this);
        }

        public Builder email(String value) {
            this.email = value;
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder url(String value) {
            this.url = value;
            return this;
        }
    }
}

