/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.reflect.MethodInfo;

public class BeanProxyInvocationHandler<T>
implements InvocationHandler {
    private final BeanMeta<T> meta;
    private Map<String, Object> beanProps;

    public BeanProxyInvocationHandler(BeanMeta<T> meta) {
        this.meta = meta;
        this.beanProps = new HashMap<String, Object>();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        MethodInfo mi = MethodInfo.of(method);
        if (mi.hasName("equals") && mi.hasParamTypes(Object.class)) {
            InvocationHandler ih;
            Object arg = args[0];
            if (arg == null) {
                return false;
            }
            if (proxy == arg) {
                return true;
            }
            if (proxy.getClass() == arg.getClass() && (ih = Proxy.getInvocationHandler(arg)) instanceof BeanProxyInvocationHandler) {
                return this.beanProps.equals(((BeanProxyInvocationHandler)ih).beanProps);
            }
            BeanMap<Object> bean = this.meta.ctx.toBeanMap(arg);
            return this.beanProps.equals(bean);
        }
        if (mi.hasName("hashCode") && mi.hasNoParams()) {
            return this.beanProps.hashCode();
        }
        if (mi.hasName("toString") && mi.hasNoParams()) {
            return SimpleJsonSerializer.DEFAULT.toString(this.beanProps);
        }
        String prop = this.meta.getterProps.get(method);
        if (prop != null) {
            return this.beanProps.get(prop);
        }
        prop = this.meta.setterProps.get(method);
        if (prop != null) {
            this.beanProps.put(prop, args[0]);
            return null;
        }
        throw ThrowableUtils.unsupportedOperationException("Unsupported bean method.  method=''{0}''", method);
    }
}

