/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.remote;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.juneau.Value;
import org.apache.juneau.http.remote.Remote;
import org.apache.juneau.http.remote.RrpcInterfaceMethodMeta;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.ClassInfo;

public class RrpcInterfaceMeta {
    private final Map<Method, RrpcInterfaceMethodMeta> methods;
    private final Map<String, RrpcInterfaceMethodMeta> methodsByPath;
    private final String path;
    private final Class<?> c;

    public RrpcInterfaceMeta(Class<?> c, String uri) {
        this.c = c;
        Value<String> path = Value.of("");
        ClassInfo ci = ClassInfo.of(c);
        ci.forEachAnnotation(Remote.class, x -> StringUtils.isNotEmpty(x.path()), x -> path.set(StringUtils.trimSlashes(x.path())));
        LinkedHashMap methods = CollectionUtils.map();
        ci.forEachPublicMethod(x -> true, x -> methods.put(x.inner(), new RrpcInterfaceMethodMeta(uri, x.inner())));
        LinkedHashMap methodsByPath = CollectionUtils.map();
        methods.values().forEach(x -> methodsByPath.put(x.getPath(), x));
        this.methods = CollectionUtils.unmodifiable(methods);
        this.methodsByPath = CollectionUtils.unmodifiable(methodsByPath);
        this.path = path.get();
    }

    public Map<String, RrpcInterfaceMethodMeta> getMethodsByPath() {
        return this.methodsByPath;
    }

    public RrpcInterfaceMethodMeta getMethodMeta(Method m) {
        return this.methods.get(m);
    }

    public RrpcInterfaceMethodMeta getMethodMetaByPath(String p) {
        return this.methodsByPath.get(p);
    }

    public Class<?> getJavaClass() {
        return this.c;
    }

    public String getPath() {
        return this.path;
    }
}

