/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.util.CharArrayBuffer;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.ListOperation;
import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.http.header.BasicHeader;
import org.apache.juneau.http.header.BasicHeaderIterator;
import org.apache.juneau.http.header.HeaderBeanMeta;
import org.apache.juneau.internal.ArrayBuilder;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConsumerUtils;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.svl.VarResolver;

public class HeaderList {
    private static final Header[] EMPTY_ARRAY = new Header[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Predicate<Header> NOT_NULL = x -> x != null;
    public static final HeaderList EMPTY = new HeaderList();
    final Header[] entries;
    final boolean caseSensitive;

    public static Builder create() {
        return new Builder();
    }

    public static HeaderList of(List<Header> headers) {
        return headers == null || headers.isEmpty() ? EMPTY : new HeaderList(headers);
    }

    public static HeaderList of(Header ... headers) {
        return headers == null || headers.length == 0 ? EMPTY : new HeaderList(headers);
    }

    public static HeaderList ofPairs(String ... pairs) {
        if (pairs == null || pairs.length == 0) {
            return EMPTY;
        }
        if (pairs.length % 2 != 0) {
            throw ThrowableUtils.runtimeException("Odd number of parameters passed into HeaderList.ofPairs()", new Object[0]);
        }
        ArrayBuilder<Header> b = ArrayBuilder.of(Header.class).filter(NOT_NULL).size(pairs.length / 2);
        for (int i = 0; i < pairs.length; i += 2) {
            b.add(BasicHeader.of(pairs[i], pairs[i + 1]));
        }
        return new HeaderList(b.orElse((Header[])EMPTY_ARRAY));
    }

    public HeaderList(Builder builder) {
        if (builder.defaultEntries == null) {
            this.entries = builder.entries.toArray(new Header[builder.entries.size()]);
        } else {
            ArrayBuilder<Header> l = ArrayBuilder.of(Header.class).filter(NOT_NULL).size(builder.entries.size() + builder.defaultEntries.size());
            int j = builder.entries.size();
            for (int i = 0; i < j; ++i) {
                l.add(builder.entries.get(i));
            }
            int j1 = builder.defaultEntries.size();
            for (int i1 = 0; i1 < j1; ++i1) {
                Header x = builder.defaultEntries.get(i1);
                boolean exists = false;
                int j2 = builder.entries.size();
                for (int i2 = 0; i2 < j2 && !exists; ++i2) {
                    exists = this.eq(builder.entries.get(i2).getName(), x.getName());
                }
                if (exists) continue;
                l.add(x);
            }
            this.entries = l.orElse((Header[])EMPTY_ARRAY);
        }
        this.caseSensitive = builder.caseSensitive;
    }

    protected HeaderList(List<Header> headers) {
        ArrayBuilder<Header> l = ArrayBuilder.of(Header.class).filter(NOT_NULL).size(headers.size());
        int j = headers.size();
        for (int i = 0; i < j; ++i) {
            l.add(headers.get(i));
        }
        this.entries = l.orElse((Header[])EMPTY_ARRAY);
        this.caseSensitive = false;
    }

    protected HeaderList(Header ... headers) {
        ArrayBuilder<Header> l = ArrayBuilder.of(Header.class).filter(NOT_NULL).size(headers.length);
        for (int i = 0; i < headers.length; ++i) {
            l.add(headers[i]);
        }
        this.entries = l.orElse((Header[])EMPTY_ARRAY);
        this.caseSensitive = false;
    }

    protected HeaderList() {
        this.entries = EMPTY_ARRAY;
        this.caseSensitive = false;
    }

    public Builder copy() {
        return new Builder(this);
    }

    public Optional<Header> get(String name) {
        Header first = null;
        ArrayList<Header> rest = null;
        for (int i = 0; i < this.entries.length; ++i) {
            Header x = this.entries[i];
            if (!this.eq(x.getName(), name)) continue;
            if (first == null) {
                first = x;
                continue;
            }
            if (rest == null) {
                rest = CollectionUtils.list(new Header[0]);
            }
            rest.add(x);
        }
        if (first == null) {
            return CollectionUtils.empty();
        }
        if (rest == null) {
            return CollectionUtils.optional(first);
        }
        CharArrayBuffer sb = new CharArrayBuffer(128);
        sb.append(first.getValue());
        for (int i = 0; i < rest.size(); ++i) {
            sb.append(", ");
            sb.append(((Header)rest.get(i)).getValue());
        }
        return CollectionUtils.optional(new BasicHeader(name, sb.toString()));
    }

    public <T> Optional<T> get(String name, Class<T> type) {
        Header first = null;
        ArrayList<Header> rest = null;
        for (int i = 0; i < this.entries.length; ++i) {
            Header x = this.entries[i];
            if (!this.eq(x.getName(), name)) continue;
            if (first == null) {
                first = x;
                continue;
            }
            if (rest == null) {
                rest = CollectionUtils.list(new Header[0]);
            }
            rest.add(x);
        }
        if (first == null) {
            return CollectionUtils.empty();
        }
        if (rest == null) {
            return CollectionUtils.optional(HeaderBeanMeta.of(type).construct(name, first.getValue()));
        }
        CharArrayBuffer sb = new CharArrayBuffer(128);
        sb.append(first.getValue());
        for (int i = 0; i < rest.size(); ++i) {
            sb.append(", ");
            sb.append(((Header)rest.get(i)).getValue());
        }
        return CollectionUtils.optional(HeaderBeanMeta.of(type).construct(name, sb.toString()));
    }

    public <T> Optional<T> get(Class<T> type) {
        Assertions.assertArgNotNull("type", type);
        String name = HeaderBeanMeta.of(type).getSchema().getName();
        Assertions.assertArg(name != null, "Header name could not be found on bean type ''{0}''", type.getName());
        return this.get(name, type);
    }

    public Header[] getAll(String name) {
        ArrayBuilder<Header> b = ArrayBuilder.of(Header.class).filter(NOT_NULL);
        for (int i = 0; i < this.entries.length; ++i) {
            if (!this.eq(this.entries[i].getName(), name)) continue;
            b.add(this.entries[i]);
        }
        return b.orElse((Header[])EMPTY_ARRAY);
    }

    public Header[] getAll() {
        return this.entries.length == 0 ? EMPTY_ARRAY : Arrays.copyOf(this.entries, this.entries.length);
    }

    public int size() {
        return this.entries.length;
    }

    public Optional<Header> getFirst(String name) {
        for (int i = 0; i < this.entries.length; ++i) {
            Header x = this.entries[i];
            if (!this.eq(x.getName(), name)) continue;
            return CollectionUtils.optional(x);
        }
        return CollectionUtils.empty();
    }

    public Optional<Header> getLast(String name) {
        for (int i = this.entries.length - 1; i >= 0; --i) {
            Header x = this.entries[i];
            if (!this.eq(x.getName(), name)) continue;
            return CollectionUtils.optional(x);
        }
        return CollectionUtils.empty();
    }

    public HeaderList forEachValue(Predicate<Header> filter, Consumer<String> action) {
        return this.forEach(filter, (Header x) -> action.accept(x.getValue()));
    }

    public HeaderList forEachValue(String name, Consumer<String> action) {
        return this.forEach(name, (Header x) -> action.accept(x.getValue()));
    }

    public String[] getValues(String name) {
        ArrayBuilder<String> b = ArrayBuilder.of(String.class).size(1);
        this.forEach(name, (Header x) -> b.add(x.getValue()));
        return b.orElse((String[])EMPTY_STRING_ARRAY);
    }

    public boolean contains(String name) {
        for (int i = 0; i < this.entries.length; ++i) {
            Header x = this.entries[i];
            if (!this.eq(x.getName(), name)) continue;
            return true;
        }
        return false;
    }

    public HeaderIterator iterator() {
        return new BasicHeaderIterator(this.entries, null, this.caseSensitive);
    }

    public HeaderIterator iterator(String name) {
        return new BasicHeaderIterator(this.entries, name, this.caseSensitive);
    }

    public HeaderList forEach(Consumer<Header> action) {
        return this.forEach((Header x) -> true, action);
    }

    public HeaderList forEach(String name, Consumer<Header> action) {
        return this.forEach((Header x) -> this.eq(name, x.getName()), action);
    }

    public HeaderList forEach(Predicate<Header> filter, Consumer<Header> action) {
        for (int i = 0; i < this.entries.length; ++i) {
            ConsumerUtils.consume(filter, action, this.entries[i]);
        }
        return this;
    }

    public Stream<Header> stream() {
        return Arrays.stream(this.entries);
    }

    public Stream<Header> stream(String name) {
        return this.stream().filter(x -> this.eq(name, x.getName()));
    }

    private boolean eq(String s1, String s2) {
        return StringUtils.eq(!this.caseSensitive, s1, s2);
    }

    public String toString() {
        return CollectionUtils.alist(this.entries).toString();
    }

    @FluentSetters
    public static class Builder
    extends BeanBuilder<HeaderList> {
        final List<Header> entries;
        List<Header> defaultEntries;
        private VarResolver varResolver;
        boolean caseSensitive;

        protected Builder() {
            super(HeaderList.class, BeanStore.INSTANCE);
            this.entries = CollectionUtils.list(new Header[0]);
        }

        protected Builder(HeaderList copyFrom) {
            super(copyFrom.getClass(), BeanStore.INSTANCE);
            this.entries = CollectionUtils.list(copyFrom.entries);
            this.caseSensitive = copyFrom.caseSensitive;
        }

        protected Builder(Builder copyFrom) {
            super(copyFrom);
            this.entries = CollectionUtils.copyOf(copyFrom.entries);
            this.defaultEntries = CollectionUtils.copyOf(copyFrom.defaultEntries);
            this.varResolver = copyFrom.varResolver;
            this.caseSensitive = copyFrom.caseSensitive;
        }

        @Override
        protected HeaderList buildDefault() {
            return this.entries.isEmpty() && this.defaultEntries == null ? EMPTY : new HeaderList(this);
        }

        public Builder copy() {
            return new Builder(this);
        }

        public Builder resolving() {
            return this.resolving(VarResolver.DEFAULT);
        }

        public Builder resolving(VarResolver varResolver) {
            this.varResolver = varResolver;
            return this;
        }

        public Builder caseSensitive() {
            this.caseSensitive = true;
            return this;
        }

        @FluentSetter
        public Builder clear() {
            this.entries.clear();
            return this;
        }

        @FluentSetter
        public Builder append(HeaderList value) {
            if (value != null) {
                for (Header x : value.entries) {
                    this.append(x);
                }
            }
            return this;
        }

        @FluentSetter
        public Builder append(Header value) {
            if (value != null) {
                this.entries.add(value);
            }
            return this;
        }

        public Builder append(String name, Object value) {
            return this.append(this.createHeader(name, value));
        }

        public Builder append(String name, Supplier<?> value) {
            return this.append(this.createHeader(name, value));
        }

        @FluentSetter
        public Builder append(Header ... values) {
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    this.append(values[i]);
                }
            }
            return this;
        }

        @FluentSetter
        public Builder append(List<Header> values) {
            if (values != null) {
                int j = values.size();
                for (int i = 0; i < j; ++i) {
                    this.append(values.get(i));
                }
            }
            return this;
        }

        @FluentSetter
        public Builder prepend(HeaderList value) {
            if (value != null) {
                CollectionUtils.prependAll(this.entries, value.entries);
            }
            return this;
        }

        @FluentSetter
        public Builder prepend(Header value) {
            if (value != null) {
                this.entries.add(0, value);
            }
            return this;
        }

        public Builder prepend(String name, Object value) {
            return this.prepend(this.createHeader(name, value));
        }

        public Builder prepend(String name, Supplier<?> value) {
            return this.prepend(this.createHeader(name, value));
        }

        @FluentSetter
        public Builder prepend(Header ... values) {
            if (values != null) {
                this.prepend(CollectionUtils.alist(values));
            }
            return this;
        }

        @FluentSetter
        public Builder prepend(List<Header> values) {
            if (values != null) {
                this.entries.addAll(0, values);
            }
            return this;
        }

        @FluentSetter
        public Builder remove(HeaderList value) {
            if (value != null) {
                for (int i = 0; i < value.entries.length; ++i) {
                    this.remove(value.entries[i]);
                }
            }
            return this;
        }

        @FluentSetter
        public Builder remove(Header value) {
            if (value != null) {
                this.entries.remove(value);
            }
            return this;
        }

        @FluentSetter
        public Builder remove(Header ... values) {
            for (int i = 0; i < values.length; ++i) {
                this.remove(values[i]);
            }
            return this;
        }

        @FluentSetter
        public Builder remove(List<Header> values) {
            int j = values.size();
            for (int i = 0; i < j; ++i) {
                this.remove(values.get(i));
            }
            return this;
        }

        @FluentSetter
        public Builder remove(String name) {
            for (int i = 0; i < this.entries.size(); ++i) {
                if (!this.eq(this.entries.get(i).getName(), name)) continue;
                this.entries.remove(i--);
            }
            return this;
        }

        @FluentSetter
        public Builder remove(String ... names) {
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    this.remove(names[i]);
                }
            }
            return this;
        }

        @FluentSetter
        public Builder set(Header value) {
            if (value != null) {
                boolean replaced = false;
                int j = this.entries.size();
                for (int i = 0; i < j; ++i) {
                    Header x = this.entries.get(i);
                    if (!this.eq(x.getName(), value.getName())) continue;
                    if (replaced) {
                        this.entries.remove(i);
                        --j;
                        continue;
                    }
                    this.entries.set(i, value);
                    replaced = true;
                }
                if (!replaced) {
                    this.entries.add(value);
                }
            }
            return this;
        }

        @FluentSetter
        public Builder set(Header ... values) {
            if (values != null) {
                this.set(CollectionUtils.alist(values));
            }
            return this;
        }

        public Builder set(String name, Object value) {
            return this.set(this.createHeader(name, value));
        }

        public Builder set(String name, Supplier<?> value) {
            return this.set(this.createHeader(name, value));
        }

        @FluentSetter
        public Builder set(List<Header> values) {
            if (values != null) {
                int j1 = values.size();
                for (int i1 = 0; i1 < j1; ++i1) {
                    Header h = values.get(i1);
                    if (h == null) continue;
                    int j2 = this.entries.size();
                    for (int i2 = 0; i2 < j2; ++i2) {
                        Header x = this.entries.get(i2);
                        if (!this.eq(x.getName(), h.getName())) continue;
                        this.entries.remove(i2);
                        --j2;
                    }
                }
                int j = values.size();
                for (int i = 0; i < j; ++i) {
                    Header x = values.get(i);
                    if (x == null) continue;
                    this.entries.add(x);
                }
            }
            return this;
        }

        public Builder set(HeaderList values) {
            if (values != null) {
                this.set(values.entries);
            }
            return this;
        }

        @FluentSetter
        public Builder setDefault(Header value) {
            if (value != null) {
                boolean replaced = false;
                if (this.defaultEntries == null) {
                    this.defaultEntries = CollectionUtils.list(new Header[0]);
                }
                int j = this.defaultEntries.size();
                for (int i = 0; i < j; ++i) {
                    Header x = this.defaultEntries.get(i);
                    if (!this.eq(x.getName(), value.getName())) continue;
                    if (replaced) {
                        this.defaultEntries.remove(i);
                        --j;
                        continue;
                    }
                    this.defaultEntries.set(i, value);
                    replaced = true;
                }
                if (!replaced) {
                    this.defaultEntries.add(value);
                }
            }
            return this;
        }

        @FluentSetter
        public Builder setDefault(Header ... values) {
            if (values != null) {
                this.setDefault(CollectionUtils.alist(values));
            }
            return this;
        }

        public Builder setDefault(String name, Object value) {
            return this.setDefault(this.createHeader(name, value));
        }

        public Builder setDefault(String name, Supplier<?> value) {
            return this.setDefault(this.createHeader(name, value));
        }

        @FluentSetter
        public Builder setDefault(List<Header> values) {
            if (values != null) {
                if (this.defaultEntries == null) {
                    this.defaultEntries = CollectionUtils.list(new Header[0]);
                }
                int j1 = values.size();
                for (int i1 = 0; i1 < j1; ++i1) {
                    Header h = values.get(i1);
                    if (h == null) continue;
                    int j2 = this.defaultEntries.size();
                    for (int i2 = 0; i2 < j2; ++i2) {
                        Header x2 = this.defaultEntries.get(i2);
                        if (!this.eq(x2.getName(), h.getName())) continue;
                        this.defaultEntries.remove(i2);
                        --j2;
                    }
                }
                values.forEach((? super T x) -> {
                    if (x != null) {
                        this.defaultEntries.add((Header)x);
                    }
                });
            }
            return this;
        }

        public Builder setDefault(HeaderList values) {
            if (values != null) {
                this.setDefault(values.entries);
            }
            return this;
        }

        @FluentSetter
        public Builder add(ListOperation flag, Header value) {
            if (flag == ListOperation.APPEND) {
                return this.append(value);
            }
            if (flag == ListOperation.PREPEND) {
                return this.prepend(value);
            }
            if (flag == ListOperation.SET) {
                return this.set(value);
            }
            if (flag == ListOperation.DEFAULT) {
                return this.setDefault(value);
            }
            throw ThrowableUtils.runtimeException("Invalid value specified for flag parameter on add(flag,value) method: {0}", new Object[]{flag});
        }

        @FluentSetter
        public Builder add(ListOperation flag, Header ... values) {
            if (flag == ListOperation.APPEND) {
                return this.append(values);
            }
            if (flag == ListOperation.PREPEND) {
                return this.prepend(values);
            }
            if (flag == ListOperation.SET) {
                return this.set(values);
            }
            if (flag == ListOperation.DEFAULT) {
                return this.setDefault(values);
            }
            throw ThrowableUtils.runtimeException("Invalid value specified for flag parameter on add(flag,values) method: {0}", new Object[]{flag});
        }

        public Builder add(ListOperation flag, String name, Object value) {
            if (flag == ListOperation.APPEND) {
                return this.append(name, value);
            }
            if (flag == ListOperation.PREPEND) {
                return this.prepend(name, value);
            }
            if (flag == ListOperation.SET) {
                return this.set(name, value);
            }
            if (flag == ListOperation.DEFAULT) {
                return this.setDefault(name, value);
            }
            throw ThrowableUtils.runtimeException("Invalid value specified for flag parameter on add(flag,name,value) method: {0}", new Object[]{flag});
        }

        public Builder add(ListOperation flag, String name, Supplier<?> value) {
            if (flag == ListOperation.APPEND) {
                return this.append(name, value);
            }
            if (flag == ListOperation.PREPEND) {
                return this.prepend(name, value);
            }
            if (flag == ListOperation.SET) {
                return this.set(name, value);
            }
            if (flag == ListOperation.DEFAULT) {
                return this.setDefault(name, value);
            }
            throw ThrowableUtils.runtimeException("Invalid value specified for flag parameter on add(flag,name,value) method: {0}", new Object[]{flag});
        }

        @FluentSetter
        public Builder add(ListOperation flag, List<Header> values) {
            if (flag == ListOperation.APPEND) {
                return this.append(values);
            }
            if (flag == ListOperation.PREPEND) {
                return this.prepend(values);
            }
            if (flag == ListOperation.SET) {
                return this.set(values);
            }
            if (flag == ListOperation.DEFAULT) {
                return this.setDefault(values);
            }
            throw ThrowableUtils.runtimeException("Invalid value specified for flag parameter on add(flag,values) method: {0}", new Object[]{flag});
        }

        public Builder add(ListOperation flag, HeaderList values) {
            if (flag == ListOperation.APPEND) {
                return this.append(values);
            }
            if (flag == ListOperation.PREPEND) {
                return this.prepend(values);
            }
            if (flag == ListOperation.SET) {
                return this.set(values);
            }
            if (flag == ListOperation.DEFAULT) {
                return this.setDefault(values);
            }
            throw ThrowableUtils.runtimeException("Invalid value specified for flag parameter on add(flag,values) method: {0}", new Object[]{flag});
        }

        public Builder forEach(Consumer<Header> action) {
            int j = this.entries.size();
            for (int i = 0; i < j; ++i) {
                action.accept(this.entries.get(i));
            }
            return this;
        }

        public Builder forEach(String name, Consumer<Header> action) {
            int j = this.entries.size();
            for (int i = 0; i < j; ++i) {
                Header x = this.entries.get(i);
                if (!this.eq(name, x.getName())) continue;
                action.accept(x);
            }
            return this;
        }

        private boolean isResolving() {
            return this.varResolver != null;
        }

        private Supplier<Object> resolver(Object input) {
            return () -> this.varResolver.resolve(StringUtils.stringify(this.unwrap(input)));
        }

        private Object unwrap(Object o) {
            while (o instanceof Supplier) {
                o = ((Supplier)o).get();
            }
            return o;
        }

        public Header createHeader(String name, Object value) {
            if (value instanceof Supplier) {
                Supplier value2 = (Supplier)value;
                return this.isResolving() ? new BasicHeader(name, this.resolver(value2)) : new BasicHeader(name, (Object)value2);
            }
            return this.isResolving() ? new BasicHeader(name, this.resolver(value)) : new BasicHeader(name, value);
        }

        private boolean eq(String s1, String s2) {
            return this.caseSensitive ? StringUtils.eq(s1, s2) : StringUtils.eqic(s1, s2);
        }

        public Optional<Header> getFirst(String name) {
            Header x;
            int i;
            for (i = 0; i < this.entries.size(); ++i) {
                x = this.entries.get(i);
                if (!this.eq(x.getName(), name)) continue;
                return CollectionUtils.optional(x);
            }
            if (this.defaultEntries != null) {
                for (i = 0; i < this.defaultEntries.size(); ++i) {
                    x = this.defaultEntries.get(i);
                    if (!this.eq(x.getName(), name)) continue;
                    return CollectionUtils.optional(x);
                }
            }
            return CollectionUtils.empty();
        }

        public Optional<Header> getLast(String name) {
            Header x;
            int i;
            for (i = this.entries.size() - 1; i >= 0; --i) {
                x = this.entries.get(i);
                if (!this.eq(x.getName(), name)) continue;
                return CollectionUtils.optional(x);
            }
            if (this.defaultEntries != null) {
                for (i = this.defaultEntries.size() - 1; i >= 0; --i) {
                    x = this.defaultEntries.get(i);
                    if (!this.eq(x.getName(), name)) continue;
                    return CollectionUtils.optional(x);
                }
            }
            return CollectionUtils.empty();
        }

        public Builder impl(Object value) {
            super.impl(value);
            return this;
        }

        public Builder type(Class<?> value) {
            super.type(value);
            return this;
        }

        public String toString() {
            return "[" + StringUtils.join(this.entries, ", ") + "]";
        }
    }

    public static final class Void
    extends HeaderList {
    }
}

