/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.msgpack;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.collections.JsonList;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.http.header.MediaType;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.msgpack.DataType;
import org.apache.juneau.msgpack.MsgPackInputStream;
import org.apache.juneau.msgpack.MsgPackParser;
import org.apache.juneau.parser.InputStreamParserSession;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.swap.BuilderSwap;
import org.apache.juneau.swap.ObjectSwap;

public final class MsgPackParserSession
extends InputStreamParserSession {
    public static Builder create(MsgPackParser ctx) {
        return new Builder(ctx);
    }

    protected MsgPackParserSession(Builder builder) {
        super(builder);
    }

    @Override
    protected <T> T doParse(ParserPipe pipe, ClassMeta<T> type) throws IOException, ParseException, ExecutableException {
        try (MsgPackInputStream is = new MsgPackInputStream(pipe);){
            T t = this.parseAnything(type, is, this.getOuter(), null);
            return t;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T parseAnything(ClassMeta<?> eType, MsgPackInputStream is, Object outer, BeanPropertyMeta pMeta) throws IOException, ParseException, ExecutableException {
        if (eType == null) {
            eType = this.object();
        }
        ObjectSwap<Object, ?> swap = eType.getSwap(this);
        BuilderSwap<Object, Object> builder = eType.getBuilderSwap(this);
        ClassMeta<Object> sType = null;
        sType = builder != null ? builder.getBuilderClassMeta(this) : (swap != null ? swap.getSwapClassMeta(this) : eType);
        if (sType.isOptional()) {
            return (T)CollectionUtils.optional(this.parseAnything(eType.getElementType(), is, outer, pMeta));
        }
        this.setCurrentClass(sType);
        Object o = null;
        DataType dt = is.readDataType();
        int length = (int)is.readLength();
        if (dt != DataType.NULL) {
            int i;
            if (dt == DataType.BOOLEAN) {
                o = is.readBoolean();
            } else if (dt == DataType.INT) {
                o = is.readInt();
            } else if (dt == DataType.LONG) {
                o = is.readLong();
            } else if (dt == DataType.FLOAT) {
                o = Float.valueOf(is.readFloat());
            } else if (dt == DataType.DOUBLE) {
                o = is.readDouble();
            } else if (dt == DataType.STRING) {
                o = this.trim(is.readString());
            } else if (dt == DataType.BIN) {
                o = is.readBinary();
            } else if (dt == DataType.ARRAY && sType.isObject()) {
                JsonList jl = new JsonList(this);
                for (i = 0; i < length; ++i) {
                    jl.add(this.parseAnything(this.object(), is, outer, pMeta));
                }
                o = jl;
            } else if (dt == DataType.MAP && sType.isObject()) {
                JsonMap jm = new JsonMap(this);
                for (i = 0; i < length; ++i) {
                    jm.put((String)this.parseAnything(this.string(), is, outer, pMeta), this.parseAnything(this.object(), is, jm, pMeta));
                }
                o = this.cast(jm, pMeta, eType);
            }
            if (!sType.isObject()) {
                Collection<Object> l;
                AbstractMap m;
                if (sType.isBoolean() || sType.isCharSequence() || sType.isChar() || sType.isNumber() || sType.isByteArray()) {
                    o = this.convertToType(o, sType);
                } else if (sType.isMap()) {
                    if (dt != DataType.MAP) throw new ParseException((ParserSession)this, "Invalid data type {0} encountered for parse type {1}", new Object[]{dt, sType});
                    m = sType.canCreateNewInstance(outer) ? (Map)sType.newInstance(outer) : this.newGenericMap(sType);
                    for (i = 0; i < length; ++i) {
                        T key = this.parseAnything(sType.getKeyType(), is, outer, pMeta);
                        ClassMeta<?> vt = sType.getValueType();
                        T value = this.parseAnything(vt, is, m, pMeta);
                        MsgPackParserSession.setName(vt, value, key);
                        m.put(key, value);
                    }
                    o = m;
                } else if (builder != null || sType.canCreateNewBean(outer)) {
                    if (dt != DataType.MAP) throw new ParseException((ParserSession)this, "Invalid data type {0} encountered for parse type {1}", new Object[]{dt, sType});
                    m = builder == null ? this.newBeanMap(outer, sType.getInnerClass()) : this.toBeanMap(builder.create(this, eType));
                    for (i = 0; i < length; ++i) {
                        String pName = (String)this.parseAnything(this.string(), is, ((BeanMap)m).getBean(false), null);
                        BeanPropertyMeta bpm = ((BeanMap)m).getPropertyMeta(pName);
                        if (bpm == null) {
                            if (pName.equals(this.getBeanTypePropertyName(eType))) {
                                this.parseAnything(this.string(), is, null, null);
                                continue;
                            }
                            this.onUnknownProperty(pName, m, this.parseAnything(this.string(), is, null, null));
                            continue;
                        }
                        ClassMeta<?> cm = bpm.getClassMeta();
                        T value = this.parseAnything(cm, is, ((BeanMap)m).getBean(false), bpm);
                        MsgPackParserSession.setName(cm, value, pName);
                        try {
                            bpm.set((BeanMap<?>)m, pName, value);
                            continue;
                        }
                        catch (BeanRuntimeException e) {
                            this.onBeanSetterException(pMeta, e);
                            throw e;
                        }
                    }
                    o = builder == null ? ((BeanMap)m).getBean() : builder.build(this, ((BeanMap)m).getBean(), eType);
                } else if (sType.canCreateNewInstanceFromString(outer) && dt == DataType.STRING) {
                    o = sType.newInstanceFromString(outer, o == null ? "" : o.toString());
                } else if (sType.isCollection()) {
                    if (dt == DataType.MAP) {
                        m = new JsonMap(this);
                        for (i = 0; i < length; ++i) {
                            ((JsonMap)m).put((String)this.parseAnything(this.string(), is, outer, pMeta), this.parseAnything(this.object(), is, m, pMeta));
                        }
                        o = this.cast((JsonMap)m, pMeta, eType);
                    } else {
                        if (dt != DataType.ARRAY) throw new ParseException((ParserSession)this, "Invalid data type {0} encountered for parse type {1}", new Object[]{dt, sType});
                        l = sType.canCreateNewInstance(outer) ? (Collection)sType.newInstance() : new JsonList(this);
                        for (i = 0; i < length; ++i) {
                            l.add(this.parseAnything(sType.getElementType(), is, l, pMeta));
                        }
                        o = l;
                    }
                } else if (sType.isArray() || sType.isArgs()) {
                    if (dt == DataType.MAP) {
                        m = new JsonMap(this);
                        for (i = 0; i < length; ++i) {
                            ((JsonMap)m).put((String)this.parseAnything(this.string(), is, outer, pMeta), this.parseAnything(this.object(), is, m, pMeta));
                        }
                        o = this.cast((JsonMap)m, pMeta, eType);
                    } else {
                        if (dt != DataType.ARRAY) throw new ParseException((ParserSession)this, "Invalid data type {0} encountered for parse type {1}", new Object[]{dt, sType});
                        l = sType.isCollection() && sType.canCreateNewInstance(outer) ? (Collection)sType.newInstance() : new JsonList(this);
                        for (i = 0; i < length; ++i) {
                            l.add(this.parseAnything(sType.isArgs() ? sType.getArg(i) : sType.getElementType(), is, l, pMeta));
                        }
                        o = this.toArray(sType, l);
                    }
                } else {
                    if (dt != DataType.MAP) throw new ParseException((ParserSession)this, "Invalid data type {0} encountered for parse type {1}", new Object[]{dt, sType});
                    m = new JsonMap(this);
                    for (i = 0; i < length; ++i) {
                        ((JsonMap)m).put((String)this.parseAnything(this.string(), is, outer, pMeta), this.parseAnything(this.object(), is, m, pMeta));
                    }
                    if (((JsonMap)m).containsKey(this.getBeanTypePropertyName(eType))) {
                        o = this.cast((JsonMap)m, pMeta, eType);
                    } else {
                        if (sType.getProxyInvocationHandler() == null) throw new ParseException((ParserSession)this, "Class ''{0}'' could not be instantiated.  Reason: ''{1}''", sType.getInnerClass().getName(), sType.getNotABeanReason());
                        o = this.newBeanMap(outer, sType.getInnerClass()).load(m).getBean();
                    }
                }
            }
        }
        if (swap != null && o != null) {
            o = this.unswap(swap, o, eType);
        }
        if (outer == null) return (T)o;
        MsgPackParserSession.setParent(eType, o, outer);
        return (T)o;
    }

    @FluentSetters
    public static class Builder
    extends InputStreamParserSession.Builder {
        MsgPackParser ctx;

        protected Builder(MsgPackParser ctx) {
            super(ctx);
            this.ctx = ctx;
        }

        @Override
        public MsgPackParserSession build() {
            return new MsgPackParserSession(this);
        }

        @Override
        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            super.apply((Class)type, (Consumer)apply);
            return this;
        }

        @Override
        public Builder debug(Boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder properties(Map<String, Object> value) {
            super.properties((Map)value);
            return this;
        }

        @Override
        public Builder property(String key, Object value) {
            super.property(key, value);
            return this;
        }

        @Override
        public Builder unmodifiable() {
            super.unmodifiable();
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder localeDefault(Locale value) {
            super.localeDefault(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder mediaTypeDefault(MediaType value) {
            super.mediaTypeDefault(value);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder timeZoneDefault(TimeZone value) {
            super.timeZoneDefault(value);
            return this;
        }

        @Override
        public Builder javaMethod(Method value) {
            super.javaMethod(value);
            return this;
        }

        @Override
        public Builder outer(Object value) {
            super.outer(value);
            return this;
        }

        @Override
        public Builder schema(HttpPartSchema value) {
            super.schema(value);
            return this;
        }

        @Override
        public Builder schemaDefault(HttpPartSchema value) {
            super.schemaDefault(value);
            return this;
        }
    }
}

