/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.bind.DatatypeConverter;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.collections.JsonList;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.AsciiSet;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.marshall.SimpleJson;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserReader;
import org.apache.juneau.reflect.MethodInfo;

public final class StringUtils {
    public static final Predicate<String> NOT_EMPTY = x -> StringUtils.isNotEmpty(x);
    private static final AsciiSet numberChars = AsciiSet.create("-xX.+-#pP0123456789abcdefABCDEF");
    private static final AsciiSet firstNumberChars = AsciiSet.create("+-.#0123456789");
    private static final AsciiSet octChars = AsciiSet.create("01234567");
    private static final AsciiSet decChars = AsciiSet.create("0123456789");
    private static final AsciiSet hexChars = AsciiSet.create("0123456789abcdefABCDEF");
    private static final char[] base64m1 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final AsciiSet unencodedChars = AsciiSet.create().ranges("a-z", "A-Z", "0-9").chars("-_.!~*'()\\").build();
    private static final AsciiSet unencodedCharsLax = unencodedChars.copy().chars(":@$,").chars("{}|\\^[]`").build();
    private static final AsciiSet httpHeaderChars = AsciiSet.create().chars("\t -").ranges("!-[", "]-}").build();
    private static final byte[] base64m2 = new byte[128];
    private static final Pattern fpRegex;
    static Map<Character, AsciiSet> ESCAPE_SETS;
    private static final AsciiSet MAP_ESCAPE_SET;
    private static final AsciiSet QUOTE_ESCAPE_SET;
    private static final char[] hexArray;
    private static final Map<Class<?>, Function<Object, String>> PRIMITIVE_ARRAY_STRINGIFIERS;
    private static final char[] HEX;
    private static final AsciiSet URL_ENCODE_PATHINFO_VALIDCHARS;
    private static final AsciiSet URI_CHARS;

    public static String parseNumberString(ParserReader r) throws IOException {
        r.mark();
        int c = 0;
        while ((c = r.read()) != -1) {
            if (numberChars.contains((char)c)) continue;
            r.unread();
            break;
        }
        return r.getMarked();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Number parseNumber(String s, Class<? extends Number> type) throws ParseException {
        if (s == null) {
            return null;
        }
        if (s.isEmpty()) {
            s = "0";
        }
        if (type == null) {
            type = Number.class;
        }
        try {
            boolean isAutoDetect = type == Number.class;
            boolean isDecimal = false;
            if (isAutoDetect) {
                isDecimal = StringUtils.isDecimal(s);
                if (isDecimal) {
                    type = s.length() > 20 ? Double.class : (s.length() >= 10 ? Long.class : Integer.class);
                } else {
                    if (!StringUtils.isFloat(s)) {
                        throw new NumberFormatException(s);
                    }
                    type = Double.class;
                }
            }
            if (type == Double.class || type == Double.TYPE) {
                Double d = Double.valueOf(s);
                Float f = Float.valueOf(s);
                if (isAutoDetect && !isDecimal && d.toString().equals(f.toString())) {
                    return f;
                }
                return d;
            }
            if (type == Float.class || type == Float.TYPE) {
                return Float.valueOf(s);
            }
            if (type == BigDecimal.class) {
                return new BigDecimal(s);
            }
            if (type == Long.class || type == Long.TYPE || type == AtomicLong.class) {
                try {
                    Long l = Long.decode(s);
                    if (type == AtomicLong.class) {
                        return new AtomicLong(l);
                    }
                    if (isAutoDetect && l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                        return l.intValue();
                    }
                    return l;
                }
                catch (NumberFormatException e) {
                    if (isAutoDetect) {
                        return Double.valueOf(s);
                    }
                    throw e;
                }
            }
            if (type == Integer.class || type == Integer.TYPE) {
                return Integer.decode(s);
            }
            if (type == Short.class || type == Short.TYPE) {
                return Short.decode(s);
            }
            if (type == Byte.class || type == Byte.TYPE) {
                return Byte.decode(s);
            }
            if (type == BigInteger.class) {
                return new BigInteger(s);
            }
            if (type == AtomicInteger.class) {
                return new AtomicInteger(Integer.decode(s));
            }
            throw new ParseException("Unsupported Number type: {0}", type.getName());
        }
        catch (NumberFormatException e) {
            throw new ParseException(e, "Invalid number: ''{0}'', class=''{1}''", s, type.getSimpleName());
        }
    }

    public static Character parseCharacter(Object o) throws ParseException {
        if (o == null) {
            return null;
        }
        String s = o.toString();
        if (s.length() == 0) {
            return null;
        }
        if (s.length() == 1) {
            return Character.valueOf(s.charAt(0));
        }
        throw new ParseException("Invalid character: ''{0}''", s);
    }

    public static boolean isNumeric(String s) {
        if (s == null || s.isEmpty() || !StringUtils.isFirstNumberChar(s.charAt(0))) {
            return false;
        }
        return StringUtils.isDecimal(s) || StringUtils.isFloat(s);
    }

    public static boolean isFirstNumberChar(char c) {
        return firstNumberChars.contains(c);
    }

    public static boolean isFloat(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        if (!firstNumberChars.contains(s.charAt(0))) {
            return s.equals("NaN") || s.equals("Infinity");
        }
        int i = 0;
        int length = s.length();
        char c = s.charAt(0);
        if (c == '+' || c == '-') {
            ++i;
        }
        if (i == length) {
            return false;
        }
        if ((c = s.charAt(i++)) == '.' || decChars.contains(c)) {
            return fpRegex.matcher(s).matches();
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isDecimal(String s) {
        if (s == null || s.isEmpty() || !firstNumberChars.contains(s.charAt(0))) {
            return false;
        }
        int i = 0;
        int length = s.length();
        char c = s.charAt(0);
        boolean isPrefixed = false;
        if (c == '+' || c == '-') {
            isPrefixed = true;
            ++i;
        }
        if (i == length) {
            return false;
        }
        if ((c = s.charAt(i++)) == '0' && length > (isPrefixed ? 2 : 1)) {
            if ((c = s.charAt(i++)) == 'x' || c == 'X') {
                for (int j = i; j < length; ++j) {
                    if (hexChars.contains(s.charAt(j))) continue;
                    return false;
                }
                return true;
            } else {
                if (!octChars.contains(c)) return false;
                for (int j = i; j < length; ++j) {
                    if (octChars.contains(s.charAt(j))) continue;
                    return false;
                }
            }
            return true;
        } else if (c == '#') {
            for (int j = i; j < length; ++j) {
                if (hexChars.contains(s.charAt(j))) continue;
                return false;
            }
            return true;
        } else {
            if (!decChars.contains(c)) return false;
            for (int j = i; j < length; ++j) {
                if (decChars.contains(s.charAt(j))) continue;
                return false;
            }
        }
        return true;
    }

    public static String join(Object[] tokens, String separator) {
        if (tokens == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(tokens[i]);
        }
        return sb.toString();
    }

    public static String join(Collection<?> tokens, String d) {
        if (tokens == null) {
            return null;
        }
        return StringUtils.join(tokens, d, new StringBuilder()).toString();
    }

    public static String join(List<?> tokens, String d) {
        if (tokens == null) {
            return null;
        }
        return StringUtils.join(tokens, d, new StringBuilder()).toString();
    }

    public static StringBuilder join(Collection<?> tokens, String d, StringBuilder sb) {
        if (tokens == null) {
            return sb;
        }
        Iterator<?> iter = tokens.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(d);
        }
        return sb;
    }

    public static StringBuilder join(List<?> tokens, String d, StringBuilder sb) {
        if (tokens == null) {
            return sb;
        }
        int j = tokens.size();
        for (int i = 0; i < j; ++i) {
            if (i > 0) {
                sb.append(d);
            }
            sb.append(tokens.get(i));
        }
        return sb;
    }

    public static String join(Object[] tokens, char d) {
        if (tokens == null) {
            return null;
        }
        if (tokens.length == 1) {
            return StringUtils.emptyIfNull(StringUtils.stringify(tokens[0]));
        }
        return StringUtils.join(tokens, d, new StringBuilder()).toString();
    }

    private static AsciiSet getEscapeSet(char c) {
        AsciiSet s = ESCAPE_SETS.get(Character.valueOf(c));
        if (s == null) {
            s = AsciiSet.create().chars(c, '\\').build();
            ESCAPE_SETS.put(Character.valueOf(c), s);
        }
        return s;
    }

    public static StringBuilder join(Object[] tokens, char d, StringBuilder sb) {
        if (tokens == null) {
            return sb;
        }
        for (int i = 0; i < tokens.length; ++i) {
            if (i > 0) {
                sb.append(d);
            }
            sb.append(tokens[i]);
        }
        return sb;
    }

    public static String join(int[] tokens, char d) {
        if (tokens == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            if (i > 0) {
                sb.append(d);
            }
            sb.append(tokens[i]);
        }
        return sb.toString();
    }

    public static String join(Collection<?> tokens, char d) {
        if (tokens == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<?> iter = tokens.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(d);
        }
        return sb.toString();
    }

    public static String join(List<?> tokens, char d) {
        if (tokens == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int j = tokens.size();
        for (int i = 0; i < j; ++i) {
            if (i > 0) {
                sb.append(d);
            }
            sb.append(tokens.get(i));
        }
        return sb.toString();
    }

    public static String joine(List<?> tokens, char d) {
        if (tokens == null) {
            return null;
        }
        AsciiSet as = StringUtils.getEscapeSet(d);
        StringBuilder sb = new StringBuilder();
        int j = tokens.size();
        for (int i = 0; i < j; ++i) {
            if (i > 0) {
                sb.append(d);
            }
            sb.append(StringUtils.escapeChars(StringUtils.stringify(tokens.get(i)), as));
        }
        return sb.toString();
    }

    public static String joinnl(Object[] tokens) {
        return StringUtils.join(tokens, '\n');
    }

    public static String[] split(String s) {
        return StringUtils.split(s, ',');
    }

    public static void split(String s, Consumer<String> consumer) {
        StringUtils.split(s, ',', consumer);
    }

    public static String[] split(String s, char c) {
        return StringUtils.split(s, c, Integer.MAX_VALUE);
    }

    public static void split(String s, char c, Consumer<String> consumer) {
        AsciiSet escapeChars = StringUtils.getEscapeSet(c);
        if (StringUtils.isEmpty(s)) {
            return;
        }
        if (s.indexOf(c) == -1) {
            consumer.accept(s);
            return;
        }
        int x1 = 0;
        int escapeCount = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\\') {
                ++escapeCount;
            } else if (s.charAt(i) == c && escapeCount % 2 == 0) {
                String s2 = s.substring(x1, i);
                String s3 = StringUtils.unEscapeChars(s2, escapeChars);
                consumer.accept(s3.trim());
                x1 = i + 1;
            }
            if (s.charAt(i) == '\\') continue;
            escapeCount = 0;
        }
        String s2 = s.substring(x1);
        String s3 = StringUtils.unEscapeChars(s2, escapeChars);
        consumer.accept(s3.trim());
    }

    public static String[] split(String s, char c, int limit) {
        AsciiSet escapeChars = StringUtils.getEscapeSet(c);
        if (s == null) {
            return null;
        }
        if (StringUtils.isEmpty(s)) {
            return new String[0];
        }
        if (s.indexOf(c) == -1) {
            return new String[]{s};
        }
        LinkedList<String> l = new LinkedList<String>();
        char[] sArray = s.toCharArray();
        int x1 = 0;
        int escapeCount = 0;
        --limit;
        for (int i = 0; i < sArray.length && limit > 0; ++i) {
            if (sArray[i] == '\\') {
                ++escapeCount;
            } else if (sArray[i] == c && escapeCount % 2 == 0) {
                String s2 = new String(sArray, x1, i - x1);
                String s3 = StringUtils.unEscapeChars(s2, escapeChars);
                l.add(s3.trim());
                --limit;
                x1 = i + 1;
            }
            if (sArray[i] == '\\') continue;
            escapeCount = 0;
        }
        String s2 = new String(sArray, x1, sArray.length - x1);
        String s3 = StringUtils.unEscapeChars(s2, escapeChars);
        l.add(s3.trim());
        return l.toArray(new String[l.size()]);
    }

    public static String[] split(String[] s, char c) {
        if (s == null) {
            return null;
        }
        LinkedList<String> l = new LinkedList<String>();
        for (String ss : s) {
            if (ss == null || ss.indexOf(c) == -1) {
                l.add(ss);
                continue;
            }
            Collections.addAll(l, StringUtils.split(ss, c));
        }
        return l.toArray(new String[l.size()]);
    }

    public static Map<String, String> splitMap(String s, boolean trim) {
        if (s == null) {
            return null;
        }
        if (StringUtils.isEmpty(s)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        int S1 = 1;
        int S2 = 2;
        int state = S1;
        char[] sArray = s.toCharArray();
        int x1 = 0;
        int escapeCount = 0;
        String key = null;
        for (int i = 0; i < sArray.length + 1; ++i) {
            int c;
            int n = c = i == sArray.length ? 44 : sArray[i];
            if (c == 92) {
                ++escapeCount;
            }
            if (escapeCount % 2 == 0) {
                if (state == S1) {
                    if (c == 61) {
                        key = s.substring(x1, i);
                        if (trim) {
                            key = StringUtils.trim(key);
                        }
                        key = StringUtils.unEscapeChars(key, MAP_ESCAPE_SET);
                        state = S2;
                        x1 = i + 1;
                    } else if (c == 44) {
                        key = s.substring(x1, i);
                        if (trim) {
                            key = StringUtils.trim(key);
                        }
                        key = StringUtils.unEscapeChars(key, MAP_ESCAPE_SET);
                        m.put(key, "");
                        state = S1;
                        x1 = i + 1;
                    }
                } else if (state == S2 && c == 44) {
                    String val = s.substring(x1, i);
                    if (trim) {
                        val = StringUtils.trim(val);
                    }
                    val = StringUtils.unEscapeChars(val, MAP_ESCAPE_SET);
                    m.put(key, val);
                    key = null;
                    x1 = i + 1;
                    state = S1;
                }
            }
            if (c == 92) continue;
            escapeCount = 0;
        }
        return m;
    }

    public static boolean containsAny(String s, char ... chars) {
        if (s == null) {
            return false;
        }
        int j = s.length();
        for (int i = 0; i < j; ++i) {
            char c = s.charAt(i);
            for (char c2 : chars) {
                if (c != c2) continue;
                return true;
            }
        }
        return false;
    }

    public static String[] splitQuoted(String s) {
        return StringUtils.splitQuoted(s, false);
    }

    public static String[] splitQuoted(String s, boolean keepQuotes) {
        if (s == null) {
            return null;
        }
        if (StringUtils.isEmpty(s = s.trim())) {
            return new String[0];
        }
        if (!StringUtils.containsAny(s, ' ', '\t', '\'', '\"')) {
            return new String[]{s};
        }
        int S1 = 1;
        int S2 = 2;
        int S3 = 3;
        int S4 = 4;
        int state = S1;
        boolean isInEscape = false;
        boolean needsUnescape = false;
        int mark = 0;
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (state == S1) {
                if (c == '\'') {
                    state = S2;
                    mark = keepQuotes ? i : i + 1;
                    continue;
                }
                if (c == '\"') {
                    state = S3;
                    mark = keepQuotes ? i : i + 1;
                    continue;
                }
                if (c == ' ' || c == '\t') continue;
                state = S4;
                mark = i;
                continue;
            }
            if (state == S2 || state == S3) {
                if (c == '\\') {
                    isInEscape = !isInEscape;
                    needsUnescape = !keepQuotes;
                    continue;
                }
                if (!isInEscape) {
                    if (c != (state == S2 ? (char)'\'' : '\"')) continue;
                    String s2 = s.substring(mark, keepQuotes ? i + 1 : i);
                    if (needsUnescape) {
                        s2 = StringUtils.unEscapeChars(s2, QUOTE_ESCAPE_SET);
                    }
                    l.add(s2);
                    state = S1;
                    needsUnescape = false;
                    isInEscape = false;
                    continue;
                }
                isInEscape = false;
                continue;
            }
            if (state != S4 || c != ' ' && c != '\t') continue;
            l.add(s.substring(mark, i));
            state = S1;
        }
        if (state == S4) {
            l.add(s.substring(mark));
        } else if (state == S2 || state == S3) {
            throw ThrowableUtils.runtimeException("Unmatched string quotes: {0}", s);
        }
        return l.toArray(new String[l.size()]);
    }

    public static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static boolean isEmpty(CharSequence s) {
        return s == null || s.length() == 0;
    }

    public static boolean isEmptyOrBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    public static boolean isNotEmpty(String s) {
        return !StringUtils.isEmpty(s);
    }

    public static boolean isNotEmpty(String s1, String s2) {
        return StringUtils.isNotEmpty(s1) || StringUtils.isNotEmpty(s2);
    }

    public static String nullIfEmpty(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        return s;
    }

    public static String emptyIfNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public static String emptyIfNull(Object o) {
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    public static String unEscapeChars(String s, AsciiSet escaped) {
        if (s == null || s.length() == 0) {
            return s;
        }
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (!escaped.contains(s.charAt(i))) continue;
            ++count;
        }
        if (count == 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length() - count);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' && i + 1 != s.length()) {
                char c2 = s.charAt(i + 1);
                if (escaped.contains(c2)) {
                    ++i;
                } else if (c2 == '\\') {
                    sb.append('\\');
                    ++i;
                }
            }
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }

    public static String escapeChars(String s, AsciiSet escaped) {
        if (s == null || s.length() == 0) {
            return s;
        }
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (!escaped.contains(s.charAt(i))) continue;
            ++count;
        }
        if (count == 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length() + count);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (escaped.contains(c)) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String decodeHex(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (c < ' ' || c > '~') {
                sb.append("[" + Integer.toHexString(c) + "]");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean startsWith(String s, char c) {
        int i;
        if (s != null && (i = s.length()) > 0) {
            return s.charAt(0) == c;
        }
        return false;
    }

    public static boolean endsWith(String s, char c) {
        int i;
        if (s != null && (i = s.length()) > 0) {
            return s.charAt(i - 1) == c;
        }
        return false;
    }

    public static boolean endsWith(String s, char ... c) {
        int i;
        if (s != null && (i = s.length()) > 0) {
            char c2 = s.charAt(i - 1);
            for (char cc : c) {
                if (c2 != cc) continue;
                return true;
            }
        }
        return false;
    }

    public static final char[] toHex2(int num) {
        if (num < 0 || num > 255) {
            throw new NumberFormatException("toHex2 can only be used on numbers between 0 and 255");
        }
        char[] n = new char[2];
        int a = num % 16;
        n[1] = (char)(a > 9 ? 65 + a - 10 : 48 + a);
        a = num / 16 % 16;
        n[0] = (char)(a > 9 ? 65 + a - 10 : 48 + a);
        return n;
    }

    public static final String toHex(byte b) {
        char[] c = new char[2];
        int v = b & 0xFF;
        c[0] = hexArray[v >>> 4];
        c[1] = hexArray[v & 0xF];
        return new String(c);
    }

    public static final String toReadableBytes(byte[] b) {
        StringBuilder sb = new StringBuilder();
        for (byte b2 : b) {
            sb.append(b2 < 32 || b2 > 122 ? String.format("[%02X]", b2) : (char)b2 + "   ");
        }
        sb.append("\n");
        for (byte b2 : b) {
            sb.append(String.format("[%02X]", b2));
        }
        return sb.toString();
    }

    public static final char[] toHex4(int num) {
        char[] n = new char[4];
        int a = num % 16;
        n[3] = (char)(a > 9 ? 65 + a - 10 : 48 + a);
        int base = 16;
        for (int i = 1; i < 4; ++i) {
            a = num / base % 16;
            base <<= 4;
            n[3 - i] = (char)(a > 9 ? 65 + a - 10 : 48 + a);
        }
        return n;
    }

    public static final char[] toHex8(long num) {
        char[] n = new char[8];
        long a = num % 16L;
        n[7] = (char)(a > 9L ? 65L + a - 10L : 48L + a);
        int base = 16;
        for (int i = 1; i < 8; ++i) {
            a = num / (long)base % 16L;
            base <<= 4;
            n[7 - i] = (char)(a > 9L ? 65L + a - 10L : 48L + a);
        }
        return n;
    }

    public static boolean eq(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static boolean eq(boolean caseInsensitive, String s1, String s2) {
        return caseInsensitive ? StringUtils.eqic(s1, s2) : StringUtils.eq(s1, s2);
    }

    public static int diffPosition(String s1, String s2) {
        int i;
        s1 = StringUtils.emptyIfNull(s1);
        s2 = StringUtils.emptyIfNull(s2);
        int len = Math.min(s1.length(), s2.length());
        for (i = 0; i < len; ++i) {
            int j = s1.charAt(i) - s2.charAt(i);
            if (j == 0) continue;
            return i;
        }
        if (i == len && s1.length() == s2.length()) {
            return -1;
        }
        return i;
    }

    public static int diffPositionIc(String s1, String s2) {
        int i;
        s1 = StringUtils.emptyIfNull(s1);
        s2 = StringUtils.emptyIfNull(s2);
        int len = Math.min(s1.length(), s2.length());
        for (i = 0; i < len; ++i) {
            int j = Character.toLowerCase(s1.charAt(i)) - Character.toLowerCase(s2.charAt(i));
            if (j == 0) continue;
            return i;
        }
        if (i == len && s1.length() == s2.length()) {
            return -1;
        }
        return i;
    }

    public static boolean eqic(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        return s1.equalsIgnoreCase(s2);
    }

    public static boolean ne(String s1, String s2) {
        return !StringUtils.eq(s1, s2);
    }

    public static boolean neic(String s1, String s2) {
        return !StringUtils.eqic(s1, s2);
    }

    public static String base64EncodeToString(String in) {
        if (in == null) {
            return null;
        }
        return StringUtils.base64Encode(in.getBytes(IOUtils.UTF8));
    }

    public static String base64Encode(byte[] in) {
        if (in == null) {
            return null;
        }
        int outLength = (in.length * 4 + 2) / 3;
        char[] out = new char[(in.length + 2) / 3 * 4];
        int iIn = 0;
        int iOut = 0;
        while (iIn < in.length) {
            int i0 = in[iIn++] & 0xFF;
            int i1 = iIn < in.length ? in[iIn++] & 0xFF : 0;
            int i2 = iIn < in.length ? in[iIn++] & 0xFF : 0;
            int o0 = i0 >>> 2;
            int o1 = (i0 & 3) << 4 | i1 >>> 4;
            int o2 = (i1 & 0xF) << 2 | i2 >>> 6;
            int o3 = i2 & 0x3F;
            out[iOut++] = base64m1[o0];
            out[iOut++] = base64m1[o1];
            out[iOut] = iOut < outLength ? base64m1[o2] : 61;
            int n = ++iOut < outLength ? base64m1[o3] : 61;
            out[iOut] = n;
            ++iOut;
        }
        return new String(out);
    }

    public static String base64DecodeToString(String in) {
        byte[] b = StringUtils.base64Decode(in);
        if (b == null) {
            return null;
        }
        return new String(b, IOUtils.UTF8);
    }

    public static byte[] base64Decode(String in) {
        int inLength;
        if (in == null) {
            return null;
        }
        byte[] bIn = in.getBytes(IOUtils.UTF8);
        Assertions.assertArg(bIn.length % 4 == 0, "Invalid BASE64 string length.  Must be multiple of 4.", new Object[0]);
        for (inLength = bIn.length; inLength > 0 && bIn[inLength - 1] == 61; --inLength) {
        }
        int outLength = inLength * 3 / 4;
        byte[] out = new byte[outLength];
        int iIn = 0;
        int iOut = 0;
        while (iIn < inLength) {
            byte i0 = bIn[iIn++];
            byte i1 = bIn[iIn++];
            int i2 = iIn < inLength ? bIn[iIn++] : 65;
            int i3 = iIn < inLength ? bIn[iIn++] : 65;
            byte b0 = base64m2[i0];
            byte b1 = base64m2[i1];
            byte b2 = base64m2[i2];
            byte b3 = base64m2[i3];
            int o0 = b0 << 2 | b1 >>> 4;
            int o1 = (b1 & 0xF) << 4 | b2 >>> 2;
            int o2 = (b2 & 3) << 6 | b3;
            out[iOut++] = (byte)o0;
            if (iOut < outLength) {
                out[iOut++] = (byte)o1;
            }
            if (iOut >= outLength) continue;
            out[iOut++] = (byte)o2;
        }
        return out;
    }

    public static String random(int numchars) {
        Random r = new Random();
        StringBuilder sb = new StringBuilder(numchars);
        for (int i = 0; i < numchars; ++i) {
            int c = r.nextInt(36) + 97;
            if (c > 122) {
                c -= 75;
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static String trim(String s) {
        if (s == null) {
            return null;
        }
        return s.trim();
    }

    public static String strip(String s) {
        if (s == null || s.length() <= 1) {
            return s;
        }
        return s.substring(1, s.length() - 1);
    }

    public static Date parseIsoDate(String date) throws IllegalArgumentException {
        if (StringUtils.isEmpty(date)) {
            return null;
        }
        return StringUtils.parseIsoCalendar(date).getTime();
    }

    public static Calendar parseIsoCalendar(String date) throws IllegalArgumentException {
        if (StringUtils.isEmpty(date)) {
            return null;
        }
        if ((date = date.trim().replace(' ', 'T')).indexOf(44) != -1) {
            date = date.substring(0, date.indexOf(44));
        }
        if (date.matches("\\d{4}")) {
            date = date + "-01-01T00:00:00";
        } else if (date.matches("\\d{4}\\-\\d{2}")) {
            date = date + "-01T00:00:00";
        } else if (date.matches("\\d{4}\\-\\d{2}\\-\\d{2}")) {
            date = date + "T00:00:00";
        } else if (date.matches("\\d{4}\\-\\d{2}\\-\\d{2}T\\d{2}")) {
            date = date + ":00:00";
        } else if (date.matches("\\d{4}\\-\\d{2}\\-\\d{2}T\\d{2}\\:\\d{2}")) {
            date = date + ":00";
        }
        return DatatypeConverter.parseDateTime((String)date);
    }

    public static String toIsoDate(Calendar c) {
        return DatatypeConverter.printDate((Calendar)c);
    }

    public static String toIsoDateTime(Calendar c) {
        return DatatypeConverter.printDateTime((Calendar)c);
    }

    public static String replaceVars(String s, Map<String, Object> m) {
        if (s == null) {
            return null;
        }
        if (m == null || m.isEmpty() || s.indexOf(123) == -1) {
            return s;
        }
        int S1 = 1;
        int S2 = 2;
        int state = S1;
        boolean hasInternalVar = false;
        int x = 0;
        int depth = 0;
        int length = s.length();
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (state == S1) {
                if (c == '{') {
                    state = S2;
                    x = i;
                    continue;
                }
                out.append(c);
                continue;
            }
            if (c == '{') {
                ++depth;
                hasInternalVar = true;
                continue;
            }
            if (c != '}') continue;
            if (depth > 0) {
                --depth;
                continue;
            }
            String key = s.substring(x + 1, i);
            key = hasInternalVar ? StringUtils.replaceVars(key, m) : key;
            hasInternalVar = false;
            if (!m.containsKey(key)) {
                out.append('{').append(key).append('}');
            } else {
                String v;
                Object val = m.get(key);
                if (val == null) {
                    val = "";
                }
                if ((v = val.toString()).indexOf(123) != -1) {
                    v = StringUtils.replaceVars(v, m);
                }
                out.append(v);
            }
            state = 1;
        }
        return out.toString();
    }

    public static String replaceUnicodeSequences(String s) {
        if (s.indexOf(92) == -1) {
            return s;
        }
        Pattern p = Pattern.compile("\\\\u(\\p{XDigit}{4})");
        Matcher m = p.matcher(s);
        StringBuffer sb = new StringBuffer(s.length());
        while (m.find()) {
            String ch = String.valueOf((char)Integer.parseInt(m.group(1), 16));
            m.appendReplacement(sb, Matcher.quoteReplacement(ch));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String unicodeSequence(char c) {
        StringBuilder sb = new StringBuilder(6);
        sb.append('\\').append('u');
        for (char cc : StringUtils.toHex4(c)) {
            sb.append(cc);
        }
        return sb.toString();
    }

    public static String stringify(Object o) {
        return o == null ? null : o.toString();
    }

    public static String stringifyDeep(Object o) {
        if (o == null) {
            return null;
        }
        if (!o.getClass().isArray()) {
            return o.toString();
        }
        if (o.getClass().getComponentType().isPrimitive()) {
            return PRIMITIVE_ARRAY_STRINGIFIERS.get(o.getClass()).apply(o);
        }
        return Arrays.deepToString((Object[])o);
    }

    public static String fromHexToUTF8(String hex) {
        ByteBuffer buff = ByteBuffer.allocate(hex.length() / 2);
        for (int i = 0; i < hex.length(); i += 2) {
            buff.put((byte)Integer.parseInt(hex.substring(i, i + 2), 16));
        }
        ((Buffer)buff).rewind();
        Charset cs = Charset.forName("UTF-8");
        return cs.decode(buff).toString();
    }

    public static String fromSpacedHexToUTF8(String hex) {
        ByteBuffer buff = ByteBuffer.allocate((hex.length() + 1) / 3);
        for (int i = 0; i < hex.length(); i += 3) {
            buff.put((byte)Integer.parseInt(hex.substring(i, i + 2), 16));
        }
        ((Buffer)buff).rewind();
        Charset cs = Charset.forName("UTF-8");
        return cs.decode(buff).toString();
    }

    public static String toHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            sb.append(HEX[v >>> 4]).append(HEX[v & 0xF]);
        }
        return sb.toString();
    }

    public static String toSpacedHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        for (int j = 0; j < bytes.length; ++j) {
            if (j > 0) {
                sb.append(' ');
            }
            int v = bytes[j] & 0xFF;
            sb.append(HEX[v >>> 4]).append(HEX[v & 0xF]);
        }
        return sb.toString();
    }

    public static byte[] fromHex(String hex) {
        ByteBuffer buff = ByteBuffer.allocate(hex.length() / 2);
        for (int i = 0; i < hex.length(); i += 2) {
            buff.put((byte)Integer.parseInt(hex.substring(i, i + 2), 16));
        }
        ((Buffer)buff).rewind();
        return buff.array();
    }

    public static byte[] fromSpacedHex(String hex) {
        ByteBuffer buff = ByteBuffer.allocate((hex.length() + 1) / 3);
        for (int i = 0; i < hex.length(); i += 3) {
            buff.put((byte)Integer.parseInt(hex.substring(i, i + 2), 16));
        }
        ((Buffer)buff).rewind();
        return buff.array();
    }

    public static String repeat(int count, String pattern) {
        StringBuilder sb = new StringBuilder(pattern.length() * count);
        for (int i = 0; i < count; ++i) {
            sb.append(pattern);
        }
        return sb.toString();
    }

    public static String trimStart(String s) {
        if (s != null) {
            while (s.length() > 0 && Character.isWhitespace(s.charAt(0))) {
                s = s.substring(1);
            }
        }
        return s;
    }

    public static String trimEnd(String s) {
        if (s != null) {
            while (s.length() > 0 && Character.isWhitespace(s.charAt(s.length() - 1))) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public static boolean isOneOf(String s, String ... values) {
        for (int i = 0; i < values.length; ++i) {
            if (!StringUtils.eq(s, values[i])) continue;
            return true;
        }
        return false;
    }

    public static String trimSlashes(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        while (StringUtils.endsWith(s, '/')) {
            s = s.substring(0, s.length() - 1);
        }
        while (s.length() > 0 && s.charAt(0) == '/') {
            s = s.substring(1);
        }
        return s;
    }

    public static String trimSlashesAndSpaces(String s) {
        if (s == null) {
            return null;
        }
        while (s.length() > 0 && (s.charAt(s.length() - 1) == '/' || Character.isWhitespace(s.charAt(s.length() - 1)))) {
            s = s.substring(0, s.length() - 1);
        }
        while (s.length() > 0 && (s.charAt(0) == '/' || Character.isWhitespace(s.charAt(0)))) {
            s = s.substring(1);
        }
        return s;
    }

    public static String trimTrailingSlashes(String s) {
        if (s == null) {
            return null;
        }
        while (StringUtils.endsWith(s, '/')) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String trimLeadingSlashes(String s) {
        if (s == null) {
            return null;
        }
        while (s.length() > 0 && s.charAt(0) == '/') {
            s = s.substring(1);
        }
        return s;
    }

    public static String urlEncodePath(Object o) {
        if (o == null) {
            return null;
        }
        String s = StringUtils.stringify(o);
        boolean needsEncode = false;
        for (int i = 0; i < s.length() && !needsEncode; ++i) {
            needsEncode = URL_ENCODE_PATHINFO_VALIDCHARS.contains(s.charAt(i));
        }
        if (!needsEncode) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        CharArrayWriter caw = new CharArrayWriter();
        int caseDiff = 32;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (URL_ENCODE_PATHINFO_VALIDCHARS.contains(c)) {
                sb.append(c);
                ++i;
                continue;
            }
            if (c == ' ') {
                sb.append('+');
                ++i;
                continue;
            }
            do {
                char d;
                caw.write(c);
                if (c < '\ud800' || c > '\udbff' || i + 1 >= s.length() || (d = s.charAt(i + 1)) < '\udc00' || d > '\udfff') continue;
                caw.write(d);
                ++i;
            } while (++i < s.length() && !URL_ENCODE_PATHINFO_VALIDCHARS.contains(c = s.charAt(i)));
            caw.flush();
            String s2 = new String(caw.toCharArray());
            byte[] ba = s2.getBytes(IOUtils.UTF8);
            for (int j = 0; j < ba.length; ++j) {
                sb.append('%');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - caseDiff);
                }
                sb.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - caseDiff);
                }
                sb.append(ch);
            }
            caw.reset();
        }
        return sb.toString();
    }

    public static String urlDecode(String s) {
        if (s == null) {
            return s;
        }
        boolean needsDecode = false;
        for (int i = 0; i < s.length() && !needsDecode; ++i) {
            char c = s.charAt(i);
            if (c != '+' && c != '%') continue;
            needsDecode = true;
        }
        if (needsDecode) {
            try {
                return URLDecoder.decode(s, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return s;
    }

    public static String urlEncode(String s) {
        if (s == null) {
            return null;
        }
        boolean needsEncode = false;
        for (int i = 0; i < s.length() && !needsEncode; needsEncode |= !unencodedChars.contains(s.charAt(i)), ++i) {
        }
        if (needsEncode) {
            try {
                return URLEncoder.encode(s, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return s;
    }

    public static String urlEncodeLax(String s) {
        if (s == null) {
            return null;
        }
        boolean needsEncode = false;
        for (int i = 0; i < s.length() && !needsEncode; needsEncode |= !unencodedCharsLax.contains(s.charAt(i)), ++i) {
        }
        if (needsEncode) {
            StringBuilder sb = new StringBuilder(s.length() * 2);
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (unencodedCharsLax.contains(c)) {
                    sb.append(c);
                    continue;
                }
                if (c == ' ') {
                    sb.append("+");
                    continue;
                }
                if (c <= '\u007f') {
                    sb.append('%').append(StringUtils.toHex2(c));
                    continue;
                }
                try {
                    sb.append(URLEncoder.encode("" + c, "UTF-8"));
                    continue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            s = sb.toString();
        }
        return s;
    }

    public static char firstNonWhitespaceChar(String s) {
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                if (Character.isWhitespace(s.charAt(i))) continue;
                return s.charAt(i);
            }
        }
        return '\u0000';
    }

    public static char lastNonWhitespaceChar(String s) {
        if (s != null) {
            for (int i = s.length() - 1; i >= 0; --i) {
                if (Character.isWhitespace(s.charAt(i))) continue;
                return s.charAt(i);
            }
        }
        return '\u0000';
    }

    public static char charAt(String s, int i) {
        if (s == null || i < 0 || i >= s.length()) {
            return '\u0000';
        }
        return s.charAt(i);
    }

    public static boolean isAbsoluteUri(String s) {
        if (StringUtils.isEmpty(s)) {
            return false;
        }
        int S1 = 1;
        int S2 = 2;
        int S3 = 3;
        int S4 = 4;
        int S5 = 5;
        int state = S1;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (state == S1) {
                if (c >= 'a' && c <= 'z') {
                    state = S2;
                    continue;
                }
                return false;
            }
            if (state == S2) {
                if (c == ':') {
                    state = S3;
                    continue;
                }
                if (c >= 'a' && c <= 'z') continue;
                return false;
            }
            if (state == S3) {
                if (c == '/') {
                    state = S4;
                    continue;
                }
                return false;
            }
            if (state == S4) {
                if (c == '/') {
                    state = S5;
                    continue;
                }
                return false;
            }
            if (state != S5) continue;
            return true;
        }
        return false;
    }

    public static boolean isUri(String s) {
        if (StringUtils.isEmpty(s)) {
            return false;
        }
        int S1 = 1;
        int S2 = 2;
        int S3 = 3;
        int S4 = 4;
        int state = S1;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (state == S1) {
                if (c >= 'a' && c <= 'z') {
                    state = S2;
                    continue;
                }
                return false;
            }
            if (state == S2) {
                if (c >= 'a' && c <= 'z') {
                    state = S3;
                    continue;
                }
                return false;
            }
            if (state == S3) {
                if (c == ':') {
                    state = S4;
                    continue;
                }
                if (c >= 'a' && c <= 'z') continue;
                return false;
            }
            if (state != S4) continue;
            return c == '/';
        }
        return false;
    }

    public static String getAuthorityUri(String s) {
        int S1 = 1;
        int S2 = 2;
        int S3 = 3;
        int S4 = 4;
        int S5 = 5;
        int S6 = 6;
        int state = S1;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (state == S1) {
                if (c >= 'a' && c <= 'z') {
                    state = S2;
                    continue;
                }
                return s;
            }
            if (state == S2) {
                if (c == ':') {
                    state = S3;
                    continue;
                }
                if (c >= 'a' && c <= 'z') continue;
                return s;
            }
            if (state == S3) {
                if (c == '/') {
                    state = S4;
                    continue;
                }
                return s;
            }
            if (state == S4) {
                if (c == '/') {
                    state = S5;
                    continue;
                }
                return s;
            }
            if (state == S5) {
                if (c != '/') {
                    state = S6;
                    continue;
                }
                return s;
            }
            if (state != S6 || c != '/') continue;
            return s.substring(0, i);
        }
        return s;
    }

    public static URI toURI(Object o) {
        if (o == null || o instanceof URI) {
            return (URI)o;
        }
        try {
            return new URI(o.toString());
        }
        catch (URISyntaxException e) {
            throw ThrowableUtils.runtimeException(e);
        }
    }

    public static String firstNonEmpty(String ... s) {
        for (String ss : s) {
            if (!StringUtils.isNotEmpty(ss)) continue;
            return ss;
        }
        return null;
    }

    public static int indexOf(String s, char ... c) {
        if (s == null) {
            return -1;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c2 = s.charAt(i);
            for (char cc : c) {
                if (c2 != cc) continue;
                return i;
            }
        }
        return -1;
    }

    public static String format(String pattern, Object ... args) {
        if (args == null || args.length == 0) {
            return pattern;
        }
        Object[] args2 = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            args2[i] = StringUtils.convertToReadable(args[i]);
        }
        int c = StringUtils.countChars(pattern, '\'');
        if (c % 2 != 0) {
            throw new AssertionError((Object)("Dangling single quote found in pattern: " + pattern));
        }
        String msg = MessageFormat.format(pattern, args2);
        return msg;
    }

    private static String convertToReadable(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof ClassMeta) {
            return ((ClassMeta)((Object)o)).getFullName();
        }
        if (o instanceof Class) {
            return ((Class)((Object)o)).getName();
        }
        if (o instanceof Method) {
            return MethodInfo.of((Method)((Object)o)).getShortName();
        }
        if (o.getClass().isArray()) {
            o = ArrayUtils.toObjectList(o);
        }
        return o.toString();
    }

    public static int parseIntWithSuffix(String s) {
        Assertions.assertArgNotNull("s", s);
        int m = StringUtils.multiplier(s);
        if (m == 1) {
            return Integer.decode(s);
        }
        return Integer.decode(s.substring(0, s.length() - 1).trim()) * m;
    }

    private static int multiplier(String s) {
        char c = (s.length() == 0 ? null : Character.valueOf(s.charAt(s.length() - 1))).charValue();
        if (c == 'G') {
            return 0x40000000;
        }
        if (c == 'M') {
            return 0x100000;
        }
        if (c == 'K') {
            return 1024;
        }
        if (c == 'g') {
            return 1000000000;
        }
        if (c == 'm') {
            return 1000000;
        }
        if (c == 'k') {
            return 1000;
        }
        return 1;
    }

    public static long parseLongWithSuffix(String s) {
        Assertions.assertArgNotNull("s", s);
        long m = StringUtils.multiplier2(s);
        if (m == 1L) {
            return Long.decode(s);
        }
        return Long.decode(s.substring(0, s.length() - 1).trim()) * m;
    }

    private static long multiplier2(String s) {
        char c = (s.length() == 0 ? null : Character.valueOf(s.charAt(s.length() - 1))).charValue();
        if (c == 'P') {
            return 0L;
        }
        if (c == 'T') {
            return 0L;
        }
        if (c == 'G') {
            return 0x40000000L;
        }
        if (c == 'M') {
            return 0x100000L;
        }
        if (c == 'K') {
            return 1024L;
        }
        if (c == 'p') {
            return -1530494976L;
        }
        if (c == 't') {
            return -727379968L;
        }
        if (c == 'g') {
            return 1000000000L;
        }
        if (c == 'm') {
            return 1000000L;
        }
        if (c == 'k') {
            return 1000L;
        }
        return 1L;
    }

    public static boolean contains(String value, CharSequence substring) {
        return value == null ? false : value.contains(substring);
    }

    public static boolean isJsonArray(Object o, boolean ignoreWhitespaceAndComments) {
        if (o instanceof CharSequence) {
            String s = o.toString();
            if (!ignoreWhitespaceAndComments) {
                return s.startsWith("[") && s.endsWith("]");
            }
            if (StringUtils.firstRealCharacter(s) != 91) {
                return false;
            }
            int i = s.lastIndexOf(93);
            if (i == -1) {
                return false;
            }
            return StringUtils.firstRealCharacter(s = s.substring(i + 1)) == -1;
        }
        return false;
    }

    public static JsonList parseListOrCdl(String s) throws ParseException {
        if (StringUtils.isEmpty(s)) {
            return null;
        }
        if (!StringUtils.isJsonArray(s, true)) {
            return new JsonList(StringUtils.split(s.trim(), ','));
        }
        return new JsonList(s);
    }

    public static boolean isJson(String s) {
        if (s == null) {
            return false;
        }
        char c1 = StringUtils.firstNonWhitespaceChar(s);
        char c2 = StringUtils.lastNonWhitespaceChar(s);
        if (c1 == '{' && c2 == '}' || c1 == '[' && c2 == ']' || c1 == '\'' && c2 == '\'') {
            return true;
        }
        return StringUtils.isOneOf(s, "true", "false", "null") || StringUtils.isNumeric(s);
    }

    public static boolean isJsonObject(Object o, boolean ignoreWhitespaceAndComments) {
        if (o instanceof CharSequence) {
            String s = o.toString();
            if (!ignoreWhitespaceAndComments) {
                return s.startsWith("{") && s.endsWith("}");
            }
            if (StringUtils.firstRealCharacter(s) != 123) {
                return false;
            }
            int i = s.lastIndexOf(125);
            if (i == -1) {
                return false;
            }
            return StringUtils.firstRealCharacter(s = s.substring(i + 1)) == -1;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int firstRealCharacter(String s) {
        try (StringReader r = new StringReader(s);){
            int c = 0;
            while ((c = r.read()) != -1) {
                if (Character.isWhitespace(c)) continue;
                if (c != 47) {
                    int n = c;
                    return n;
                }
                StringUtils.skipComments(r);
            }
            int n = -1;
            return n;
        }
        catch (Exception e) {
            throw ThrowableUtils.runtimeException(e);
        }
    }

    private static void skipComments(StringReader r) throws IOException {
        block3: {
            int c;
            block2: {
                c = r.read();
                if (c != 42) break block2;
                while (c != -1) {
                    c = r.read();
                    if (c != 42 || (c = r.read()) != 47) continue;
                    return;
                }
                break block3;
            }
            if (c != 47) break block3;
            while (c != -1) {
                c = r.read();
                if (c != -1 && c != 10) continue;
                return;
            }
        }
    }

    public static String getNumberedLines(String s) {
        return StringUtils.getNumberedLines(s, 1, Integer.MAX_VALUE);
    }

    public static String getNumberedLines(String s, int start, int end) {
        if (s == null) {
            return null;
        }
        String[] lines = s.split("[\r\n]+");
        int digits = String.valueOf(lines.length).length();
        if (start < 1) {
            start = 1;
        }
        if (end < 0) {
            end = Integer.MAX_VALUE;
        }
        if (end > lines.length) {
            end = lines.length;
        }
        StringBuilder sb = new StringBuilder();
        for (String l : Arrays.asList(lines).subList(start - 1, end)) {
            sb.append(String.format("%0" + digits + "d", start++)).append(": ").append(l).append("\n");
        }
        return sb.toString();
    }

    public static int compare(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null) {
            return Integer.MIN_VALUE;
        }
        if (s2 == null) {
            return Integer.MAX_VALUE;
        }
        return s1.compareTo(s2);
    }

    public static char firstChar(String s) {
        if (s == null || s.length() == 0) {
            return '\u0000';
        }
        return s.charAt(0);
    }

    public static Pattern getMatchPattern(String s) {
        return StringUtils.getMatchPattern(s, 0);
    }

    public static Pattern getMatchPattern(String s, int flags) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\\Q");
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '*') {
                sb.append("\\E").append(".*").append("\\Q");
                continue;
            }
            if (c == '?') {
                sb.append("\\E").append(".").append("\\Q");
                continue;
            }
            sb.append(c);
        }
        sb.append("\\E");
        return Pattern.compile(sb.toString(), flags);
    }

    public static long getDuration(String s) {
        long l;
        char c;
        int i;
        if (StringUtils.isEmpty(s = StringUtils.trim(s))) {
            return -1L;
        }
        for (i = 0; i < s.length() && (c = s.charAt(i)) >= '0' && c <= '9'; ++i) {
        }
        if (i == s.length()) {
            l = Long.parseLong(s);
        } else {
            l = Long.parseLong(s.substring(0, i).trim());
            String r = s.substring(i).trim().toLowerCase();
            if (r.startsWith("s")) {
                l *= 1000L;
            } else if (r.startsWith("m")) {
                l *= 60000L;
            } else if (r.startsWith("h")) {
                l *= 3600000L;
            } else if (r.startsWith("d")) {
                l *= 86400000L;
            } else if (r.startsWith("w")) {
                l *= 604800000L;
            }
        }
        return l;
    }

    public static String stripInvalidHttpHeaderChars(String s) {
        if (s == null) {
            return null;
        }
        boolean needsReplace = false;
        for (int i = 0; i < s.length() && !needsReplace; needsReplace |= httpHeaderChars.contains(s.charAt(i)), ++i) {
        }
        if (!needsReplace) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!httpHeaderChars.contains(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String abbreviate(String in, int length) {
        if (in == null || in.length() <= length || in.length() <= 3) {
            return in;
        }
        return in.substring(0, length - 3) + "...";
    }

    public static String[] splitMethodArgs(String s) {
        if (s == null) {
            return null;
        }
        if (StringUtils.isEmpty(s)) {
            return new String[0];
        }
        if (s.indexOf(44) == -1) {
            return new String[]{s};
        }
        LinkedList<String> l = new LinkedList<String>();
        char[] sArray = s.toCharArray();
        int x1 = 0;
        int paramDepth = 0;
        for (int i = 0; i < sArray.length; ++i) {
            char c = s.charAt(i);
            if (c == '>') {
                ++paramDepth;
                continue;
            }
            if (c == '<') {
                --paramDepth;
                continue;
            }
            if (c != ',' || paramDepth != 0) continue;
            String s2 = new String(sArray, x1, i - x1);
            l.add(s2.trim());
            x1 = i + 1;
        }
        String s2 = new String(sArray, x1, sArray.length - x1);
        l.add(s2.trim());
        return l.toArray(new String[l.size()]);
    }

    public static String fixUrl(String in) {
        if (in == null) {
            return null;
        }
        StringBuilder sb = null;
        int m = 0;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c > '\u007f' || URI_CHARS.contains(c)) continue;
            sb = StringUtils.append(sb, in.substring(m, i));
            if (c == ' ') {
                sb.append("+");
            } else {
                sb.append('%').append(StringUtils.toHex2(c));
            }
            m = i + 1;
        }
        if (sb != null) {
            sb.append(in.substring(m));
            return sb.toString();
        }
        return in;
    }

    private static StringBuilder append(StringBuilder sb, String in) {
        if (sb == null) {
            return new StringBuilder(in);
        }
        sb.append(in);
        return sb;
    }

    public static int countChars(String s, char c) {
        int count = 0;
        if (s == null) {
            return count;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public static final byte[] compress(String contents) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(contents.length() >> 1);
        try (GZIPOutputStream gos = new GZIPOutputStream(baos);){
            gos.write(contents.getBytes());
            gos.finish();
            gos.flush();
        }
        return baos.toByteArray();
    }

    public static final String decompress(byte[] is) throws Exception {
        return IOUtils.read(new GZIPInputStream(new ByteArrayInputStream(is)));
    }

    public static final String json(Object o) {
        return SimpleJson.DEFAULT == null ? StringUtils.stringify(o) : SimpleJson.DEFAULT.toString(o);
    }

    public static final String cdl(Object o) {
        if (o == null) {
            return null;
        }
        if (o.getClass().isArray()) {
            StringBuilder sb = new StringBuilder();
            int j = Array.getLength(o);
            for (int i = 0; i < j; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(Array.get(o, i));
            }
            return sb.toString();
        }
        if (o instanceof Collection) {
            return StringUtils.join((Collection)o, ", ");
        }
        return o.toString();
    }

    static {
        for (int i = 0; i < 64; ++i) {
            StringUtils.base64m2[StringUtils.base64m1[i]] = (byte)i;
        }
        fpRegex = Pattern.compile("[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*");
        ESCAPE_SETS = new ConcurrentHashMap<Character, AsciiSet>();
        MAP_ESCAPE_SET = AsciiSet.create(",=\\");
        QUOTE_ESCAPE_SET = AsciiSet.create("\"'\\");
        hexArray = "0123456789ABCDEF".toCharArray();
        PRIMITIVE_ARRAY_STRINGIFIERS = new HashMap();
        PRIMITIVE_ARRAY_STRINGIFIERS.put(boolean[].class, x -> Arrays.toString((boolean[])x));
        PRIMITIVE_ARRAY_STRINGIFIERS.put(byte[].class, x -> Arrays.toString((byte[])x));
        PRIMITIVE_ARRAY_STRINGIFIERS.put(char[].class, x -> Arrays.toString((char[])x));
        PRIMITIVE_ARRAY_STRINGIFIERS.put(double[].class, x -> Arrays.toString((double[])x));
        PRIMITIVE_ARRAY_STRINGIFIERS.put(float[].class, x -> Arrays.toString((float[])x));
        PRIMITIVE_ARRAY_STRINGIFIERS.put(int[].class, x -> Arrays.toString((int[])x));
        PRIMITIVE_ARRAY_STRINGIFIERS.put(long[].class, x -> Arrays.toString((long[])x));
        PRIMITIVE_ARRAY_STRINGIFIERS.put(short[].class, x -> Arrays.toString((short[])x));
        HEX = "0123456789ABCDEF".toCharArray();
        URL_ENCODE_PATHINFO_VALIDCHARS = AsciiSet.create().ranges("a-z", "A-Z", "0-9").chars("-_.*/()").build();
        URI_CHARS = AsciiSet.create().chars("?#+%;/:@&=+$,-_.!~*'()").range('0', '9').range('A', 'Z').range('a', 'z').build();
    }
}

