/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.mail;

import java.util.List;
import java.util.UUID;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.core.Username;
import org.apache.james.mailbox.postgres.PostgresMailboxId;
import org.apache.james.mailbox.postgres.mail.PostgresMailboxMemberDataDefinition;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresMailboxMemberDAO {
    private final PostgresExecutor postgresExecutor;

    public PostgresMailboxMemberDAO(PostgresExecutor postgresExecutor) {
        this.postgresExecutor = postgresExecutor;
    }

    public Flux<PostgresMailboxId> findMailboxIdByUsername(Username username) {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(PostgresMailboxMemberDataDefinition.PostgresMailboxMemberTable.MAILBOX_ID).from(PostgresMailboxMemberDataDefinition.PostgresMailboxMemberTable.TABLE_NAME).where(PostgresMailboxMemberDataDefinition.PostgresMailboxMemberTable.USER_NAME.eq((Object)username.asString())))).map(record -> PostgresMailboxId.of((UUID)record.get(PostgresMailboxMemberDataDefinition.PostgresMailboxMemberTable.MAILBOX_ID)));
    }

    public Mono<Void> insert(PostgresMailboxId mailboxId, List<Username> usernames) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.insertInto(PostgresMailboxMemberDataDefinition.PostgresMailboxMemberTable.TABLE_NAME, PostgresMailboxMemberDataDefinition.PostgresMailboxMemberTable.USER_NAME, PostgresMailboxMemberDataDefinition.PostgresMailboxMemberTable.MAILBOX_ID).valuesOfRecords(usernames.stream().map(username -> dslContext.newRecord(PostgresMailboxMemberDataDefinition.PostgresMailboxMemberTable.USER_NAME, PostgresMailboxMemberDataDefinition.PostgresMailboxMemberTable.MAILBOX_ID).value1((Object)username.asString()).value2((Object)mailboxId.asUuid())).toList()).onConflictDoNothing()));
    }

    public Mono<Void> delete(PostgresMailboxId mailboxId, List<Username> usernames) {
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.batch(usernames.stream().map(username -> dslContext.deleteFrom(PostgresMailboxMemberDataDefinition.PostgresMailboxMemberTable.TABLE_NAME).where(PostgresMailboxMemberDataDefinition.PostgresMailboxMemberTable.USER_NAME.eq((Object)username.asString()).and(PostgresMailboxMemberDataDefinition.PostgresMailboxMemberTable.MAILBOX_ID.eq((Object)mailboxId.asUuid())))).toList())));
    }
}

