/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.util.CryptoHelper;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.NullOutputStream;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.File;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ToolInvocationLogDetails {
    private final boolean logInvocation;
    @NotNull
    private final PrintStream toolErrorStream;
    @NotNull
    private final Set<File> logFiles;
    @NotNull
    private final String commandName;
    @NotNull
    private final String invocationID;

    private ToolInvocationLogDetails(boolean logInvocation, @NotNull String commandName, @Nullable String invocationID, @Nullable Set<File> logFiles, @NotNull PrintStream toolErrorStream) {
        this.logInvocation = logInvocation;
        this.commandName = commandName;
        this.toolErrorStream = toolErrorStream;
        this.invocationID = invocationID == null ? CryptoHelper.getRandomUUID().toString() : invocationID;
        this.logFiles = logFiles == null ? Collections.emptySet() : Collections.unmodifiableSet(logFiles);
    }

    @NotNull
    static ToolInvocationLogDetails createDoNotLogDetails(@NotNull String commandName) {
        return new ToolInvocationLogDetails(false, commandName, "", Collections.emptySet(), NullOutputStream.getPrintStream());
    }

    @NotNull
    static ToolInvocationLogDetails createLogDetails(@NotNull String commandName, @Nullable String invocationID, @NotNull Set<File> logFiles, @NotNull PrintStream toolErrorStream) {
        return new ToolInvocationLogDetails(true, commandName, invocationID, logFiles, toolErrorStream);
    }

    @NotNull
    public String getCommandName() {
        return this.commandName;
    }

    public boolean logInvocation() {
        return this.logInvocation;
    }

    @NotNull
    public String getInvocationID() {
        return this.invocationID;
    }

    @NotNull
    public Set<File> getLogFiles() {
        return this.logFiles;
    }

    @NotNull
    public PrintStream getToolErrorStream() {
        return this.toolErrorStream;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("ToolInvocationLogDetails(commandName='");
        buffer.append(this.commandName);
        buffer.append("', logInvocation=");
        buffer.append(this.logInvocation);
        if (this.logInvocation) {
            buffer.append(", invocationID='");
            buffer.append(this.invocationID);
            buffer.append("', logFiles={");
            Iterator<File> fileIterator = this.logFiles.iterator();
            while (fileIterator.hasNext()) {
                buffer.append('\'');
                buffer.append(fileIterator.next().getAbsolutePath());
                buffer.append('\'');
                if (!fileIterator.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

