/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1Set;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ContentSyncInfoType;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ContentSyncInfoIntermediateResponse
extends IntermediateResponse {
    @NotNull
    public static final String SYNC_INFO_OID = "1.3.6.1.4.1.4203.1.9.1.4";
    private static final long serialVersionUID = 4464376009337157433L;
    @Nullable
    private final ASN1OctetString cookie;
    private final boolean refreshDeletes;
    private final boolean refreshDone;
    @NotNull
    private final ContentSyncInfoType type;
    @Nullable
    private final List<UUID> entryUUIDs;

    private ContentSyncInfoIntermediateResponse(@NotNull ContentSyncInfoType type, @Nullable ASN1OctetString value, @Nullable ASN1OctetString cookie, boolean refreshDone, boolean refreshDeletes, @Nullable List<UUID> entryUUIDs, Control ... controls) {
        super(SYNC_INFO_OID, value, controls);
        this.type = type;
        this.cookie = cookie;
        this.refreshDone = refreshDone;
        this.refreshDeletes = refreshDeletes;
        this.entryUUIDs = entryUUIDs;
    }

    @NotNull
    public static ContentSyncInfoIntermediateResponse createNewCookieResponse(@NotNull ASN1OctetString cookie, Control ... controls) {
        Validator.ensureNotNull(cookie);
        ContentSyncInfoType type = ContentSyncInfoType.NEW_COOKIE;
        return new ContentSyncInfoIntermediateResponse(type, ContentSyncInfoIntermediateResponse.encodeValue(type, cookie, false, null, false), cookie, false, false, null, controls);
    }

    @NotNull
    public static ContentSyncInfoIntermediateResponse createRefreshDeleteResponse(@Nullable ASN1OctetString cookie, boolean refreshDone, Control ... controls) {
        ContentSyncInfoType type = ContentSyncInfoType.REFRESH_DELETE;
        return new ContentSyncInfoIntermediateResponse(type, ContentSyncInfoIntermediateResponse.encodeValue(type, cookie, refreshDone, null, false), cookie, refreshDone, false, null, controls);
    }

    @NotNull
    public static ContentSyncInfoIntermediateResponse createRefreshPresentResponse(@Nullable ASN1OctetString cookie, boolean refreshDone, Control ... controls) {
        ContentSyncInfoType type = ContentSyncInfoType.REFRESH_PRESENT;
        return new ContentSyncInfoIntermediateResponse(type, ContentSyncInfoIntermediateResponse.encodeValue(type, cookie, refreshDone, null, false), cookie, refreshDone, false, null, controls);
    }

    @NotNull
    public static ContentSyncInfoIntermediateResponse createSyncIDSetResponse(@Nullable ASN1OctetString cookie, @NotNull List<UUID> entryUUIDs, boolean refreshDeletes, Control ... controls) {
        Validator.ensureNotNull(entryUUIDs);
        ContentSyncInfoType type = ContentSyncInfoType.SYNC_ID_SET;
        return new ContentSyncInfoIntermediateResponse(type, ContentSyncInfoIntermediateResponse.encodeValue(type, cookie, false, entryUUIDs, refreshDeletes), cookie, false, refreshDeletes, Collections.unmodifiableList(entryUUIDs), controls);
    }

    @NotNull
    public static ContentSyncInfoIntermediateResponse decode(@NotNull IntermediateResponse r) throws LDAPException {
        ASN1Element valueElement;
        ASN1OctetString value = r.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SYNC_INFO_IR_NO_VALUE.get());
        }
        try {
            valueElement = ASN1Element.decode(value.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SYNC_INFO_IR_VALUE_NOT_ELEMENT.get(StaticUtils.getExceptionMessage(e)), e);
        }
        ContentSyncInfoType type = ContentSyncInfoType.valueOf(valueElement.getType());
        if (type == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SYNC_INFO_IR_VALUE_UNRECOGNIZED_TYPE.get(StaticUtils.toHex(valueElement.getType())));
        }
        ASN1OctetString cookie = null;
        boolean refreshDone = false;
        boolean refreshDeletes = false;
        ArrayList<UUID> entryUUIDs = null;
        try {
            switch (type) {
                case NEW_COOKIE: {
                    cookie = new ASN1OctetString(valueElement.getValue());
                    break;
                }
                case REFRESH_DELETE: 
                case REFRESH_PRESENT: {
                    refreshDone = true;
                    ASN1Sequence s = valueElement.decodeAsSequence();
                    block21: for (ASN1Element e : s.elements()) {
                        switch (e.getType()) {
                            case 4: {
                                cookie = ASN1OctetString.decodeAsOctetString(e);
                                continue block21;
                            }
                            case 1: {
                                refreshDone = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                                continue block21;
                            }
                            default: {
                                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SYNC_INFO_IR_VALUE_INVALID_SEQUENCE_TYPE.get(type.name(), StaticUtils.toHex(e.getType())));
                            }
                        }
                    }
                    break;
                }
                case SYNC_ID_SET: {
                    ASN1Sequence s = valueElement.decodeAsSequence();
                    block22: for (ASN1Element e : s.elements()) {
                        switch (e.getType()) {
                            case 4: {
                                cookie = ASN1OctetString.decodeAsOctetString(e);
                                continue block22;
                            }
                            case 1: {
                                refreshDeletes = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                                continue block22;
                            }
                            case 49: {
                                ASN1Set uuidSet = ASN1Set.decodeAsSet(e);
                                ASN1Element[] uuidElements = uuidSet.elements();
                                entryUUIDs = new ArrayList<UUID>(uuidElements.length);
                                for (ASN1Element uuidElement : uuidElements) {
                                    try {
                                        entryUUIDs.add(StaticUtils.decodeUUID(uuidElement.getValue()));
                                    }
                                    catch (ParseException pe) {
                                        Debug.debugException(pe);
                                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SYNC_INFO_IR_INVALID_UUID.get(type.name(), pe.getMessage()), pe);
                                    }
                                }
                                continue block22;
                            }
                            default: {
                                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SYNC_INFO_IR_VALUE_INVALID_SEQUENCE_TYPE.get(type.name(), StaticUtils.toHex(e.getType())));
                            }
                        }
                    }
                    if (entryUUIDs != null) break;
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SYNC_INFO_IR_NO_UUID_SET.get(type.name()));
                }
            }
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SYNC_INFO_IR_VALUE_DECODING_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
        }
        return new ContentSyncInfoIntermediateResponse(type, value, cookie, refreshDone, refreshDeletes, entryUUIDs, r.getControls());
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull ContentSyncInfoType type, @Nullable ASN1OctetString cookie, boolean refreshDone, @Nullable List<UUID> entryUUIDs, boolean refreshDeletes) {
        ASN1Element e;
        switch (type) {
            case NEW_COOKIE: {
                e = new ASN1OctetString(type.getType(), cookie.getValue());
                break;
            }
            case REFRESH_DELETE: 
            case REFRESH_PRESENT: {
                ArrayList<ASN1Element> l = new ArrayList<ASN1Element>(2);
                if (cookie != null) {
                    l.add(cookie);
                }
                if (!refreshDone) {
                    l.add(new ASN1Boolean(refreshDone));
                }
                e = new ASN1Sequence(type.getType(), l);
                break;
            }
            case SYNC_ID_SET: {
                ArrayList<ASN1Element> l = new ArrayList<ASN1Element>(3);
                if (cookie != null) {
                    l.add(cookie);
                }
                if (refreshDeletes) {
                    l.add(new ASN1Boolean(refreshDeletes));
                }
                ArrayList<ASN1OctetString> uuidElements = new ArrayList<ASN1OctetString>(entryUUIDs.size());
                for (UUID uuid : entryUUIDs) {
                    uuidElements.add(new ASN1OctetString(StaticUtils.encodeUUID(uuid)));
                }
                l.add(new ASN1Set(uuidElements));
                e = new ASN1Sequence(type.getType(), l);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected sync info type:  " + type.name()));
            }
        }
        return new ASN1OctetString(e.encode());
    }

    @NotNull
    public ContentSyncInfoType getType() {
        return this.type;
    }

    @Nullable
    public ASN1OctetString getCookie() {
        return this.cookie;
    }

    public boolean refreshDone() {
        return this.refreshDone;
    }

    @Nullable
    public List<UUID> getEntryUUIDs() {
        return this.entryUUIDs;
    }

    public boolean refreshDeletes() {
        return this.refreshDeletes;
    }

    @Override
    @NotNull
    public String getIntermediateResponseName() {
        return ControlMessages.INFO_INTERMEDIATE_RESPONSE_NAME_SYNC_INFO.get();
    }

    @Override
    @NotNull
    public String valueToString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("syncInfoType='");
        buffer.append(this.type.name());
        buffer.append('\'');
        if (this.cookie != null) {
            buffer.append(" cookie='");
            StaticUtils.toHex(this.cookie.getValue(), buffer);
            buffer.append('\'');
        }
        switch (this.type) {
            case REFRESH_DELETE: 
            case REFRESH_PRESENT: {
                buffer.append(" refreshDone='");
                buffer.append(this.refreshDone);
                buffer.append('\'');
                break;
            }
            case SYNC_ID_SET: {
                buffer.append(" entryUUIDs={");
                Iterator<UUID> iterator = this.entryUUIDs.iterator();
                while (iterator.hasNext()) {
                    buffer.append('\'');
                    buffer.append(iterator.next().toString());
                    buffer.append('\'');
                    if (!iterator.hasNext()) continue;
                    buffer.append(',');
                }
                buffer.append('}');
                break;
            }
        }
        return buffer.toString();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("ContentSyncInfoIntermediateResponse(");
        int messageID = this.getMessageID();
        if (messageID >= 0) {
            buffer.append("messageID=");
            buffer.append(messageID);
            buffer.append(", ");
        }
        buffer.append("type='");
        buffer.append(this.type.name());
        buffer.append('\'');
        if (this.cookie != null) {
            buffer.append(", cookie='");
            StaticUtils.toHex(this.cookie.getValue(), buffer);
            buffer.append("', ");
        }
        switch (this.type) {
            case NEW_COOKIE: {
                break;
            }
            case REFRESH_DELETE: 
            case REFRESH_PRESENT: {
                buffer.append(", refreshDone=");
                buffer.append(this.refreshDone);
                break;
            }
            case SYNC_ID_SET: {
                buffer.append(", entryUUIDs={");
                Iterator<UUID> iterator = this.entryUUIDs.iterator();
                while (iterator.hasNext()) {
                    buffer.append('\'');
                    buffer.append(iterator.next());
                    buffer.append('\'');
                    if (!iterator.hasNext()) continue;
                    buffer.append(',');
                }
                buffer.append("}, refreshDeletes=");
                buffer.append(this.refreshDeletes);
            }
        }
        buffer.append(')');
    }
}

