/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.loadbalancing.helper;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.loadbalancing.helper.OptionalLocalDcHelper;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.time.Clock;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class InferringLocalDcHelper
extends OptionalLocalDcHelper {
    public InferringLocalDcHelper(@NonNull InternalDriverContext context, @NonNull DriverExecutionProfile profile, @NonNull String logPrefix) {
        super(context, profile, logPrefix);
    }

    @Override
    @NonNull
    public Optional<String> discoverLocalDc(@NonNull Map<UUID, Node> nodes) {
        Optional<String> optionalLocalDc = super.discoverLocalDc(nodes);
        if (optionalLocalDc.isPresent()) {
            return optionalLocalDc;
        }
        HashSet<String> datacenters = new HashSet<String>();
        Set<DefaultNode> contactPoints = this.context.getMetadataManager().getContactPoints();
        for (Node node : contactPoints) {
            String datacenter = node.getDatacenter();
            if (datacenter == null) continue;
            datacenters.add(datacenter);
        }
        if (datacenters.size() == 1) {
            String localDc = (String)datacenters.iterator().next();
            Clock.LOG.info("[{}] Inferred local DC from contact points: {}", (Object)this.logPrefix, (Object)localDc);
            return Optional.of(localDc);
        }
        if (datacenters.isEmpty()) {
            throw new IllegalStateException("The local DC could not be inferred from contact points, please set it explicitly (see " + DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER.getPath() + " in the config, or set it programmatically with SessionBuilder.withLocalDatacenter)");
        }
        throw new IllegalStateException(String.format("No local DC was provided, but the contact points are from different DCs: %s; please set the local DC explicitly (see " + DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER.getPath() + " in the config, or set it programmatically with SessionBuilder.withLocalDatacenter)", this.formatNodesAndDcs(contactPoints)));
    }
}

