/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.protocol.thrift.async.handler;

import java.util.Objects;
import org.apache.iotdb.commons.client.async.AsyncPipeDataTransferServiceClient;
import org.apache.iotdb.db.pipe.sink.protocol.thrift.async.IoTDBDataRegionAsyncSink;
import org.apache.iotdb.db.pipe.sink.protocol.thrift.async.handler.PipeTransferTsFileHandler;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeTransferTrackableHandler
implements AsyncMethodCallback<TPipeTransferResp>,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTransferTsFileHandler.class);
    protected final IoTDBDataRegionAsyncSink connector;
    protected volatile AsyncPipeDataTransferServiceClient client;

    public PipeTransferTrackableHandler(IoTDBDataRegionAsyncSink connector) {
        this.connector = connector;
    }

    public void onComplete(TPipeTransferResp response) {
        if (this.connector.isClosed()) {
            this.clearEventsReferenceCount();
            this.connector.eliminateHandler(this, true);
            return;
        }
        if (this.onCompleteInternal(response)) {
            this.connector.eliminateHandler(this, false);
        }
    }

    public void onError(Exception exception) {
        if (this.connector.isClosed()) {
            this.clearEventsReferenceCount();
            this.connector.eliminateHandler(this, true);
            return;
        }
        this.onErrorInternal(exception);
        this.connector.eliminateHandler(this, false);
    }

    protected boolean tryTransfer(AsyncPipeDataTransferServiceClient client, TPipeTransferReq req) throws TException {
        if (Objects.isNull(this.client)) {
            this.client = client;
        }
        this.connector.trackHandler(this);
        if (this.connector.isClosed()) {
            this.clearEventsReferenceCount();
            this.connector.eliminateHandler(this, true);
            client.setShouldReturnSelf(true);
            try {
                client.returnSelf();
            }
            catch (IllegalStateException e) {
                LOGGER.info("Illegal state when return the client to object pool, maybe the pool is already cleared. Will ignore.");
            }
            this.client = null;
            return false;
        }
        this.doTransfer(client, req);
        return true;
    }

    protected abstract boolean onCompleteInternal(TPipeTransferResp var1);

    protected abstract void onErrorInternal(Exception var1);

    protected abstract void doTransfer(AsyncPipeDataTransferServiceClient var1, TPipeTransferReq var2) throws TException;

    public abstract void clearEventsReferenceCount();

    public void closeClient() {
        if (Objects.isNull(this.client)) {
            return;
        }
        try {
            this.client.close();
            this.client.invalidateAll();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to close or invalidate client when connector is closed. Client: {}, Exception: {}", new Object[]{this.client, e.getMessage(), e});
        }
    }

    @Override
    public void close() {
    }
}

