/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.pipe.payload;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PipeAlterEncodingCompressorPlan
extends ConfigPhysicalPlan {
    private ByteBuffer patternTreeBytes;
    private byte encoding;
    private byte compressor;
    private boolean mayAlterAudit;

    public PipeAlterEncodingCompressorPlan() {
        super(ConfigPhysicalPlanType.PipeAlterEncodingCompressor);
    }

    public PipeAlterEncodingCompressorPlan(@Nonnull ByteBuffer patternTreeBytes, byte encoding, byte compressor, boolean mayAlterAudit) {
        super(ConfigPhysicalPlanType.PipeAlterEncodingCompressor);
        this.patternTreeBytes = patternTreeBytes;
        this.encoding = encoding;
        this.compressor = compressor;
        this.mayAlterAudit = mayAlterAudit;
    }

    public void setPatternTreeBytes(ByteBuffer patternTreeBytes) {
        this.patternTreeBytes = patternTreeBytes;
    }

    public ByteBuffer getPatternTreeBytes() {
        this.patternTreeBytes.rewind();
        return this.patternTreeBytes;
    }

    public byte getEncoding() {
        return this.encoding;
    }

    public byte getCompressor() {
        return this.compressor;
    }

    public void setMayAlterAudit(boolean mayAlterAudit) {
        this.mayAlterAudit = mayAlterAudit;
    }

    public boolean isMayAlterAudit() {
        return this.mayAlterAudit;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ReadWriteIOUtils.write((ByteBuffer)this.patternTreeBytes, (OutputStream)stream);
        ReadWriteIOUtils.write((byte)this.encoding, (OutputStream)stream);
        ReadWriteIOUtils.write((byte)this.compressor, (OutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.patternTreeBytes = ByteBuffer.wrap(ReadWriteIOUtils.readBinary((ByteBuffer)buffer).getValues());
        this.encoding = ReadWriteIOUtils.readByte((ByteBuffer)buffer);
        this.compressor = ReadWriteIOUtils.readByte((ByteBuffer)buffer);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.patternTreeBytes, this.encoding, this.compressor);
    }

    public String toString() {
        return "PipeAlterEncodingCompressorPlan{patternTreeBytes=" + this.patternTreeBytes + ", encoding=" + this.encoding + ", compressor=" + this.compressor + '}';
    }
}

