/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.exception.IoTDBRuntimeException;
import org.apache.iotdb.commons.partition.ExecutorType;
import org.apache.iotdb.commons.partition.QueryExecutor;
import org.apache.iotdb.commons.partition.StorageExecutor;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.common.DataNodeEndPoints;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.plan.planner.IFragmentParallelPlaner;
import org.apache.iotdb.db.queryengine.plan.planner.exceptions.ReplicaSetUnreachableException;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.plan.planner.plan.PlanFragment;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.relational.planner.distribute.TableModelQueryFragmentPlanner;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFragmentParallelPlanner
implements IFragmentParallelPlaner {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableModelQueryFragmentPlanner.class);
    protected MPPQueryContext queryContext;

    protected AbstractFragmentParallelPlanner(MPPQueryContext queryContext) {
        this.queryContext = queryContext;
    }

    protected void selectExecutorAndHost(PlanFragment fragment, FragmentInstance fragmentInstance, Supplier<TRegionReplicaSet> replicaSetProvider, Function<TRegionReplicaSet, TRegionReplicaSet> validator, Map<TDataNodeLocation, List<FragmentInstance>> dataNodeFIMap) {
        TRegionReplicaSet regionReplicaSet = replicaSetProvider.get();
        if (regionReplicaSet != null && !CollectionUtils.isEmpty((Collection)regionReplicaSet.getDataNodeLocations()) && (regionReplicaSet = validator.apply(regionReplicaSet)).getDataNodeLocations().isEmpty()) {
            throw new ReplicaSetUnreachableException(replicaSetProvider.get());
        }
        if (regionReplicaSet == null || regionReplicaSet.getRegionId() == null) {
            TDataNodeLocation dataNodeLocation = fragment.getTargetLocation();
            if (dataNodeLocation != null) {
                fragmentInstance.setExecutorAndHost((ExecutorType)new QueryExecutor(dataNodeLocation));
            } else {
                fragmentInstance.setExecutorAndHost((ExecutorType)new QueryExecutor(DataNodeEndPoints.getLocalDataNodeLocation()));
            }
        } else {
            fragmentInstance.setExecutorAndHost((ExecutorType)new StorageExecutor(regionReplicaSet));
            fragmentInstance.setHostDataNode(this.selectTargetDataNode(regionReplicaSet));
        }
        dataNodeFIMap.compute(fragmentInstance.getHostDataNode(), (k, v) -> {
            if (v == null) {
                v = new ArrayList<FragmentInstance>();
            }
            v.add(fragmentInstance);
            return v;
        });
    }

    protected TDataNodeLocation selectTargetDataNode(TRegionReplicaSet regionReplicaSet) {
        if (regionReplicaSet == null || regionReplicaSet.getDataNodeLocations() == null || regionReplicaSet.getDataNodeLocations().isEmpty()) {
            throw new IllegalArgumentException(String.format("regionReplicaSet is invalid: %s", regionReplicaSet));
        }
        String readConsistencyLevel = IoTDBDescriptor.getInstance().getConfig().getReadConsistencyLevel();
        boolean selectRandomDataNode = "weak".equals(readConsistencyLevel);
        List<TDataNodeLocation> availableDataNodes = this.filterAvailableTDataNode(regionReplicaSet.getDataNodeLocations());
        if (availableDataNodes.isEmpty()) {
            String errorMsg = String.format("All replicas for region[%s] are not available in these DataNodes[%s]", regionReplicaSet.getRegionId(), regionReplicaSet.getDataNodeLocations());
            throw new IoTDBRuntimeException(errorMsg, TSStatusCode.NO_AVAILABLE_REPLICA.getStatusCode(), true);
        }
        if (regionReplicaSet.getDataNodeLocationsSize() != availableDataNodes.size()) {
            LOGGER.info("available replicas: {}", availableDataNodes);
        }
        int targetIndex = !selectRandomDataNode || this.queryContext.getSession() == null ? 0 : (int)(this.queryContext.getSession().getSessionId() % (long)availableDataNodes.size());
        return availableDataNodes.get(targetIndex);
    }

    protected FragmentInstance findDownStreamInstance(Map<PlanNodeId, Pair<PlanFragmentId, PlanNode>> planNodeMap, Map<PlanFragmentId, FragmentInstance> instanceMap, PlanNodeId exchangeNodeId) {
        return instanceMap.get(planNodeMap.get((Object)exchangeNodeId).left);
    }

    private List<TDataNodeLocation> filterAvailableTDataNode(List<TDataNodeLocation> originalDataNodeList) {
        LinkedList<TDataNodeLocation> result = new LinkedList<TDataNodeLocation>();
        for (TDataNodeLocation dataNodeLocation : originalDataNodeList) {
            if (!this.isAvailableDataNode(dataNodeLocation)) continue;
            result.add(dataNodeLocation);
        }
        return result;
    }

    private boolean isAvailableDataNode(TDataNodeLocation dataNodeLocation) {
        for (TEndPoint endPoint : this.queryContext.getEndPointBlackList()) {
            if (!endPoint.equals(dataNodeLocation.internalEndPoint)) continue;
            return false;
        }
        return true;
    }
}

