/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.thrift.handler;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Gauge;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class RPCServiceThriftHandlerMetrics
implements IMetricSet {
    private static final RPCServiceThriftHandlerMetrics INSTANCE = new RPCServiceThriftHandlerMetrics(new AtomicLong(0L));
    private AtomicLong thriftConnectionNumber;
    private Gauge unCompressionSizeTimer = DoNothingMetricManager.DO_NOTHING_GAUGE;
    private Gauge compressionSizeTimer = DoNothingMetricManager.DO_NOTHING_GAUGE;
    private Timer decodeLatencyTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer decompressLatencyTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Gauge memoryUsageGauge = DoNothingMetricManager.DO_NOTHING_GAUGE;

    public RPCServiceThriftHandlerMetrics(AtomicLong thriftConnectionNumber) {
        this.thriftConnectionNumber = thriftConnectionNumber;
    }

    public void recordUnCompressionSizeTimer(long size) {
        this.unCompressionSizeTimer.set(size);
    }

    public void recordCompressionSizeTimer(long size) {
        this.compressionSizeTimer.set(size);
    }

    public void recordDecodeLatencyTimer(long costTimeInNanos) {
        this.decodeLatencyTimer.updateNanos(costTimeInNanos);
    }

    public void recordDecompressLatencyTimer(long costTimeInNanos) {
        this.decompressLatencyTimer.updateNanos(costTimeInNanos);
    }

    public void recordMemoryUsage(long memoryUsage) {
        this.memoryUsageGauge.set(memoryUsage);
    }

    public void bindTo(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.THRIFT_CONNECTIONS.toString(), MetricLevel.CORE, (Object)this.thriftConnectionNumber, AtomicLong::get, new String[]{Tag.NAME.toString(), "ClientRPC"});
        this.unCompressionSizeTimer = metricService.getOrCreateGauge(Metric.THRIFT_RPC_UNCOMPRESS_SIZE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "unCompressionSize"});
        this.compressionSizeTimer = metricService.getOrCreateGauge(Metric.THRIFT_RPC_COMPRESS_SIZE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compressionSize"});
        this.decodeLatencyTimer = metricService.getOrCreateTimer(Metric.THRIFT_RPC_DECODE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "decodeLatency"});
        this.decompressLatencyTimer = metricService.getOrCreateTimer(Metric.THRIFT_RPC_UNCOMPRESS.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "decompressLatency"});
        this.memoryUsageGauge = metricService.getOrCreateGauge(Metric.THRIFT_RPC_MEMORY_USAGE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "memoryUsage"});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.THRIFT_CONNECTIONS.toString(), new String[]{Tag.NAME.toString(), "ClientRPC"});
        metricService.remove(MetricType.TIMER, Metric.THRIFT_RPC_UNCOMPRESS_SIZE.toString(), new String[]{Tag.NAME.toString(), "unCompressionSize"});
        metricService.remove(MetricType.TIMER, Metric.THRIFT_RPC_COMPRESS_SIZE.toString(), new String[]{Tag.NAME.toString(), "compressionSize"});
        metricService.remove(MetricType.TIMER, Metric.THRIFT_RPC_DECODE.toString(), new String[]{Tag.NAME.toString(), "decodeLatency"});
        metricService.remove(MetricType.TIMER, Metric.THRIFT_RPC_UNCOMPRESS.toString(), new String[]{Tag.NAME.toString(), "decompressLatency"});
        metricService.remove(MetricType.GAUGE, Metric.THRIFT_RPC_MEMORY_USAGE.toString(), new String[]{Tag.NAME.toString(), "memoryUsage"});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RPCServiceThriftHandlerMetrics that = (RPCServiceThriftHandlerMetrics)o;
        return Objects.equals(this.thriftConnectionNumber, that.thriftConnectionNumber);
    }

    public int hashCode() {
        return Objects.hash(this.thriftConnectionNumber);
    }

    public static RPCServiceThriftHandlerMetrics getInstance() {
        return INSTANCE;
    }
}

