/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class IoTDBResultMetadata
implements ResultSetMetaData {
    private List<String> columnInfoList;
    private List<String> columnTypeList;
    private boolean ignoreTimestamp;
    private List<String> sgColumns;
    private String operationType = "";
    private boolean nonAlign = false;
    private static final String INT64 = "INT64";
    private static final String BOOLEAN = "BOOLEAN";
    private static final String INT32 = "INT32";
    private static final String FLOAT = "FLOAT";
    private static final String DOUBLE = "DOUBLE";
    private static final String TEXT = "TEXT";
    private static final String STRING = "STRING";
    private static final String BLOB = "BLOB";
    private static final String DATE = "DATE";
    private static final String TIMESTAMP = "TIMESTAMP";

    public IoTDBResultMetadata(Boolean nonAlign, List<String> sgColumns, String operationType, List<String> columnInfoList, List<String> columnTypeList, boolean ignoreTimestamp) {
        this.sgColumns = sgColumns;
        this.operationType = operationType;
        this.columnInfoList = columnInfoList;
        this.columnTypeList = columnTypeList;
        this.ignoreTimestamp = ignoreTimestamp;
        this.nonAlign = nonAlign;
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        String systemSchmea = "_system_schmea";
        String system = "_system";
        String systemUser = "_system_user";
        String systemRole = "_system_role";
        String systemAuths = "_system_auths";
        String systemDatabase = "_system_database";
        String systemNull = "";
        String columnName = this.columnInfoList.get(column - 1);
        List<String> listColumns = this.columnInfoList;
        if (column < 1 || column > this.columnInfoList.size()) {
            throw new SQLException("Method not supported");
        }
        if ("SHOW".equals(this.operationType)) {
            if ("count".equals(listColumns.get(0))) {
                return systemDatabase;
            }
            if ("database".equals(listColumns.get(0)) && listColumns.size() > 1 && "ttl".equals(listColumns.get(1))) {
                return "";
            }
            if ("version".equals(listColumns.get(0).trim()) && listColumns.size() == 1) {
                return system;
            }
            if ("database".equals(listColumns.get(0)) || "devices".equals(listColumns.get(0)) || "child paths".equals(listColumns.get(0)) || "child nodes".equals(listColumns.get(0)) || "timeseries".equals(listColumns.get(0))) {
                return systemSchmea;
            }
        } else {
            if ("LIST_USER".equals(this.operationType)) {
                return systemUser;
            }
            if ("LIST_ROLE".equals(this.operationType)) {
                return systemRole;
            }
            if ("LIST_USER_PRIVILEGE".equals(this.operationType)) {
                return systemAuths;
            }
            if ("LIST_ROLE_PRIVILEGE".equals(this.operationType)) {
                return systemAuths;
            }
            if ("LIST_USER_ROLES".equals(this.operationType)) {
                return systemRole;
            }
            if ("LIST_ROLE_USERS".equals(this.operationType)) {
                return systemUser;
            }
            if ("QUERY".equals(this.operationType) ? "time".equalsIgnoreCase(columnName) && this.columnInfoList.size() != 2 || "timeseries".equalsIgnoreCase(columnName) || "device".equalsIgnoreCase(columnName) || this.columnInfoList.size() >= 2 && "time".equalsIgnoreCase(this.columnInfoList.get(0)) && "device".equalsIgnoreCase(this.columnInfoList.get(1)) : !"FILL".equals(this.operationType)) {
                return systemNull;
            }
        }
        if (this.nonAlign) {
            return this.sgColumns.get(column - 1);
        }
        return this.sgColumns.get(column - 2);
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        String columnTypeName;
        switch (columnTypeName = this.getColumnTypeName(column)) {
            case "TIMESTAMP": {
                return Timestamp.class.getName();
            }
            case "INT64": {
                return Long.class.getName();
            }
            case "BOOLEAN": {
                return Boolean.class.getName();
            }
            case "INT32": {
                return Integer.class.getName();
            }
            case "FLOAT": {
                return Float.class.getName();
            }
            case "DOUBLE": {
                return Double.class.getName();
            }
            case "TEXT": 
            case "STRING": {
                return String.class.getName();
            }
            case "DATE": {
                return Date.class.getName();
            }
            case "BLOB": {
                return "byte[]";
            }
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return this.columnInfoList == null ? 0 : this.columnInfoList.size();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.getPrecision(column);
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.columnInfoList.get(column - 1);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumnLabel(column);
    }

    private void checkColumnIndex(int column) throws SQLException {
        if (this.columnInfoList == null || this.columnInfoList.isEmpty()) {
            throw new SQLException("No column exists");
        }
        if (column > this.columnInfoList.size()) {
            throw new SQLException(String.format("column %d does not exist", column));
        }
        if (column <= 0) {
            throw new SQLException("column index should start from 1");
        }
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        this.checkColumnIndex(column);
        if (column == 1 && !this.ignoreTimestamp) {
            return 93;
        }
        String columnType = this.columnTypeList.get(column - 1);
        switch (columnType.toUpperCase()) {
            case "BOOLEAN": {
                return 16;
            }
            case "INT32": {
                return 4;
            }
            case "INT64": {
                return -5;
            }
            case "FLOAT": {
                return 6;
            }
            case "DOUBLE": {
                return 8;
            }
            case "TEXT": 
            case "STRING": {
                return 12;
            }
            case "DATE": {
                return 91;
            }
            case "TIMESTAMP": {
                return 93;
            }
            case "BLOB": {
                return 2004;
            }
        }
        return 0;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        this.checkColumnIndex(column);
        if (column == 1 && !this.ignoreTimestamp) {
            return TIMESTAMP;
        }
        String columnType = this.columnTypeList.get(column - 1);
        String typeString = columnType.toUpperCase();
        if (BOOLEAN.equals(typeString) || INT32.equals(typeString) || INT64.equals(typeString) || FLOAT.equals(typeString) || DOUBLE.equals(typeString) || TEXT.equals(typeString) || STRING.equals(typeString) || BLOB.equals(typeString) || DATE.equals(typeString) || TIMESTAMP.equals(typeString)) {
            return typeString;
        }
        return null;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        this.checkColumnIndex(column);
        if (column == 1 && !this.ignoreTimestamp) {
            return 3;
        }
        String columnType = this.columnTypeList.get(column - 1);
        switch (columnType.toUpperCase()) {
            case "BOOLEAN": {
                return 1;
            }
            case "INT32": {
                return 10;
            }
            case "INT64": {
                return 19;
            }
            case "FLOAT": {
                return 38;
            }
            case "DOUBLE": {
                return 308;
            }
            case "TEXT": 
            case "BLOB": 
            case "STRING": {
                return Integer.MAX_VALUE;
            }
            case "TIMESTAMP": {
                return 3;
            }
            case "DATE": {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        this.checkColumnIndex(column);
        if (column == 1 && !this.ignoreTimestamp) {
            return 0;
        }
        String columnType = this.columnTypeList.get(column - 1);
        switch (columnType.toUpperCase()) {
            case "BOOLEAN": 
            case "INT32": 
            case "INT64": 
            case "TEXT": 
            case "BLOB": 
            case "STRING": 
            case "TIMESTAMP": 
            case "DATE": {
                return 0;
            }
            case "FLOAT": {
                return 6;
            }
            case "DOUBLE": {
                return 15;
            }
        }
        return 0;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.getCatalogName(column);
    }

    @Override
    public String getTableName(int column) throws SQLException {
        this.checkColumnIndex(column);
        if (column == 1 && !this.ignoreTimestamp) {
            return "TIME";
        }
        return this.columnInfoList.get(column - 1);
    }

    @Override
    public boolean isAutoIncrement(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int arg0) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int arg0) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int arg0) throws SQLException {
        return 1;
    }

    @Override
    public boolean isReadOnly(int arg0) throws SQLException {
        return true;
    }

    @Override
    public boolean isSearchable(int arg0) throws SQLException {
        return true;
    }

    @Override
    public boolean isSigned(int arg0) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int arg0) throws SQLException {
        return false;
    }
}

