/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.UserIdentityToken;

public class AnonymousIdentityToken
extends UserIdentityToken
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=319");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=320");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=321");

    public AnonymousIdentityToken(String policyId) {
        super(policyId);
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    protected AnonymousIdentityToken(AnonymousIdentityTokenBuilder<?, ?> b) {
        super((UserIdentityToken.UserIdentityTokenBuilder<?, ?>)b);
    }

    public static AnonymousIdentityTokenBuilder<?, ?> builder() {
        return new AnonymousIdentityTokenBuilderImpl();
    }

    public AnonymousIdentityTokenBuilder<?, ?> toBuilder() {
        return new AnonymousIdentityTokenBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnonymousIdentityToken)) {
            return false;
        }
        AnonymousIdentityToken other = (AnonymousIdentityToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AnonymousIdentityToken;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "AnonymousIdentityToken()";
    }

    private static final class AnonymousIdentityTokenBuilderImpl
    extends AnonymousIdentityTokenBuilder<AnonymousIdentityToken, AnonymousIdentityTokenBuilderImpl> {
        private AnonymousIdentityTokenBuilderImpl() {
        }

        @Override
        protected AnonymousIdentityTokenBuilderImpl self() {
            return this;
        }

        @Override
        public AnonymousIdentityToken build() {
            return new AnonymousIdentityToken(this);
        }
    }

    public static abstract class AnonymousIdentityTokenBuilder<C extends AnonymousIdentityToken, B extends AnonymousIdentityTokenBuilder<C, B>>
    extends UserIdentityToken.UserIdentityTokenBuilder<C, B> {
        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AnonymousIdentityTokenBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(AnonymousIdentityToken instance, AnonymousIdentityTokenBuilder<?, ?> b) {
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "AnonymousIdentityToken.AnonymousIdentityTokenBuilder(super=" + super.toString() + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<AnonymousIdentityToken> {
        @Override
        public Class<AnonymousIdentityToken> getType() {
            return AnonymousIdentityToken.class;
        }

        @Override
        public AnonymousIdentityToken decode(SerializationContext context, UaDecoder decoder) {
            String policyId = decoder.readString("PolicyId");
            return new AnonymousIdentityToken(policyId);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, AnonymousIdentityToken value) {
            encoder.writeString("PolicyId", value.getPolicyId());
        }
    }
}

