/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.message;

import java.util.List;
import java.util.UUID;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite3.internal.tx.message.CleanupReplicatedInfoMessage;
import org.apache.ignite3.internal.tx.message.CleanupReplicatedInfoMessageBuilder;
import org.apache.ignite3.internal.tx.message.TxMessagesFactory;

class CleanupReplicatedInfoMessageDeserializer
implements MessageDeserializer<CleanupReplicatedInfoMessage> {
    private final CleanupReplicatedInfoMessageBuilder msg;

    CleanupReplicatedInfoMessageDeserializer(TxMessagesFactory messageFactory) {
        this.msg = messageFactory.cleanupReplicatedInfoMessage();
    }

    @Override
    public Class<CleanupReplicatedInfoMessage> klass() {
        return CleanupReplicatedInfoMessage.class;
    }

    @Override
    public CleanupReplicatedInfoMessage getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                UUID tmp = reader.readList("partitions", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.partitions((List<ReplicationGroupIdMessage>)((Object)tmp));
                reader.incrementState();
            }
            case 1: {
                UUID tmp = reader.readUuid("txId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.txId(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(CleanupReplicatedInfoMessage.class);
    }
}

