/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.hint;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.ignite3.internal.sql.engine.hint.Hint;
import org.apache.ignite3.internal.sql.engine.hint.IgniteHint;

public class Hints {
    private final EnumMap<IgniteHint, Hint> hints;

    private Hints(EnumMap<IgniteHint, Hint> hints) {
        this.hints = hints;
    }

    public List<String> params(IgniteHint igniteHint) {
        Hint hint = this.hints.get((Object)igniteHint);
        if (hint == null) {
            return Collections.emptyList();
        }
        return hint.getOptions();
    }

    public boolean present(IgniteHint igniteHint) {
        return this.hints.containsKey((Object)igniteHint);
    }

    public static Hints parse(List<RelHint> relHints) {
        EnumMap<IgniteHint, Hint> supportedHints = new EnumMap<IgniteHint, Hint>(IgniteHint.class);
        for (RelHint h : relHints) {
            IgniteHint hints = IgniteHint.get(h.hintName);
            if (hints == null) continue;
            Hint hint = hints.paramSupport() ? new Hint(hints, h.listOptions) : new Hint(hints);
            supportedHints.put(hints, hint);
        }
        return new Hints(supportedHints);
    }
}

