/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import javax.cache.expiry.ExpiryPolicy;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.platform.cache.expiry.PlatformExpiryPolicy;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientRequest;
import org.apache.ignite.internal.processors.platform.client.IgniteClientException;

public abstract class ClientCacheRequest
extends ClientRequest {
    private static final byte KEEP_BINARY_FLAG_MASK = 1;
    private static final byte TRANSACTIONAL_FLAG_MASK = 2;
    private static final byte FLAG_WITH_EXPIRY_POLICY = 4;
    private final int cacheId;
    private final byte flags;
    private final ExpiryPolicy expiryPolicy;

    ClientCacheRequest(BinaryRawReader reader) {
        super(reader);
        this.cacheId = reader.readInt();
        this.flags = reader.readByte();
        this.expiryPolicy = this.withExpiryPolicy() ? new PlatformExpiryPolicy(reader.readLong(), reader.readLong(), reader.readLong()) : null;
    }

    protected IgniteCache<Object, Object> cache(ClientConnectionContext ctx) {
        return this.rawCache(ctx).withKeepBinary();
    }

    protected IgniteInternalCache<Object, Object> cachex(ClientConnectionContext ctx) {
        String cacheName = this.cacheDescriptor(ctx).cacheName();
        return ctx.kernalContext().grid().cachex(cacheName).keepBinary();
    }

    protected boolean isKeepBinary() {
        return (this.flags & 1) != 0;
    }

    protected boolean isTransactional() {
        return (this.flags & 2) != 0;
    }

    private boolean withExpiryPolicy() {
        return (this.flags & 4) == 4;
    }

    protected IgniteCache<Object, Object> rawCache(ClientConnectionContext ctx) {
        DynamicCacheDescriptor cacheDesc = this.cacheDescriptor(ctx);
        String cacheName = cacheDesc.cacheName();
        IgniteCache<Object, Object> cache = ctx.kernalContext().grid().cache(cacheName);
        if (this.withExpiryPolicy()) {
            cache = cache.withExpiryPolicy(this.expiryPolicy);
        }
        return cache;
    }

    protected DynamicCacheDescriptor cacheDescriptor(ClientConnectionContext ctx) {
        return ClientCacheRequest.cacheDescriptor(ctx, this.cacheId);
    }

    public static DynamicCacheDescriptor cacheDescriptor(ClientConnectionContext ctx, int cacheId) {
        DynamicCacheDescriptor desc = ctx.kernalContext().cache().cacheDescriptor(cacheId);
        if (desc == null) {
            throw new IgniteClientException(1000, "Cache does not exist [cacheId= " + cacheId + "]", null);
        }
        return desc;
    }

    protected int cacheId() {
        return this.cacheId;
    }
}

