/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.table.criteria;

public class CriteriaQueryOptions {
    public static final CriteriaQueryOptions DEFAULT = CriteriaQueryOptions.builder().build();
    private final int pageSize;

    private CriteriaQueryOptions(int pageSize) {
        this.pageSize = pageSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int pageSize() {
        return this.pageSize;
    }

    public static class Builder {
        private int pageSize = 1000;

        public Builder pageSize(int pageSize) {
            if (pageSize <= 0) {
                throw new IllegalArgumentException("Page size must be positive: " + pageSize);
            }
            this.pageSize = pageSize;
            return this;
        }

        public CriteriaQueryOptions build() {
            return new CriteriaQueryOptions(this.pageSize);
        }
    }
}

