/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.tx.TxState;

public class TxMeta
implements Serializable {
    private static final long serialVersionUID = -172513482743911860L;
    private final TxState txState;
    private final List<ReplicationGroupId> enlistedPartitions;
    private final HybridTimestamp commitTimestamp;

    public TxMeta(TxState txState, List<ReplicationGroupId> enlistedPartitions, HybridTimestamp commitTimestamp) {
        this.txState = txState;
        this.enlistedPartitions = enlistedPartitions;
        this.commitTimestamp = commitTimestamp;
    }

    public TxState txState() {
        return this.txState;
    }

    public List<ReplicationGroupId> enlistedPartitions() {
        return Collections.unmodifiableList(this.enlistedPartitions);
    }

    public HybridTimestamp commitTimestamp() {
        return this.commitTimestamp;
    }

    public String toString() {
        return S.toString(TxMeta.class, (Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TxMeta txMeta = (TxMeta)o;
        if (this.txState != txMeta.txState) {
            return false;
        }
        if (this.enlistedPartitions != null ? !this.enlistedPartitions.equals(txMeta.enlistedPartitions) : txMeta.enlistedPartitions != null) {
            return false;
        }
        return this.commitTimestamp != null ? this.commitTimestamp.equals((Object)txMeta.commitTimestamp) : txMeta.commitTimestamp == null;
    }

    public int hashCode() {
        int result = this.txState != null ? this.txState.hashCode() : 0;
        result = 31 * result + (this.enlistedPartitions != null ? this.enlistedPartitions.hashCode() : 0);
        result = 31 * result + (this.commitTimestamp != null ? this.commitTimestamp.hashCode() : 0);
        return result;
    }
}

