/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.configuration;

import java.util.Objects;
import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.schema.configuration.ColumnTypeValidator;
import org.apache.ignite.internal.schema.configuration.ColumnTypeView;
import org.apache.ignite.internal.schema.configuration.ColumnView;

public class ColumnTypeValidatorImpl
implements Validator<ColumnTypeValidator, ColumnTypeView> {
    public static final ColumnTypeValidatorImpl INSTANCE = new ColumnTypeValidatorImpl();

    public void validate(ColumnTypeValidator annotation, ValidationContext<ColumnTypeView> ctx) {
        ColumnTypeView newType = (ColumnTypeView)ctx.getNewValue();
        ColumnTypeView oldType = (ColumnTypeView)ctx.getOldValue();
        this.validateLength(ctx, newType);
        this.validatePrecision(ctx, newType);
        this.validateScale(ctx, newType);
        if (oldType == null) {
            return;
        }
        if (!Objects.deepEquals(newType.type(), oldType.type()) || newType.precision() != oldType.precision() || newType.scale() != oldType.scale() || newType.length() != oldType.length()) {
            ColumnView columnView = (ColumnView)ctx.getNewOwner();
            assert (columnView != null);
            ctx.addIssue(new ValidationIssue(columnView.name(), "Column type can't be changed"));
        }
    }

    private void validateLength(ValidationContext<ColumnTypeView> ctx, ColumnTypeView typeView) {
        switch (typeView.type()) {
            case "STRING": 
            case "BYTES": 
            case "BITMASK": {
                if (typeView.length() > 0) break;
                ColumnView columnView = (ColumnView)ctx.getNewOwner();
                assert (columnView != null);
                ctx.addIssue(new ValidationIssue(columnView.name(), "Length must be positive"));
                break;
            }
        }
    }

    private void validatePrecision(ValidationContext<ColumnTypeView> ctx, ColumnTypeView typeView) {
        switch (typeView.type()) {
            case "NUMBER": 
            case "DECIMAL": {
                if (typeView.precision() > 0) break;
                ColumnView columnView = (ColumnView)ctx.getNewOwner();
                assert (columnView != null);
                ctx.addIssue(new ValidationIssue(columnView.name(), "Precision must be positive"));
                break;
            }
            case "TIME": 
            case "DATETIME": 
            case "TIMESTAMP": {
                if (typeView.precision() >= 0 && typeView.precision() <= 9) break;
                ColumnView columnView = (ColumnView)ctx.getNewOwner();
                assert (columnView != null);
                ctx.addIssue(new ValidationIssue(columnView.name(), "Precision must be in range [0-9]"));
                break;
            }
        }
    }

    private void validateScale(ValidationContext<ColumnTypeView> ctx, ColumnTypeView typeView) {
        if (!"DECIMAL".equals(typeView.type())) {
            return;
        }
        if (typeView.precision() < typeView.scale()) {
            ColumnView columnView = (ColumnView)ctx.getNewOwner();
            assert (columnView != null);
            ctx.addIssue(new ValidationIssue(columnView.name(), "Scale must be lower or equal to precision"));
        }
    }

    private ColumnTypeValidatorImpl() {
    }
}

