/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.BitSet;
import org.apache.ignite.internal.schema.BitmaskNativeType;
import org.apache.ignite.internal.schema.DecimalNativeType;
import org.apache.ignite.internal.schema.NativeType;
import org.apache.ignite.internal.schema.NativeTypeSpec;
import org.apache.ignite.internal.schema.NumberNativeType;
import org.apache.ignite.internal.schema.TemporalNativeType;
import org.apache.ignite.internal.schema.VarlenNativeType;
import org.jetbrains.annotations.Contract;

public class NativeTypes {
    public static final NativeType INT8 = new NativeType(NativeTypeSpec.INT8, 1);
    public static final NativeType INT16 = new NativeType(NativeTypeSpec.INT16, 2);
    public static final NativeType INT32 = new NativeType(NativeTypeSpec.INT32, 4);
    public static final NativeType INT64 = new NativeType(NativeTypeSpec.INT64, 8);
    public static final NativeType FLOAT = new NativeType(NativeTypeSpec.FLOAT, 4);
    public static final NativeType DOUBLE = new NativeType(NativeTypeSpec.DOUBLE, 8);
    public static final NativeType UUID = new NativeType(NativeTypeSpec.UUID, 16);
    public static final NativeType STRING = new VarlenNativeType(NativeTypeSpec.STRING, Integer.MAX_VALUE);
    public static final NativeType BYTES = new VarlenNativeType(NativeTypeSpec.BYTES, Integer.MAX_VALUE);
    public static final NativeType DATE = new NativeType(NativeTypeSpec.DATE, 3);

    private NativeTypes() {
    }

    public static NativeType bitmaskOf(int bits) {
        return new BitmaskNativeType(bits);
    }

    public static NativeType numberOf(int precision) {
        return new NumberNativeType(precision);
    }

    public static NativeType stringOf(int len) {
        return new VarlenNativeType(NativeTypeSpec.STRING, len);
    }

    public static NativeType blobOf(int len) {
        return new VarlenNativeType(NativeTypeSpec.BYTES, len);
    }

    public static NativeType decimalOf(int precision, int scale) {
        return new DecimalNativeType(precision, scale);
    }

    public static NativeType time(int precision) {
        return TemporalNativeType.time(precision);
    }

    public static NativeType time() {
        return TemporalNativeType.time(0);
    }

    public static NativeType datetime(int precision) {
        return TemporalNativeType.datetime(precision);
    }

    public static NativeType datetime() {
        return TemporalNativeType.datetime(6);
    }

    public static NativeType timestamp(int precision) {
        return TemporalNativeType.timestamp(precision);
    }

    public static NativeType timestamp() {
        return TemporalNativeType.timestamp(6);
    }

    @Contract(value="null -> null")
    public static NativeType fromObject(Object val) {
        NativeTypeSpec spec = NativeTypeSpec.fromObject(val);
        if (spec == null) {
            return null;
        }
        switch (spec) {
            case INT8: {
                return INT8;
            }
            case INT16: {
                return INT16;
            }
            case INT32: {
                return INT32;
            }
            case INT64: {
                return INT64;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case UUID: {
                return UUID;
            }
            case DATE: {
                return DATE;
            }
            case TIME: {
                return NativeTypes.time();
            }
            case DATETIME: {
                return NativeTypes.datetime();
            }
            case TIMESTAMP: {
                return NativeTypes.timestamp();
            }
            case STRING: {
                return NativeTypes.stringOf(((CharSequence)val).length());
            }
            case BYTES: {
                return NativeTypes.blobOf(((byte[])val).length);
            }
            case BITMASK: {
                return NativeTypes.bitmaskOf(((BitSet)val).length());
            }
            case NUMBER: {
                return NativeTypes.numberOf(new BigDecimal((BigInteger)val).precision());
            }
            case DECIMAL: {
                return NativeTypes.decimalOf(((BigDecimal)val).precision(), ((BigDecimal)val).scale());
            }
        }
        assert (false) : "Unexpected type: " + spec;
        return null;
    }
}

