/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rule;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.PhysicalNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.Util;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.rel.set.IgniteMapMinus;
import org.apache.ignite.internal.sql.engine.rel.set.IgniteReduceMinus;
import org.apache.ignite.internal.sql.engine.rel.set.IgniteSingleMinus;
import org.apache.ignite.internal.sql.engine.rule.AbstractIgniteConverterRule;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistributions;

public class MinusConverterRule {
    public static final RelOptRule SINGLE = new SingleMinusConverterRule();
    public static final RelOptRule MAP_REDUCE = new MapReduceMinusConverterRule();

    private MinusConverterRule() {
    }

    private static class MapReduceMinusConverterRule
    extends AbstractIgniteConverterRule<LogicalMinus> {
        MapReduceMinusConverterRule() {
            super(LogicalMinus.class, "MapReduceMinusConverterRule");
        }

        @Override
        protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, LogicalMinus setOp) {
            RelOptCluster cluster = setOp.getCluster();
            RelTraitSet inTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE);
            RelTraitSet outTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE);
            List inputs = Util.transform((List)setOp.getInputs(), rel -> MapReduceMinusConverterRule.convert((RelNode)rel, (RelTraitSet)inTrait));
            IgniteMapMinus map = new IgniteMapMinus(cluster, outTrait, inputs, setOp.all);
            return new IgniteReduceMinus(cluster, outTrait.replace((RelTrait)IgniteDistributions.single()), MapReduceMinusConverterRule.convert((RelNode)map, (RelTraitSet)inTrait.replace((RelTrait)IgniteDistributions.single())), setOp.all, cluster.getTypeFactory().leastRestrictive(Util.transform((List)inputs, RelNode::getRowType)));
        }
    }

    private static class SingleMinusConverterRule
    extends AbstractIgniteConverterRule<LogicalMinus> {
        SingleMinusConverterRule() {
            super(LogicalMinus.class, "SingleMinusConverterRule");
        }

        @Override
        protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, LogicalMinus setOp) {
            RelOptCluster cluster = setOp.getCluster();
            RelTraitSet inTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)IgniteDistributions.single());
            RelTraitSet outTrait = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)IgniteDistributions.single());
            List inputs = Util.transform((List)setOp.getInputs(), rel -> SingleMinusConverterRule.convert((RelNode)rel, (RelTraitSet)inTrait));
            return new IgniteSingleMinus(cluster, outTrait, inputs, setOp.all);
        }
    }
}

