/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare.ddl;

import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class DefaultValueDefinition {
    protected final Type type;

    public static DefaultValueDefinition functionCall(String name) {
        return new FunctionCall(Objects.requireNonNull(name, "name"));
    }

    public static DefaultValueDefinition constant(@Nullable Object value) {
        return new ConstantValue(value);
    }

    private DefaultValueDefinition(Type type) {
        this.type = type;
    }

    public Type type() {
        return this.type;
    }

    public static class ConstantValue
    extends DefaultValueDefinition {
        private final Object value;

        private ConstantValue(Object value) {
            super(Type.CONSTANT);
            this.value = value;
        }

        public Object value() {
            return this.value;
        }
    }

    public static class FunctionCall
    extends DefaultValueDefinition {
        private final String functionName;

        private FunctionCall(String functionName) {
            super(Type.FUNCTION_CALL);
            this.functionName = functionName;
        }

        public String functionName() {
            return this.functionName;
        }
    }

    public static enum Type {
        CONSTANT,
        FUNCTION_CALL;

    }
}

