/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.decorators;

import java.util.stream.Collectors;
import org.apache.ignite.internal.cli.call.cliconfig.profile.ProfileList;
import org.apache.ignite.internal.cli.core.decorator.Decorator;
import org.apache.ignite.internal.cli.core.decorator.TerminalOutput;
import org.apache.ignite.internal.cli.core.style.AnsiStringSupport;

public class ProfileListDecorator
implements Decorator<ProfileList, TerminalOutput> {
    @Override
    public TerminalOutput decorate(ProfileList data) {
        if (ProfileListDecorator.isatty()) {
            return this.decorateCurrentProfileName(data);
        }
        return () -> data.getProfileNames().stream().collect(Collectors.joining(System.lineSeparator()));
    }

    private TerminalOutput decorateCurrentProfileName(ProfileList data) {
        String currentProfileName = data.getCurrentProfileName();
        return () -> data.getProfileNames().stream().map(p -> {
            if (p.equals(currentProfileName)) {
                return AnsiStringSupport.ansi(AnsiStringSupport.Style.BOLD.mark("* " + p), new Object[0]);
            }
            return "  " + p;
        }).collect(Collectors.joining(System.lineSeparator()));
    }

    private static boolean isatty() {
        return System.console() != null;
    }
}

