/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.message.BufferedHeader;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestBufferedHeader {
    TestBufferedHeader() {
    }

    @Test
    void testBasicConstructor() throws Exception {
        CharArrayBuffer buf = new CharArrayBuffer(32);
        buf.append("name: value");
        BufferedHeader header = new BufferedHeader(buf, false);
        Assertions.assertEquals((Object)"name", (Object)header.getName());
        Assertions.assertEquals((Object)"value", (Object)header.getValue());
        Assertions.assertSame((Object)buf, (Object)header.getBuffer());
        Assertions.assertEquals((int)5, (int)header.getValuePos());
    }

    @Test
    void testSerialization() throws Exception {
        CharArrayBuffer buf = new CharArrayBuffer(32);
        buf.append("name: value");
        BufferedHeader orig = new BufferedHeader(buf, false);
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        try (ObjectOutputStream outStream = new ObjectOutputStream(outbuffer);){
            outStream.writeObject(orig);
        }
        byte[] raw = outbuffer.toByteArray();
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(raw);
        ObjectInputStream inStream = new ObjectInputStream(inBuffer);
        BufferedHeader clone = (BufferedHeader)inStream.readObject();
        Assertions.assertEquals((Object)orig.getName(), (Object)clone.getName());
        Assertions.assertEquals((Object)orig.getValue(), (Object)clone.getValue());
    }

    @Test
    void testInvalidHeaderParsing() {
        CharArrayBuffer buf = new CharArrayBuffer(16);
        buf.clear();
        buf.append("");
        Assertions.assertThrows(ParseException.class, () -> new BufferedHeader(buf, false));
        buf.clear();
        buf.append("blah");
        Assertions.assertThrows(ParseException.class, () -> new BufferedHeader(buf, false));
        buf.clear();
        buf.append(":");
        Assertions.assertThrows(ParseException.class, () -> new BufferedHeader(buf, false));
        buf.clear();
        buf.append("   :");
        Assertions.assertThrows(ParseException.class, () -> new BufferedHeader(buf, false));
        buf.clear();
        buf.append(": blah");
        Assertions.assertThrows(ParseException.class, () -> new BufferedHeader(buf, false));
        buf.clear();
        buf.append(" : blah");
        Assertions.assertThrows(ParseException.class, () -> new BufferedHeader(buf, false));
        buf.clear();
        buf.append("header : blah");
        Assertions.assertThrows(ParseException.class, () -> new BufferedHeader(buf, true));
    }

    @Test
    void testCRLFNullInHeaderValue() throws Exception {
        CharArrayBuffer buf = new CharArrayBuffer(16);
        buf.clear();
        buf.append("name:  blah\u0000blah  ");
        BufferedHeader header1 = new BufferedHeader(buf, false);
        Assertions.assertEquals((Object)"name", (Object)header1.getName());
        Assertions.assertEquals((Object)"blah blah", (Object)header1.getValue());
        buf.clear();
        buf.append("name:  blah\rblah  ");
        BufferedHeader header2 = new BufferedHeader(buf, false);
        Assertions.assertEquals((Object)"name", (Object)header2.getName());
        Assertions.assertEquals((Object)"blah blah", (Object)header2.getValue());
        buf.clear();
        buf.append("name:  blah\nblah  ");
        BufferedHeader header3 = new BufferedHeader(buf, false);
        Assertions.assertEquals((Object)"name", (Object)header3.getName());
        Assertions.assertEquals((Object)"blah blah", (Object)header3.getValue());
    }
}

