/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift;

import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftState;
import java.sql.DriverPropertyInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public enum RedshiftProperty {
    ALLOW_ENCODING_CHANGES("allowencodingchanges", "true", "Allow for changes in client_encoding"),
    APPLICATION_NAME("applicationname", null, "Name of the Application"),
    ASSUME_MIN_SERVER_VERSION("assumeminserverversion", null, "Assume the server is at least that version"),
    AUTH_PROFILE("authprofile", null, "Authentication profile having connection props as JSON"),
    AUTOSAVE("autosave", "never", "Specifies what the driver should do if a query fails. In autosave=always mode, JDBC driver sets a savepoint before each query, and rolls back to that savepoint in case of failure. In autosave=never mode (default), no savepoint dance is made ever. In autosave=conservative mode, safepoint is set for each query, however the rollback is done only for rare cases like 'cached statement cannot change return type' or 'statement XXX is not valid' so JDBC driver rollsback and retries", false, new String[]{"always", "never", "conservative"}),
    BINARY_TRANSFER("binarytransfer", "true", "Use binary format for sending and receiving data if possible"),
    BINARY_TRANSFER_DISABLE("binarytransferdisable", "", "Comma separated list of types to disable binary transfer. Either OID numbers or names. Overrides values in the driver default set and values set with binaryTransferEnable."),
    BINARY_TRANSFER_ENABLE("binarytransferenable", "", "Comma separated list of types to enable binary transfer. Either OID numbers or names"),
    CANCEL_SIGNAL_TIMEOUT("cancelsignaltimeout", "10", "The timeout that is used for sending cancel command."),
    CLEANUP_SAVEPOINTS("cleanupsavepoints", "false", "Determine whether SAVEPOINTS used in AUTOSAVE will be released per query or not", false, new String[]{"true", "false"}),
    CONNECT_TIMEOUT("connecttimeout", "10", "The timeout value used for socket connect operations."),
    CURRENT_SCHEMA("currentschema", null, "Specify the schema (or several schema separated by commas) to be set in the search-path"),
    DATABASE_METADATA_CACHE_FIELDS("databasemetadatacachefields", "65536", "Specifies the maximum number of fields to be cached per connection. A value of {@code 0} disables the cache."),
    DATABASE_METADATA_CACHE_FIELDS_MIB("databasemetadatacachefieldsmib", "5", "Specifies the maximum size (in megabytes) of fields to be cached per connection. A value of {@code 0} disables the cache."),
    DATABASE_METADATA_CURRENT_DB_ONLY("databasemetadatacurrentdbonly", "true", "Control the behavior of metadata API to return data from all accessible databases or only from connected database"),
    DEFAULT_ROW_FETCH_SIZE("defaultrowfetchsize", "0", "Positive number of rows that should be fetched from the database when more rows are needed for ResultSet by each fetch iteration"),
    BLOCKING_ROWS_MODE("blockingrowsmode", "0", "Positive number of rows that should be fetched from the database when more rows are needed for ResultSet by each fetch iteration"),
    DISABLE_COLUMN_SANITISER("disablecolumnsanitiser", "false", "Enable optimization that disables column name sanitiser"),
    DISABLE_ISVALID_QUERY("disableisvalidquery", "false", "Disable isValid query"),
    ENABLE_FETCH_RING_BUFFER("enablefetchringbuffer", "true", "The Redshift fetch rows using a ring buffer on a separate thread"),
    ENABLE_GENERATED_NAME_FOR_PREPARED_STATEMENT("enablegeneratedname", "true", "The Redshift uses generated statement name and portal name"),
    ENABLE_MULTI_SQL_SUPPORT("enablemultisqlsupport", "true", "Control the behavior of semicolon separated SQL commands in a Statement"),
    ENABLE_STATEMENT_CACHE("enablestatementcache", "false", "The Redshift statement cache using SQL as key"),
    ESCAPE_SYNTAX_CALL_MODE("escapesyntaxcallmode", "call", "Specifies how the driver transforms JDBC escape call syntax into underlying SQL, for invoking procedures or functions. (backend >= 11)In escapeSyntaxCallMode=select mode (the default), the driver always uses a SELECT statement (allowing function invocation only).In escapeSyntaxCallMode=callIfNoReturn mode, the driver uses a CALL statement (allowing procedure invocation) if there is no return parameter specified, otherwise the driver uses a SELECT statement.In escapeSyntaxCallMode=call mode, the driver always uses a CALL statement (allowing procedure invocation only).", false, new String[]{"select", "callIfNoReturn", "call"}),
    FETCH_RING_BUFFER_SIZE("fetchringbuffersize", "1G", "Specifies size of ring buffer during fetching result set. Can be specified as specified size or percent of heap memory."),
    GSS_LIB("gsslib", "auto", "Force SSSPI or GSSAPI", false, new String[]{"auto", "sspi", "gssapi"}),
    HIDE_UNPRIVILEGED_OBJECTS("hideunprivilegedobjects", "false", "Enable hiding of database objects for which the current user has no privileges granted from the DatabaseMetaData"),
    HOST_RECHECK_SECONDS("hostrecheckseconds", "10", "Specifies period (seconds) after which the host status is checked again in case it has changed"),
    INI_FILE("inifile", null, "The JDBC INI file. Easy to configure connection properties."),
    INI_SECTION("inisection", null, "The JDBC INI file section name."),
    JAAS_APPLICATION_NAME("jaasapplicationname", null, "Specifies the name of the JAAS system or application login configuration."),
    JAAS_LOGIN("jaaslogin", "true", "Login with JAAS before doing GSSAPI authentication"),
    KERBEROS_SERVER_NAME("kerberosservername", null, "The Kerberos service name to use when authenticating with GSSAPI."),
    LOAD_BALANCE_HOSTS("loadbalancehosts", "false", "If disabled hosts are connected in the given order. If enabled hosts are chosen randomly from the set of suitable candidates"),
    LOG_PATH("logpath", null, "File Path output of the Logger"),
    MAX_LOG_FILE_SIZE("maxlogfilesize", null, "Maximum single log file size"),
    MAX_LOG_FILE_COUNT("maxlogfilecount", null, "Maximum number of log files"),
    LOG_LEVEL("loglevel", null, "Log level of the driver", false, new String[]{"OFF", "FATAL", "ERROR", "WARNING", "INFO", "FUNCTION", "DEBUG", "TRACE"}),
    DSI_LOG_LEVEL("dsiloglevel", null, "Log level of the driver", false, new String[]{"OFF", "FATAL", "ERROR", "WARNING", "INFO", "FUNCTION", "DEBUG", "TRACE"}),
    LOGIN_TIMEOUT("logintimeout", "0", "Specify how long to wait for establishment of a database connection."),
    LOG_SERVER_ERROR_DETAIL("logservererrordetail", "true", "Include full server error detail in exception messages. If disabled then only the error itself will be included."),
    LOG_UNCLOSED_CONNECTIONS("logunclosedconnections", "false", "When connections that are not explicitly closed are garbage collected, log the stacktrace from the opening of the connection to trace the leak source"),
    MAX_RESULT_BUFFER("maxresultbuffer", null, "Specifies size of buffer during fetching result set. Can be specified as specified size or percent of heap memory."),
    OPTIONS("options", null, "Specify 'options' connection initialization parameter."),
    OVERRIDE_SCHEMA_PATTERN_TYPE("overrideschemapatterntype", null, "Override the type of query used in getTables calls"),
    PASSWORD("password", null, "Password to use when authenticating.", false),
    PWD("pwd", null, "Password to use when authenticating.", false),
    QUERY_GROUP("querygroup", null, "Assign a query to a queue at runtime by assigning your query to the appropriate query group"),
    DBNAME("dbname", null, "Database name to connect to (may be specified directly in the JDBC URL)", true),
    HOST("host", null, "Hostname of the Redshift server (may be specified directly in the JDBC URL)", false),
    PORT("port", null, "Port of the Redshift server (may be specified directly in the JDBC URL)"),
    PREFER_QUERY_MODE("preferquerymode", "extended", "Specifies which mode is used to execute queries to database: simple means ('Q' execute, no parse, no bind, text mode only), extended means always use bind/execute messages, extendedForPrepared means extended for prepared statements only, extendedCacheEverything means use extended protocol and try cache every statement (including Statement.execute(String sql)) in a query cache.", false, new String[]{"extended", "extendedForPrepared", "extendedCacheEverything", "simple"}),
    PREPARED_STATEMENT_CACHE_QUERIES("preparedstatementcachequeries", "256", "Specifies the maximum number of entries in per-connection cache of prepared statements. A value of {@code 0} disables the cache."),
    PREPARED_STATEMENT_CACHE_SIZE_MIB("preparedstatementcachesizemib", "5", "Specifies the maximum size (in megabytes) of a per-connection prepared statement cache. A value of {@code 0} disables the cache."),
    PREPARE_THRESHOLD("preparethreshold", "5", "Statement prepare threshold. A value of {@code -1} stands for forceBinary"),
    PROTOCOL_VERSION("protocolversion", null, "Force use of a particular protocol version when connecting, currently only version 3 is supported.", false, new String[]{"3"}),
    RAISE_EXCEPTION_ON_SILENT_ROLLBACK("raiseexceptiononsilentrollback", "false", "Certain database versions perform a silent rollback instead of commit in case the transaction was in a failed state"),
    READ_ONLY("readonly", "false", "Puts this connection in read-only mode"),
    READ_ONLY_MODE("readonlymode", "always", "Controls the behavior when a connection is set to be read only, one of 'ignore', 'transaction', or 'always' When 'ignore', setting readOnly has no effect. When 'transaction' setting readOnly to 'true' will cause transactions to BEGIN READ ONLY if autocommit is 'false'. When 'always' setting readOnly to 'true' will set the session to READ ONLY if autoCommit is 'true' and the transaction to BEGIN READ ONLY if autocommit is 'false'.", false, new String[]{"ignore", "transaction", "always"}),
    RECEIVE_BUFFER_SIZE("receivebuffersize", "-1", "Socket read buffer size"),
    REPLICATION("replication", null, "Connection parameter passed in startup message, one of 'true' or 'database' Passing 'true' tells the backend to go into walsender mode, wherein a small set of replication commands can be issued instead of SQL statements. Only the simple query protocol can be used in walsender mode. Passing 'database' as the value instructs walsender to connect to the database specified in the dbname parameter, which will allow the connection to be used for logical replication from that database. (backend >= 9.4)"),
    REWRITE_BATCHED_INSERTS("rewritebatchedinserts", "false", "Enable optimization to rewrite and collapse compatible INSERT statements that are batched."),
    REWRITE_BATCHED_INSERTS_SIZE("rewritebatchedinsertssize", "128", "Enable optimization size to rewrite and collapse compatible INSERT statements that are batched. This must be power of 2"),
    SEND_BUFFER_SIZE("sendbuffersize", "-1", "Socket write buffer size"),
    SOCKET_FACTORY("socketfactory", null, "Specify a socket factory for socket creation"),
    SOCKET_FACTORY_ARG("socketfactoryarg", null, "Argument forwarded to constructor of SocketFactory class."),
    SOCKET_TIMEOUT("sockettimeout", "0", "The timeout value used for socket read operations."),
    SSL("ssl", "true", "Control use of SSL (any non-null value causes SSL to be required)"),
    SSL_CERT("sslcert", null, "The location of the client's SSL certificate"),
    SSL_FACTORY("sslfactory", null, "Provide a SSLSocketFactory class when using SSL."),
    SSL_FACTORY_ARG("sslfactoryarg", null, "Argument forwarded to constructor of SSLSocketFactory class."),
    SSL_HOSTNAME_VERIFIER("sslhostnameverifier", null, "A class, implementing javax.net.ssl.HostnameVerifier that can verify the server"),
    SSL_KEY("sslkey", null, "The location of the client's PKCS#8 SSL key"),
    SSL_MODE("sslmode", null, "Parameter governing the use of SSL", false, new String[]{"disable", "allow", "prefer", "require", "verify-ca", "verify-full"}),
    AUTH_MECH("authmech", null, "Parameter governing the use of SSL. Alias for sslMode", false, new String[]{"disable", "allow", "prefer", "require", "verify-ca", "verify-full"}),
    SSL_PASSWORD("sslpassword", null, "The password for the client's ssl key (ignored if sslpasswordcallback is set)"),
    SSL_PASSWORD_CALLBACK("sslpasswordcallback", null, "A class, implementing javax.security.auth.callback.CallbackHandler that can handle PassworCallback for the ssl password."),
    SSL_ROOT_CERT("sslrootcert", null, "The location of the root certificate for authenticating the server."),
    SSL_TRUSTSTORE_PATH_KEY("ssltruststorepath", null, "The SSL Truststore path key."),
    SSL_TRUSTSTORE_PWD_KEY("ssltruststore ", null, "The SSL Truststore password key."),
    SSPI_SERVICE_CLASS("sspiserviceclass", "REDSHIFT", "The Windows SSPI service class for SPN"),
    STRING_TYPE("stringtype", "unspecified", "The type to bind String parameters as (usually 'varchar', 'unspecified' allows implicit casting to other types)", false, new String[]{"unspecified", "varchar"}),
    TARGET_SERVER_TYPE("targetservertype", "any", "Specifies what kind of server to connect", false, new String[]{"any", "primary", "master", "slave", "secondary", "preferSlave", "preferSecondary"}),
    TCP_KEEP_ALIVE("tcpkeepalive", "true", "Enable or disable TCP keep-alive. The default is {@code true}."),
    UNKNOWN_LENGTH("unknownlength", Integer.toString(Integer.MAX_VALUE), "Specifies the length to return for types of unknown length"),
    USER("user", null, "Username to connect to the database as.", true),
    UID("uid", null, "Username to connect to the database as.", true),
    USE_SPNEGO("usespnego", "false", "Use SPNEGO in SSPI authentication requests"),
    CLUSTER_IDENTIFIER("clusterid", null, "The name of the Redshift cluster to connect to"),
    IAM_DURATION("iamduration", null, "The length of time (in seconds) until the temporary IAM credentials expire."),
    IAM_ACCESS_KEY_ID("accesskeyid", null, "The IAM access key id for the IAM user or role"),
    IAM_AUTH("iamauth", "false", "Indicates whether use IAM authentication"),
    IAM_DISABLE_CACHE("iamdisablecache", "false", "Indicates to disable credential cache. Enable cache gives protection against throttling API calls"),
    IDC_IDENTITY_NAMESPACE("identity_namespace", null, "Indicates the identity namespace which helps to decide which IdC instance to use in Redshift server"),
    TOKEN_TYPE("token_type", null, "Indicates the optional token type to be used for connection"),
    IDC_CLIENT_DISPLAY_NAME("idc_client_display_name", "Amazon Redshift JDBC driver", "Indicates the display name to be used for the client that is using IdC browser auth plugin"),
    AWS_REGION("region", null, "The AWS region where the cluster is located"),
    ENDPOINT_URL("endpointurl", null, "The Redshift endpoint url"),
    STS_ENDPOINT_URL("stsendpointurl", null, "The STS endpoint url"),
    AWS_PROFILE("profile", null, "The AWS profile name for credentials"),
    IAM_SECRET_ACCESS_KEY("secretaccesskey", null, "The IAM secret key for the IAM user or role"),
    IAM_SESSION_TOKEN("sessiontoken", null, "The IAM security token for an IAM user or role"),
    CREDENTIALS_PROVIDER("plugin_name", null, "The fully qualified class path for a class that implements AWSCredentialsProvider"),
    USER_AUTOCREATE("autocreate", null, "Indicates whether the user should be created if not exists"),
    DB_USER("dbuser", null, "The database user name"),
    DB_GROUPS("dbgroups", null, "A comma delimited database group names"),
    DB_GROUPS_FILTER("dbgroupsfilter", null, "Regex for filtering out dbGroups from final result"),
    FORCE_LOWERCASE("forcelowercase", null, "Forces database group names to be lower case"),
    GROUP_FEDERATION("groupfederation", "false", "Use the IDP Groups in the Redshift"),
    WEB_IDENTITY_TOKEN("webidentitytoken", null, "The Oauth access token for an idp connection"),
    PROVIDER_NAME("providername", null, "The name of the Redshift Native Auth Provider"),
    IS_SERVERLESS("isserverless", "false", "Redshift end-point is serverless or provisional."),
    SERVERLESS_ACCT_ID("serverlessacctid", null, "The account ID of the serverless"),
    SERVERLESS_WORK_GROUP("serverlessworkgroup", null, "The work group of the serverless");

    private final String name;
    private final String defaultValue;
    private final boolean required;
    private final String description;
    private final String[] choices;
    private final boolean deprecated;
    private static final Set<String> publicProperties;
    private static final Map<String, RedshiftProperty> PROPS_BY_NAME;

    private RedshiftProperty(String name, String defaultValue, String description) {
        this(name, defaultValue, description, false);
    }

    private RedshiftProperty(String name, String defaultValue, String description, boolean required) {
        this(name, defaultValue, description, required, null);
    }

    private RedshiftProperty(String name, String defaultValue, String description, boolean required, String[] choices) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.required = required;
        this.description = description;
        this.choices = choices;
        try {
            this.deprecated = RedshiftProperty.class.getField(this.name()).getAnnotation(Deprecated.class) != null;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getChoices() {
        return this.choices;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public String get(Properties properties) {
        return properties.getProperty(this.name, this.defaultValue);
    }

    public void set(Properties properties, String value) {
        if (value == null) {
            properties.remove(this.name);
        } else {
            properties.setProperty(this.name, value);
        }
    }

    public boolean getBoolean(Properties properties) {
        return Boolean.valueOf(this.get(properties));
    }

    public int getIntNoCheck(Properties properties) {
        String value = this.get(properties);
        return Integer.parseInt(value);
    }

    public int getInt(Properties properties) throws RedshiftException {
        String value = this.get(properties);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw new RedshiftException(GT.tr("{0} parameter value must be an integer but was: {1}", this.getName(), value), RedshiftState.INVALID_PARAMETER_VALUE, (Throwable)nfe);
        }
    }

    public Integer getInteger(Properties properties) throws RedshiftException {
        String value = this.get(properties);
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw new RedshiftException(GT.tr("{0} parameter value must be an integer but was: {1}", this.getName(), value), RedshiftState.INVALID_PARAMETER_VALUE, (Throwable)nfe);
        }
    }

    public void set(Properties properties, boolean value) {
        properties.setProperty(this.name, Boolean.toString(value));
    }

    public void set(Properties properties, int value) {
        properties.setProperty(this.name, Integer.toString(value));
    }

    public boolean isPresent(Properties properties) {
        return this.getSetString(properties) != null;
    }

    public DriverPropertyInfo toDriverPropertyInfo(Properties properties) {
        DriverPropertyInfo propertyInfo = new DriverPropertyInfo(this.name, this.get(properties));
        propertyInfo.required = this.required;
        propertyInfo.description = this.description;
        propertyInfo.choices = this.choices;
        return propertyInfo;
    }

    public static RedshiftProperty forName(String name) {
        return PROPS_BY_NAME.get(name);
    }

    public String getSetString(Properties properties) {
        Object o = properties.get(this.name);
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public static Set<String> getPublicProperties() {
        return publicProperties;
    }

    static {
        publicProperties = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("AccessKeyID", "AllowDBUserOverride", "App_ID", "App_Name", "ApplicationName", "AuthProfile", "AutoCreate", "Client_ID", "Client_Secret", "client_protocol_version", "ClusterID", "connectTimeout", "databaseMetadataCurrentDbOnly", "DbUser", "DbGroups", "DBNAME", "defaultRowFetchSize", "DisableIsValidQuery", "enableFetchReadAndProcessBuffers", "enableFetchRingBuffer", "enableMultiSqlSupport", "endpointUrl", "fetchRingBufferSize", "ForceLowercase", "groupFederation", "HOST", "IAMDisableCache", "IAMDuration", "IdP_Host", "IdP_Port", "IdP_Tenant", "IdP_Response_Timeout", "IniFile", "IniSection", "isServerless", "Login_URL", "loginTimeout", "loginToRp", "LogLevel", "LogPath", "OverrideSchemaPatternType", "Partner_SPID", "Password", "Plugin_Name", "PORT", "Preferred_Role", "Profile", "PWD", "queryGroup", "readOnly", "Region", "reWriteBatchedInserts", "reWriteBatchedInsertsSize", "roleArn", "roleSessionName", "scope", "SecretAccessKey", "SessionToken", "serverlessAcctId", "serverlessWorkGroup", "socketFactory", "socketTimeout", "SSL", "SSL_Insecure", "SSLCert", "SSLFactory", "SSLKey", "SSLMode", "SSLPassword", "SSLRootCert", "StsEndpointUrl", "tcpKeepAlive", "UID", "User", "Username", "webIdentityToken")));
        PROPS_BY_NAME = new HashMap<String, RedshiftProperty>();
        for (RedshiftProperty prop : RedshiftProperty.values()) {
            if (PROPS_BY_NAME.put(prop.getName(), prop) == null) continue;
            throw new IllegalStateException("Duplicate RedshiftProperty name: " + prop.getName());
        }
    }
}

