/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.DoFnRunners;
import org.apache.beam.runners.core.InMemoryBundleFinalizer;
import org.apache.beam.runners.core.NullSideInputReader;
import org.apache.beam.runners.core.ProcessFnRunner;
import org.apache.beam.runners.core.PushbackSideInputDoFnRunner;
import org.apache.beam.runners.core.ReadyCheckingSideInputReader;
import org.apache.beam.runners.core.SideInputHandler;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.core.SimplePushbackSideInputDoFnRunner;
import org.apache.beam.runners.core.SplittableParDoViaKeyedWorkItems;
import org.apache.beam.runners.core.StateInternals;
import org.apache.beam.runners.core.StateNamespace;
import org.apache.beam.runners.core.StateNamespaces;
import org.apache.beam.runners.core.StatefulDoFnRunner;
import org.apache.beam.runners.core.StepContext;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.metrics.DoFnRunnerWithMetricsUpdate;
import org.apache.beam.runners.flink.metrics.FlinkMetricContainer;
import org.apache.beam.runners.flink.translation.types.CoderTypeSerializer;
import org.apache.beam.runners.flink.translation.utils.CheckpointStats;
import org.apache.beam.runners.flink.translation.utils.Workarounds;
import org.apache.beam.runners.flink.translation.wrappers.streaming.AbstractStreamOperatorCompat;
import org.apache.beam.runners.flink.translation.wrappers.streaming.KeyedPushedBackElementsHandler;
import org.apache.beam.runners.flink.translation.wrappers.streaming.NonKeyedPushedBackElementsHandler;
import org.apache.beam.runners.flink.translation.wrappers.streaming.ProcessingTimeCallbackCompat;
import org.apache.beam.runners.flink.translation.wrappers.streaming.PushedBackElementsHandler;
import org.apache.beam.runners.flink.translation.wrappers.streaming.stableinput.BufferingDoFnRunner;
import org.apache.beam.runners.flink.translation.wrappers.streaming.state.FlinkBroadcastStateInternals;
import org.apache.beam.runners.flink.translation.wrappers.streaming.state.FlinkStateInternals;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.state.StateBinder;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.join.RawUnionValue;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.NoopLock;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.operators.ProcessingTimeService;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.runtime.state.InternalPriorityQueue;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.InternalTimeServiceManager;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.BiConsumerWithException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
public class DoFnOperator<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
extends AbstractStreamOperatorCompat<WindowedValue<OutputT>>
implements OneInputStreamOperator<WindowedValue<InputT>, WindowedValue<OutputT>>,
TwoInputStreamOperator<WindowedValue<InputT>, RawUnionValue, WindowedValue<OutputT>>,
Triggerable<ByteBuffer, TimerInternals.TimerData> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(DoFnOperator.class);
    protected @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn;
    protected final @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions serializedOptions;
    protected final @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> mainOutputTag;
    protected final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> additionalOutputTags;
    protected final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs;
    protected final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputTagMapping;
    protected final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy;
    protected final @UnknownKeyFor @NonNull @Initialized OutputManagerFactory<OutputT> outputManagerFactory;
    protected transient @UnknownKeyFor @NonNull @Initialized DoFnRunner<InputT, OutputT> doFnRunner;
    protected transient @UnknownKeyFor @NonNull @Initialized PushbackSideInputDoFnRunner<InputT, OutputT> pushbackDoFnRunner;
    protected transient @UnknownKeyFor @NonNull @Initialized BufferingDoFnRunner<InputT, OutputT> bufferingDoFnRunner;
    protected transient @UnknownKeyFor @NonNull @Initialized SideInputHandler sideInputHandler;
    protected transient @UnknownKeyFor @NonNull @Initialized SideInputReader sideInputReader;
    protected transient @UnknownKeyFor @NonNull @Initialized BufferedOutputManager<OutputT> outputManager;
    private transient @UnknownKeyFor @NonNull @Initialized DoFnInvoker<InputT, OutputT> doFnInvoker;
    protected transient /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized FlinkStateInternals<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> keyedStateInternals;
    protected transient @UnknownKeyFor @NonNull @Initialized DoFnOperator. @UnknownKeyFor @NonNull @Initialized FlinkTimerInternals timerInternals;
    protected final @UnknownKeyFor @NonNull @Initialized String stepName;
    final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>> windowedInputCoder;
    final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputCoders;
    final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> keyCoder;
    final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized KeySelector<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> keySelector;
    final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerDataCoderV2 timerCoder;
    private final @UnknownKeyFor @NonNull @Initialized long maxBundleSize;
    private final @UnknownKeyFor @NonNull @Initialized long maxBundleTimeMills;
    private final @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation doFnSchemaInformation;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping;
    final @UnknownKeyFor @NonNull @Initialized boolean requiresStableInput;
    final @UnknownKeyFor @NonNull @Initialized int numConcurrentCheckpoints;
    private final @UnknownKeyFor @NonNull @Initialized boolean usesOnWindowExpiration;
    private final @UnknownKeyFor @NonNull @Initialized boolean finishBundleBeforeCheckpointing;
    private transient @UnknownKeyFor @NonNull @Initialized InMemoryBundleFinalizer bundleFinalizer;
    private transient @UnknownKeyFor @NonNull @Initialized LinkedHashMap<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized InMemoryBundleFinalizer.Finalization>> pendingFinalizations;
    private static final @UnknownKeyFor @NonNull @Initialized int MAX_NUMBER_PENDING_BUNDLE_FINALIZATIONS = 32;
    protected transient @UnknownKeyFor @NonNull @Initialized InternalTimerService<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timerService;
    private transient /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized InternalTimeServiceManager<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> timeServiceManagerCompat;
    private transient @UnknownKeyFor @NonNull @Initialized PushedBackElementsHandler<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>> pushedBackElementsHandler;
    transient @Nullable @UnknownKeyFor @Initialized FlinkMetricContainer flinkMetricContainer;
    private transient @Nullable @UnknownKeyFor @Initialized CheckpointStats checkpointStats;
    private transient /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ScheduledFuture<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> checkFinishBundleTimer;
    private volatile transient @UnknownKeyFor @NonNull @Initialized boolean bundleStarted;
    private volatile transient @UnknownKeyFor @NonNull @Initialized long elementCount;
    private volatile transient @UnknownKeyFor @NonNull @Initialized long lastFinishBundleTime;
    private volatile transient @UnknownKeyFor @NonNull @Initialized Runnable preBundleCallback;
    private volatile transient @UnknownKeyFor @NonNull @Initialized Runnable bundleFinishedCallback;
    private volatile transient @UnknownKeyFor @NonNull @Initialized long currentInputWatermark;
    private volatile transient @UnknownKeyFor @NonNull @Initialized long currentSideInputWatermark;
    private volatile transient @UnknownKeyFor @NonNull @Initialized long currentOutputWatermark;
    private volatile transient @UnknownKeyFor @NonNull @Initialized long pushedBackWatermark;

    public DoFnOperator(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn, @UnknownKeyFor @NonNull @Initialized String stepName, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>> inputWindowedCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputCoders, @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> mainOutputTag, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> additionalOutputTags, @UnknownKeyFor @NonNull @Initialized OutputManagerFactory<OutputT> outputManagerFactory, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputTagMapping, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs, @UnknownKeyFor @NonNull @Initialized PipelineOptions options, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> keyCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized KeySelector<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> keySelector, @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation doFnSchemaInformation, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping) {
        this.doFn = doFn;
        this.stepName = stepName;
        this.windowedInputCoder = inputWindowedCoder;
        this.outputCoders = outputCoders;
        this.mainOutputTag = mainOutputTag;
        this.additionalOutputTags = additionalOutputTags;
        this.sideInputTagMapping = sideInputTagMapping;
        this.sideInputs = sideInputs;
        this.serializedOptions = new SerializablePipelineOptions(options);
        this.windowingStrategy = windowingStrategy;
        this.outputManagerFactory = outputManagerFactory;
        this.setChainingStrategy(ChainingStrategy.ALWAYS);
        this.keyCoder = keyCoder;
        this.keySelector = keySelector;
        this.timerCoder = TimerInternals.TimerDataCoderV2.of((Coder)windowingStrategy.getWindowFn().windowCoder());
        FlinkPipelineOptions flinkOptions = (FlinkPipelineOptions)options.as(FlinkPipelineOptions.class);
        this.maxBundleSize = flinkOptions.getMaxBundleSize();
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.maxBundleSize > 0L ? 1 : 0) != 0, (Object)"Bundle size must be at least 1");
        this.maxBundleTimeMills = flinkOptions.getMaxBundleTimeMills();
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.maxBundleTimeMills > 0L ? 1 : 0) != 0, (Object)"Bundle time must be at least 1");
        this.doFnSchemaInformation = doFnSchemaInformation;
        this.sideInputMapping = sideInputMapping;
        this.requiresStableInput = this.isRequiresStableInput(doFn);
        boolean bl = this.usesOnWindowExpiration = doFn != null && DoFnSignatures.getSignature(doFn.getClass()).onWindowExpiration() != null;
        if (this.requiresStableInput) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((CheckpointingMode.valueOf((String)flinkOptions.getCheckpointingMode()) == CheckpointingMode.EXACTLY_ONCE ? 1 : 0) != 0, (Object)"Checkpointing mode is not set to exactly once but @RequiresStableInput is used.");
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((flinkOptions.getCheckpointingInterval() > 0L ? 1 : 0) != 0, (Object)"No checkpointing configured but pipeline uses @RequiresStableInput");
            LOG.warn("Enabling stable input for transform {}. Will only process elements at most every {} milliseconds.", (Object)stepName, (Object)(flinkOptions.getCheckpointingInterval() + Math.max(0L, flinkOptions.getMinPauseBetweenCheckpoints())));
        }
        this.numConcurrentCheckpoints = flinkOptions.getNumConcurrentCheckpoints();
        this.finishBundleBeforeCheckpointing = flinkOptions.getFinishBundleBeforeCheckpointing();
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isRequiresStableInput(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
        return doFn != null && DoFnSignatures.getSignature(doFn.getClass()).processElement().requiresStableInput();
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized boolean getRequiresStableInput() {
        return this.requiresStableInput;
    }

    protected @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> getDoFn() {
        return this.doFn;
    }

    protected @UnknownKeyFor @NonNull @Initialized DoFnRunner<InputT, OutputT> createWrappingDoFnRunner(@UnknownKeyFor @NonNull @Initialized DoFnRunner<InputT, OutputT> wrappedRunner, @UnknownKeyFor @NonNull @Initialized StepContext stepContext) {
        if (this.keyCoder != null) {
            StatefulDoFnRunner.TimeInternalsCleanupTimer cleanupTimer = new StatefulDoFnRunner.TimeInternalsCleanupTimer<InputT>(this.timerInternals, this.windowingStrategy){

                public void setForWindow(InputT input, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
                    if (!window.equals(GlobalWindow.INSTANCE) || DoFnOperator.this.usesOnWindowExpiration) {
                        super.setForWindow(input, window);
                    }
                }
            };
            Coder windowCoder = this.windowingStrategy.getWindowFn().windowCoder();
            StatefulDoFnRunner.StateInternalsStateCleaner stateCleaner = new StatefulDoFnRunner.StateInternalsStateCleaner(this.doFn, this.keyedStateInternals, windowCoder);
            return DoFnRunners.defaultStatefulDoFnRunner(this.doFn, this.getInputCoder(), wrappedRunner, (StepContext)stepContext, this.windowingStrategy, (StatefulDoFnRunner.CleanupTimer)cleanupTimer, (StatefulDoFnRunner.StateCleaner)stateCleaner, (boolean)true);
        }
        return this.doFnRunner;
    }

    public void setup(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized StreamTask<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> containingTask, @UnknownKeyFor @NonNull @Initialized StreamConfig config, @UnknownKeyFor @NonNull @Initialized Output<@UnknownKeyFor @NonNull @Initialized StreamRecord<@UnknownKeyFor @NonNull @Initialized WindowedValue<OutputT>>> output) {
        FileSystems.setDefaultPipelineOptions((PipelineOptions)this.serializedOptions.get());
        super.setup(containingTask, config, output);
    }

    public void initializeState(@UnknownKeyFor @NonNull @Initialized StateInitializationContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
        super.initializeState(context);
        ListStateDescriptor pushedBackStateDescriptor = new ListStateDescriptor("pushed-back-elements", new CoderTypeSerializer<WindowedValue<InputT>>(this.windowedInputCoder, this.serializedOptions));
        if (this.keySelector != null) {
            this.pushedBackElementsHandler = KeyedPushedBackElementsHandler.create(this.keySelector, this.getKeyedStateBackend(), pushedBackStateDescriptor);
        } else {
            ListState listState = this.getOperatorStateBackend().getListState(pushedBackStateDescriptor);
            this.pushedBackElementsHandler = NonKeyedPushedBackElementsHandler.create(listState);
        }
        this.currentInputWatermark = BoundedWindow.TIMESTAMP_MIN_VALUE.getMillis();
        this.currentSideInputWatermark = BoundedWindow.TIMESTAMP_MIN_VALUE.getMillis();
        this.currentOutputWatermark = BoundedWindow.TIMESTAMP_MIN_VALUE.getMillis();
        this.sideInputReader = NullSideInputReader.of(this.sideInputs);
        if (!this.sideInputs.isEmpty()) {
            long min;
            FlinkBroadcastStateInternals sideInputStateInternals = new FlinkBroadcastStateInternals(this.getContainingTask().getIndexInSubtaskGroup(), this.getOperatorStateBackend(), this.serializedOptions);
            this.sideInputHandler = new SideInputHandler(this.sideInputs, sideInputStateInternals);
            this.sideInputReader = this.sideInputHandler;
            Stream<WindowedValue<InputT>> pushedBack = this.pushedBackElementsHandler.getElements();
            this.pushedBackWatermark = min = pushedBack.map(v -> v.getTimestamp().getMillis()).reduce(Long.MAX_VALUE, Math::min).longValue();
        } else {
            this.pushedBackWatermark = Long.MAX_VALUE;
        }
        if (this.keyCoder != null) {
            this.keyedStateInternals = new FlinkStateInternals((KeyedStateBackend<ByteBuffer>)this.getKeyedStateBackend(), this.keyCoder, this.serializedOptions);
            if (this.timerService == null) {
                this.timerService = this.getInternalTimerService("beam-timer", new CoderTypeSerializer(this.timerCoder, this.serializedOptions), this);
            }
            this.timerInternals = new FlinkTimerInternals(this.timerService);
            this.timeServiceManagerCompat = this.getTimeServiceManagerCompat();
        }
        this.outputManager = this.outputManagerFactory.create(this.output, this.getLockToAcquireForStateAccessDuringBundles(), this.getOperatorStateBackend());
    }

    protected @UnknownKeyFor @NonNull @Initialized Lock getLockToAcquireForStateAccessDuringBundles() {
        return NoopLock.get();
    }

    public void open() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.doFn = this.getDoFn();
        FlinkPipelineOptions options = (FlinkPipelineOptions)this.serializedOptions.get().as(FlinkPipelineOptions.class);
        this.doFnInvoker = DoFnInvokers.tryInvokeSetupFor(this.doFn, (PipelineOptions)options);
        FlinkStepContext stepContext = new FlinkStepContext();
        this.doFnRunner = DoFnRunners.simpleRunner((PipelineOptions)options, this.doFn, (SideInputReader)this.sideInputReader, this.outputManager, this.mainOutputTag, this.additionalOutputTags, (StepContext)stepContext, this.getInputCoder(), this.outputCoders, this.windowingStrategy, (DoFnSchemaInformation)this.doFnSchemaInformation, this.sideInputMapping);
        this.doFnRunner = this.createBufferingDoFnRunnerIfNeeded(this.createWrappingDoFnRunner(this.doFnRunner, stepContext));
        this.earlyBindStateIfNeeded();
        if (!options.getDisableMetrics().booleanValue()) {
            this.flinkMetricContainer = new FlinkMetricContainer((RuntimeContext)this.getRuntimeContext());
            this.doFnRunner = new DoFnRunnerWithMetricsUpdate<InputT, OutputT>(this.stepName, this.doFnRunner, this.flinkMetricContainer);
            String checkpointMetricNamespace = options.getReportCheckpointDuration();
            if (checkpointMetricNamespace != null) {
                MetricName checkpointMetric = MetricName.named((String)checkpointMetricNamespace, (String)"checkpoint_duration");
                this.checkpointStats = new CheckpointStats(() -> this.flinkMetricContainer.getMetricsContainer(this.stepName).getDistribution(checkpointMetric));
            }
        }
        this.elementCount = 0L;
        this.lastFinishBundleTime = this.getProcessingTimeService().getCurrentProcessingTime();
        long bundleCheckPeriod = Math.max(this.maxBundleTimeMills / 2L, 1L);
        this.checkFinishBundleTimer = this.getProcessingTimeService().scheduleAtFixedRate(timestamp -> this.checkInvokeFinishBundleByTime(), bundleCheckPeriod, bundleCheckPeriod);
        this.pushbackDoFnRunner = this.doFn instanceof SplittableParDoViaKeyedWorkItems.ProcessFn ? new ProcessFnRunner(this.doFnRunner, this.sideInputs, (ReadyCheckingSideInputReader)this.sideInputHandler) : SimplePushbackSideInputDoFnRunner.create(this.doFnRunner, this.sideInputs, (ReadyCheckingSideInputReader)this.sideInputHandler);
        this.bundleFinalizer = new InMemoryBundleFinalizer();
        this.pendingFinalizations = new LinkedHashMap();
    }

    @UnknownKeyFor @NonNull @Initialized DoFnRunner<InputT, OutputT> createBufferingDoFnRunnerIfNeeded(@UnknownKeyFor @NonNull @Initialized DoFnRunner<InputT, OutputT> wrappedRunner) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (this.requiresStableInput) {
            this.bufferingDoFnRunner = BufferingDoFnRunner.create(wrappedRunner, "stable-input-buffer", this.windowedInputCoder, this.windowingStrategy.getWindowFn().windowCoder(), this.getOperatorStateBackend(), this.getBufferingKeyedStateBackend(), this.numConcurrentCheckpoints, this.serializedOptions);
            return this.bufferingDoFnRunner;
        }
        return wrappedRunner;
    }

    <K> @Nullable @UnknownKeyFor @Initialized KeyedStateBackend<K> getBufferingKeyedStateBackend() {
        return this.getKeyedStateBackend();
    }

    private void earlyBindStateIfNeeded() throws @UnknownKeyFor @NonNull @Initialized IllegalArgumentException, @UnknownKeyFor @NonNull @Initialized IllegalAccessException {
        if (this.keyCoder != null && this.doFn != null) {
            DoFnSignature signature = DoFnSignatures.getSignature(this.doFn.getClass());
            FlinkStateInternals.EarlyBinder earlyBinder = new FlinkStateInternals.EarlyBinder(this.getKeyedStateBackend(), this.serializedOptions);
            for (DoFnSignature.StateDeclaration value : signature.stateDeclarations().values()) {
                StateSpec spec = (StateSpec)((DoFnSignature.StateDeclaration)signature.stateDeclarations().get(value.id())).field().get(this.doFn);
                spec.bind(value.id(), (StateBinder)earlyBinder);
            }
            if (this.doFnRunner instanceof StatefulDoFnRunner) {
                ((StatefulDoFnRunner)this.doFnRunner).getSystemStateTags().forEach(tag -> tag.getSpec().bind(tag.getId(), (StateBinder)earlyBinder));
            }
        }
    }

    @Override
    void cleanUp() throws @UnknownKeyFor @NonNull @Initialized Exception {
        Optional.ofNullable(this.flinkMetricContainer).ifPresent(FlinkMetricContainer::registerMetricsForPipelineResult);
        Optional.ofNullable(this.checkFinishBundleTimer).ifPresent(timer -> timer.cancel(true));
        Workarounds.deleteStaticCaches();
        Optional.ofNullable(this.doFnInvoker).ifPresent(DoFnInvoker::invokeTeardown);
    }

    @Override
    void flushData() throws @UnknownKeyFor @NonNull @Initialized Exception {
        List pushedBackElements;
        if (this.numProcessingTimeTimers() > 0) {
            this.timerInternals.processPendingProcessingTimeTimers();
        }
        if (this.numProcessingTimeTimers() > 0) {
            throw new RuntimeException("There are still " + this.numProcessingTimeTimers() + " processing-time timers left, this indicates a bug");
        }
        this.processWatermark(new Watermark(Long.MAX_VALUE));
        while (this.bundleStarted) {
            this.invokeFinishBundle();
        }
        if (this.currentOutputWatermark < Long.MAX_VALUE) {
            throw new RuntimeException(String.format("There are still watermark holds left when terminating operator %s Watermark held %d", this.getOperatorName(), this.currentOutputWatermark));
        }
        if (!this.sideInputs.isEmpty() && (pushedBackElements = this.pushedBackElementsHandler.getElements().collect(Collectors.toList())).size() > 0) {
            String pushedBackString = Joiner.on((String)",").join(pushedBackElements);
            throw new RuntimeException("Leftover pushed-back data: " + pushedBackString + ". This indicates a bug.");
        }
    }

    public @UnknownKeyFor @NonNull @Initialized long getEffectiveInputWatermark() {
        long combinedPushedBackWatermark = this.pushedBackWatermark;
        if (this.requiresStableInput) {
            combinedPushedBackWatermark = Math.min(combinedPushedBackWatermark, this.bufferingDoFnRunner.getOutputWatermarkHold());
        }
        return Math.min(combinedPushedBackWatermark, this.currentInputWatermark);
    }

    public @UnknownKeyFor @NonNull @Initialized long getCurrentOutputWatermark() {
        return this.currentOutputWatermark;
    }

    protected final void setPreBundleCallback(@UnknownKeyFor @NonNull @Initialized Runnable callback) {
        this.preBundleCallback = callback;
    }

    protected final void setBundleFinishedCallback(@UnknownKeyFor @NonNull @Initialized Runnable callback) {
        this.bundleFinishedCallback = callback;
    }

    public final void processElement(@UnknownKeyFor @NonNull @Initialized StreamRecord<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>> streamRecord) {
        this.checkInvokeStartBundle();
        long oldHold = this.keyCoder != null ? this.keyedStateInternals.minWatermarkHoldMs() : -1L;
        this.doFnRunner.processElement((WindowedValue)streamRecord.getValue());
        this.checkInvokeFinishBundleByCount();
        this.emitWatermarkIfHoldChanged(oldHold);
    }

    public final void processElement1(@UnknownKeyFor @NonNull @Initialized StreamRecord<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>> streamRecord) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.checkInvokeStartBundle();
        Iterable justPushedBack = this.pushbackDoFnRunner.processElementInReadyWindows((WindowedValue)streamRecord.getValue());
        long min = this.pushedBackWatermark;
        for (WindowedValue pushedBackValue : justPushedBack) {
            min = Math.min(min, pushedBackValue.getTimestamp().getMillis());
            this.pushedBackElementsHandler.pushBack(pushedBackValue);
        }
        this.pushedBackWatermark = min;
        this.checkInvokeFinishBundleByCount();
    }

    protected void addSideInputValue(@UnknownKeyFor @NonNull @Initialized StreamRecord<@UnknownKeyFor @NonNull @Initialized RawUnionValue> streamRecord) {
        WindowedValue value = (WindowedValue)((RawUnionValue)streamRecord.getValue()).getValue();
        PCollectionView<?> sideInput = this.sideInputTagMapping.get(((RawUnionValue)streamRecord.getValue()).getUnionTag());
        this.sideInputHandler.addSideInputValue(sideInput, value);
    }

    public final void processElement2(@UnknownKeyFor @NonNull @Initialized StreamRecord<@UnknownKeyFor @NonNull @Initialized RawUnionValue> streamRecord) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.invokeFinishBundle();
        this.checkInvokeStartBundle();
        this.addSideInputValue(streamRecord);
        ArrayList newPushedBack = new ArrayList();
        Iterator it = this.pushedBackElementsHandler.getElements().iterator();
        while (it.hasNext()) {
            WindowedValue element = (WindowedValue)it.next();
            this.setKeyContextElement1(new StreamRecord((Object)element));
            Iterable justPushedBack = this.pushbackDoFnRunner.processElementInReadyWindows(element);
            Iterables.addAll(newPushedBack, (Iterable)justPushedBack);
        }
        this.pushedBackElementsHandler.clear();
        long min = Long.MAX_VALUE;
        for (WindowedValue pushedBackValue : newPushedBack) {
            min = Math.min(min, pushedBackValue.getTimestamp().getMillis());
            this.pushedBackElementsHandler.pushBack(pushedBackValue);
        }
        this.pushedBackWatermark = min;
        this.checkInvokeFinishBundleByCount();
        this.processWatermark1(new Watermark(this.currentInputWatermark));
    }

    public final void processWatermark(@UnknownKeyFor @NonNull @Initialized Watermark mark) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.processWatermark1(mark);
    }

    public final void processWatermark1(@UnknownKeyFor @NonNull @Initialized Watermark mark) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.outputManager.flushBuffer();
        if (this.currentSideInputWatermark >= BoundedWindow.TIMESTAMP_MAX_VALUE.getMillis()) {
            this.emitAllPushedBackData();
        }
        this.currentInputWatermark = mark.getTimestamp();
        this.processInputWatermark(true);
    }

    private void processInputWatermark(@UnknownKeyFor @NonNull @Initialized boolean advanceInputWatermark) throws @UnknownKeyFor @NonNull @Initialized Exception {
        long inputWatermarkHold = this.applyInputWatermarkHold(this.getEffectiveInputWatermark());
        if (this.keyCoder != null && advanceInputWatermark) {
            this.timeServiceManagerCompat.advanceWatermark(new Watermark(inputWatermarkHold));
        }
        long potentialOutputWatermark = this.applyOutputWatermarkHold(this.currentOutputWatermark, this.computeOutputWatermark(inputWatermarkHold));
        this.maybeEmitWatermark(potentialOutputWatermark);
    }

    public @UnknownKeyFor @NonNull @Initialized long applyInputWatermarkHold(@UnknownKeyFor @NonNull @Initialized long inputWatermark) {
        return inputWatermark;
    }

    public @UnknownKeyFor @NonNull @Initialized long applyOutputWatermarkHold(@UnknownKeyFor @NonNull @Initialized long currentOutputWatermark, @UnknownKeyFor @NonNull @Initialized long potentialOutputWatermark) {
        return potentialOutputWatermark;
    }

    private @UnknownKeyFor @NonNull @Initialized long computeOutputWatermark(@UnknownKeyFor @NonNull @Initialized long inputWatermarkHold) {
        long potentialOutputWatermark = this.keyCoder == null ? inputWatermarkHold : Math.min(this.keyedStateInternals.minWatermarkHoldMs(), inputWatermarkHold);
        return potentialOutputWatermark;
    }

    private void maybeEmitWatermark(@UnknownKeyFor @NonNull @Initialized long watermark) {
        if (watermark > this.currentOutputWatermark) {
            if (watermark >= BoundedWindow.TIMESTAMP_MAX_VALUE.getMillis()) {
                this.invokeFinishBundle();
            }
            if (this.bundleStarted) {
                return;
            }
            LOG.debug("Emitting watermark {} from {}", (Object)watermark, (Object)this.getOperatorName());
            this.currentOutputWatermark = watermark;
            this.output.emitWatermark(new Watermark(watermark));
            if (this.keyedStateInternals != null && this.currentOutputWatermark > DoFnOperator.adjustTimestampForFlink(GlobalWindow.INSTANCE.maxTimestamp().getMillis())) {
                this.keyedStateInternals.clearGlobalState();
            }
        }
    }

    public final void processWatermark2(@UnknownKeyFor @NonNull @Initialized Watermark mark) throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.currentSideInputWatermark = mark.getTimestamp();
        if (mark.getTimestamp() >= BoundedWindow.TIMESTAMP_MAX_VALUE.getMillis()) {
            this.emitAllPushedBackData();
            this.processWatermark1(new Watermark(this.currentInputWatermark));
        }
    }

    private void emitAllPushedBackData() throws @UnknownKeyFor @NonNull @Initialized Exception {
        Iterator it = this.pushedBackElementsHandler.getElements().iterator();
        while (it.hasNext()) {
            this.checkInvokeStartBundle();
            WindowedValue element = (WindowedValue)it.next();
            this.setKeyContextElement1(new StreamRecord((Object)element));
            this.doFnRunner.processElement(element);
        }
        this.pushedBackElementsHandler.clear();
        this.pushedBackWatermark = Long.MAX_VALUE;
    }

    private void checkInvokeStartBundle() {
        if (!this.bundleStarted) {
            this.outputManager.flushBuffer();
            LOG.debug("Starting bundle.");
            if (this.preBundleCallback != null) {
                this.preBundleCallback.run();
            }
            this.pushbackDoFnRunner.startBundle();
            this.bundleStarted = true;
        }
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"})
    private void checkInvokeFinishBundleByCount() {
        ++this.elementCount;
        if (this.elementCount >= this.maxBundleSize) {
            this.invokeFinishBundle();
            this.updateOutputWatermark();
        }
    }

    private void checkInvokeFinishBundleByTime() {
        long now = this.getProcessingTimeService().getCurrentProcessingTime();
        if (now - this.lastFinishBundleTime >= this.maxBundleTimeMills) {
            this.invokeFinishBundle();
            this.scheduleForCurrentProcessingTime(ts -> this.updateOutputWatermark());
        }
    }

    protected void scheduleForCurrentProcessingTime(@UnknownKeyFor @NonNull @Initialized ProcessingTimeCallbackCompat callback) {
        ProcessingTimeService timeService = this.getProcessingTimeService();
        timeService.registerTimer(timeService.getCurrentProcessingTime(), (ProcessingTimeService.ProcessingTimeCallback)callback);
    }

    void updateOutputWatermark() {
        try {
            this.processInputWatermark(false);
        }
        catch (Exception ex) {
            this.failBundleFinalization(ex);
        }
    }

    protected final void invokeFinishBundle() {
        long previousBundleFinishTime = this.lastFinishBundleTime;
        if (this.bundleStarted) {
            LOG.debug("Finishing bundle.");
            this.pushbackDoFnRunner.finishBundle();
            LOG.debug("Finished bundle. Element count: {}", (Object)this.elementCount);
            this.elementCount = 0L;
            this.lastFinishBundleTime = this.getProcessingTimeService().getCurrentProcessingTime();
            this.bundleStarted = false;
            if (this.bundleFinishedCallback != null) {
                LOG.debug("Invoking bundle finish callback.");
                this.bundleFinishedCallback.run();
            }
        }
        try {
            if (previousBundleFinishTime - this.getProcessingTimeService().getCurrentProcessingTime() > this.maxBundleTimeMills) {
                this.processInputWatermark(false);
            }
        }
        catch (Exception ex) {
            LOG.warn("Failed to update downstream watermark", (Throwable)ex);
        }
    }

    public void prepareSnapshotPreBarrier(@UnknownKeyFor @NonNull @Initialized long checkpointId) {
        if (this.finishBundleBeforeCheckpointing) {
            while (this.bundleStarted) {
                this.invokeFinishBundle();
            }
            this.updateOutputWatermark();
        }
    }

    public final void snapshotState(@UnknownKeyFor @NonNull @Initialized StateSnapshotContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
        int diff;
        if (this.checkpointStats != null) {
            this.checkpointStats.snapshotStart(context.getCheckpointId());
        }
        if (this.requiresStableInput) {
            this.bufferingDoFnRunner.checkpoint(context.getCheckpointId());
        }
        if ((diff = this.pendingFinalizations.size() - 32) >= 0) {
            Iterator<Long> iterator = this.pendingFinalizations.keySet().iterator();
            while (diff >= 0) {
                iterator.next();
                iterator.remove();
                --diff;
            }
        }
        this.pendingFinalizations.put(context.getCheckpointId(), this.bundleFinalizer.getAndClearFinalizations());
        try {
            this.outputManager.openBuffer();
            while (this.bundleStarted) {
                this.invokeFinishBundle();
            }
            this.outputManager.closeBuffer();
        }
        catch (Exception e) {
            this.failBundleFinalization(e);
        }
        super.snapshotState(context);
    }

    private void failBundleFinalization(@UnknownKeyFor @NonNull @Initialized Exception e) {
        throw new Error("Checkpointing failed because bundle failed to finalize.", e);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn.BundleFinalizer getBundleFinalizer() {
        return this.bundleFinalizer;
    }

    public void notifyCheckpointComplete(@UnknownKeyFor @NonNull @Initialized long checkpointId) throws @UnknownKeyFor @NonNull @Initialized Exception {
        List finalizations;
        if (this.checkpointStats != null) {
            this.checkpointStats.reportCheckpointDuration(checkpointId);
        }
        if (this.requiresStableInput) {
            this.bufferingDoFnRunner.checkpointCompleted(checkpointId);
            this.updateOutputWatermark();
        }
        if ((finalizations = (List)this.pendingFinalizations.remove(checkpointId)) != null) {
            for (InMemoryBundleFinalizer.Finalization finalization : finalizations) {
                finalization.getCallback().onBundleSuccess();
            }
        }
        super.notifyCheckpointComplete(checkpointId);
    }

    public void onEventTime(@UnknownKeyFor @NonNull @Initialized InternalTimer<@UnknownKeyFor @NonNull @Initialized ByteBuffer, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timer) {
        this.checkInvokeStartBundle();
        this.fireTimerInternal((ByteBuffer)timer.getKey(), (TimerInternals.TimerData)timer.getNamespace());
    }

    public void onProcessingTime(@UnknownKeyFor @NonNull @Initialized InternalTimer<@UnknownKeyFor @NonNull @Initialized ByteBuffer, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timer) {
        this.checkInvokeStartBundle();
        this.fireTimerInternal((ByteBuffer)timer.getKey(), (TimerInternals.TimerData)timer.getNamespace());
    }

    protected void fireTimerInternal(@UnknownKeyFor @NonNull @Initialized ByteBuffer key, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timerData) {
        long oldHold = this.keyCoder != null ? this.keyedStateInternals.minWatermarkHoldMs() : -1L;
        this.fireTimer(timerData);
        this.emitWatermarkIfHoldChanged(oldHold);
    }

    void emitWatermarkIfHoldChanged(@UnknownKeyFor @NonNull @Initialized long currentWatermarkHold) {
        long newWatermarkHold;
        if (this.keyCoder != null && (newWatermarkHold = this.keyedStateInternals.minWatermarkHoldMs().longValue()) > currentWatermarkHold) {
            try {
                this.processInputWatermark(false);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    protected void fireTimer(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timerData) {
        LOG.debug("Firing timer: {} at {} with output time {}", new Object[]{timerData.getTimerId(), timerData.getTimestamp().getMillis(), timerData.getOutputTimestamp().getMillis()});
        StateNamespace namespace = timerData.getNamespace();
        Preconditions.checkArgument((boolean)(namespace instanceof StateNamespaces.WindowNamespace));
        BoundedWindow window = ((StateNamespaces.WindowNamespace)namespace).getWindow();
        this.timerInternals.onFiredOrDeletedTimer(timerData);
        this.pushbackDoFnRunner.onTimer(timerData.getTimerId(), timerData.getTimerFamilyId(), this.keyedStateInternals.getKey(), window, timerData.getTimestamp(), timerData.getOutputTimestamp(), timerData.getDomain());
    }

    @UnknownKeyFor @NonNull @Initialized Coder<InputT> getInputCoder() {
        return (Coder)Iterables.getOnlyElement((Iterable)this.windowedInputCoder.getCoderArguments());
    }

    static @UnknownKeyFor @NonNull @Initialized long adjustTimestampForFlink(@UnknownKeyFor @NonNull @Initialized long beamTimerTimestamp) {
        if (beamTimerTimestamp == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return beamTimerTimestamp + 1L;
    }

    class FlinkTimerInternals
    implements TimerInternals {
        private static final @UnknownKeyFor @NonNull @Initialized String PENDING_TIMERS_STATE_NAME = "pending-timers";
        @VisibleForTesting
        final @UnknownKeyFor @NonNull @Initialized MapState<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> pendingTimersById;
        private final @UnknownKeyFor @NonNull @Initialized InternalTimerService<// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timerService;

        private FlinkTimerInternals(InternalTimerService<TimerInternals.TimerData> timerService) throws @UnknownKeyFor @NonNull @Initialized Exception {
            MapStateDescriptor pendingTimersByIdStateDescriptor = new MapStateDescriptor(PENDING_TIMERS_STATE_NAME, (TypeSerializer)new StringSerializer(), new CoderTypeSerializer(DoFnOperator.this.timerCoder, DoFnOperator.this.serializedOptions));
            this.pendingTimersById = DoFnOperator.this.getKeyedStateStore().getMapState(pendingTimersByIdStateDescriptor);
            this.timerService = timerService;
            this.populateOutputTimestampQueue(timerService);
        }

        void processPendingProcessingTimeTimers() {
            InternalTimer internalTimer;
            KeyedStateBackend keyedStateBackend = DoFnOperator.this.getKeyedStateBackend();
            InternalPriorityQueue<InternalTimer<Object, TimerInternals.TimerData>> processingTimeTimersQueue = Workarounds.retrieveInternalProcessingTimerQueue(this.timerService);
            while ((internalTimer = (InternalTimer)processingTimeTimersQueue.poll()) != null) {
                keyedStateBackend.setCurrentKey(internalTimer.getKey());
                TimerInternals.TimerData timer = (TimerInternals.TimerData)internalTimer.getNamespace();
                DoFnOperator.this.checkInvokeStartBundle();
                DoFnOperator.this.fireTimerInternal((ByteBuffer)internalTimer.getKey(), timer);
            }
        }

        private void populateOutputTimestampQueue(@UnknownKeyFor @NonNull @Initialized InternalTimerService<// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData> timerService) throws @UnknownKeyFor @NonNull @Initialized Exception {
            BiConsumerWithException consumer = (timerData, stamp) -> DoFnOperator.this.keyedStateInternals.addWatermarkHoldUsage(timerData.getOutputTimestamp());
            timerService.forEachEventTimeTimer(consumer);
            timerService.forEachProcessingTimeTimer(consumer);
        }

        private @UnknownKeyFor @NonNull @Initialized String constructTimerId(@UnknownKeyFor @NonNull @Initialized String timerFamilyId, @UnknownKeyFor @NonNull @Initialized String timerId) {
            return timerFamilyId + "+" + timerId;
        }

        public void setTimer(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId, @UnknownKeyFor @NonNull @Initialized Instant target, @UnknownKeyFor @NonNull @Initialized Instant outputTimestamp, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
            this.setTimer(TimerInternals.TimerData.of((String)timerId, (String)timerFamilyId, (StateNamespace)namespace, (Instant)target, (Instant)outputTimestamp, (TimeDomain)timeDomain));
        }

        @Deprecated
        public void setTimer(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timer) {
            try {
                LOG.debug("Setting timer: {} at {} with output time {}", new Object[]{timer.getTimerId(), timer.getTimestamp().getMillis(), timer.getOutputTimestamp().getMillis()});
                String contextTimerId = this.getContextTimerId(this.constructTimerId(timer.getTimerFamilyId(), timer.getTimerId()), timer.getNamespace());
                // Could not load outer class - annotation placement on inner may be incorrect
                @Nullable TimerInternals.TimerData oldTimer = (TimerInternals.TimerData)this.pendingTimersById.get((Object)contextTimerId);
                if (!timer.equals(oldTimer)) {
                    this.cancelPendingTimer(oldTimer);
                    this.registerTimer(timer, contextTimerId);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to set timer", e);
            }
        }

        private void registerTimer(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timer, @UnknownKeyFor @NonNull @Initialized String contextTimerId) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.pendingTimersById.put((Object)contextTimerId, (Object)timer);
            long time = timer.getTimestamp().getMillis();
            switch (timer.getDomain()) {
                case EVENT_TIME: {
                    this.timerService.registerEventTimeTimer((Object)timer, DoFnOperator.adjustTimestampForFlink(time));
                    break;
                }
                case PROCESSING_TIME: 
                case SYNCHRONIZED_PROCESSING_TIME: {
                    this.timerService.registerProcessingTimeTimer((Object)timer, DoFnOperator.adjustTimestampForFlink(time));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported time domain: " + timer.getDomain());
                }
            }
            DoFnOperator.this.keyedStateInternals.addWatermarkHoldUsage(timer.getOutputTimestamp());
        }

        private void cancelPendingTimerById(@UnknownKeyFor @NonNull @Initialized String contextTimerId) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.cancelPendingTimer((TimerInternals.TimerData)this.pendingTimersById.get((Object)contextTimerId));
        }

        private void cancelPendingTimer(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable @UnknownKeyFor @Initialized TimerInternals.TimerData timer) {
            if (timer != null) {
                this.deleteTimerInternal(timer);
            }
        }

        void onFiredOrDeletedTimer(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timer) {
            try {
                this.pendingTimersById.remove((Object)this.getContextTimerId(this.constructTimerId(timer.getTimerFamilyId(), timer.getTimerId()), timer.getNamespace()));
                DoFnOperator.this.keyedStateInternals.removeWatermarkHoldUsage(timer.getOutputTimestamp());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to cleanup pending timers state.", e);
            }
        }

        @Deprecated
        public void deleteTimer(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId) {
            throw new UnsupportedOperationException("Canceling of a timer by ID is not yet supported.");
        }

        public void deleteTimer(@UnknownKeyFor @NonNull @Initialized StateNamespace namespace, @UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
            try {
                this.cancelPendingTimerById(this.getContextTimerId(timerId, namespace));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to cancel timer", e);
            }
        }

        @Deprecated
        public void deleteTimer(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timer) {
            this.deleteTimer(timer.getNamespace(), this.constructTimerId(timer.getTimerFamilyId(), timer.getTimerId()), timer.getTimerFamilyId(), timer.getDomain());
        }

        void deleteTimerInternal(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timer) {
            long time = timer.getTimestamp().getMillis();
            switch (timer.getDomain()) {
                case EVENT_TIME: {
                    this.timerService.deleteEventTimeTimer((Object)timer, DoFnOperator.adjustTimestampForFlink(time));
                    break;
                }
                case PROCESSING_TIME: 
                case SYNCHRONIZED_PROCESSING_TIME: {
                    this.timerService.deleteProcessingTimeTimer((Object)timer, DoFnOperator.adjustTimestampForFlink(time));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported time domain: " + timer.getDomain());
                }
            }
            this.onFiredOrDeletedTimer(timer);
        }

        public @UnknownKeyFor @NonNull @Initialized Instant currentProcessingTime() {
            return new Instant(this.timerService.currentProcessingTime());
        }

        public @Nullable @UnknownKeyFor @Initialized Instant currentSynchronizedProcessingTime() {
            return new Instant(this.timerService.currentProcessingTime());
        }

        public @UnknownKeyFor @NonNull @Initialized Instant currentInputWatermarkTime() {
            return new Instant(DoFnOperator.this.getEffectiveInputWatermark());
        }

        public @Nullable @UnknownKeyFor @Initialized Instant currentOutputWatermarkTime() {
            return new Instant(DoFnOperator.this.currentOutputWatermark);
        }

        public @UnknownKeyFor @NonNull @Initialized boolean hasPendingEventTimeTimers(@UnknownKeyFor @NonNull @Initialized long maxTimestamp) throws @UnknownKeyFor @NonNull @Initialized Exception {
            for (TimerInternals.TimerData timer : this.pendingTimersById.values()) {
                if (timer.getDomain() != TimeDomain.EVENT_TIME || timer.getTimestamp().getMillis() > maxTimestamp) continue;
                return true;
            }
            return false;
        }

        private @UnknownKeyFor @NonNull @Initialized String getContextTimerId(@UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized StateNamespace namespace) {
            return timerId + namespace.stringKey();
        }
    }

    protected class FlinkStepContext
    implements StepContext {
        protected FlinkStepContext() {
        }

        public @UnknownKeyFor @NonNull @Initialized StateInternals stateInternals() {
            return DoFnOperator.this.keyedStateInternals;
        }

        public @UnknownKeyFor @NonNull @Initialized TimerInternals timerInternals() {
            return DoFnOperator.this.timerInternals;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.BundleFinalizer bundleFinalizer() {
            return DoFnOperator.this.bundleFinalizer;
        }
    }

    public static class MultiOutputOutputManagerFactory<@UnknownKeyFor OutputT>
    implements OutputManagerFactory<OutputT> {
        private final @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> mainTag;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Integer> tagsToIds;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized OutputTag<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> tagsToOutputTags;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> tagsToCoders;
        private final @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions pipelineOptions;

        public MultiOutputOutputManagerFactory(@UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> mainTag, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<OutputT>> mainCoder, @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions pipelineOptions) {
            this(mainTag, new HashMap(), (Map<TupleTag<?>, Coder<WindowedValue<?>>>)ImmutableMap.builder().put(mainTag, mainCoder).build(), (Map<TupleTag<?>, Integer>)ImmutableMap.builder().put(mainTag, (Object)0).build(), pipelineOptions);
        }

        public MultiOutputOutputManagerFactory(@UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> mainTag, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized OutputTag<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> tagsToOutputTags, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> tagsToCoders, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Integer> tagsToIds, @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions pipelineOptions) {
            this.mainTag = mainTag;
            this.tagsToOutputTags = tagsToOutputTags;
            this.tagsToCoders = tagsToCoders;
            this.tagsToIds = tagsToIds;
            this.pipelineOptions = pipelineOptions;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BufferedOutputManager<OutputT> create(@UnknownKeyFor @NonNull @Initialized Output<@UnknownKeyFor @NonNull @Initialized StreamRecord<@UnknownKeyFor @NonNull @Initialized WindowedValue<OutputT>>> output, @UnknownKeyFor @NonNull @Initialized Lock bufferLock, @UnknownKeyFor @NonNull @Initialized OperatorStateBackend operatorStateBackend) throws @UnknownKeyFor @NonNull @Initialized Exception {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull(output);
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)bufferLock);
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)operatorStateBackend);
            TaggedKvCoder taggedKvCoder = this.buildTaggedKvCoder();
            ListStateDescriptor taggedOutputPushbackStateDescriptor = new ListStateDescriptor("bundle-buffer-tag", new CoderTypeSerializer(taggedKvCoder, this.pipelineOptions));
            ListState listStateBuffer = operatorStateBackend.getListState(taggedOutputPushbackStateDescriptor);
            NonKeyedPushedBackElementsHandler<KV<Integer, WindowedValue<?>>> pushedBackElementsHandler = NonKeyedPushedBackElementsHandler.create(listStateBuffer);
            return new BufferedOutputManager<OutputT>(output, this.mainTag, this.tagsToOutputTags, this.tagsToIds, bufferLock, pushedBackElementsHandler);
        }

        private @UnknownKeyFor @NonNull @Initialized TaggedKvCoder buildTaggedKvCoder() {
            ImmutableMap.Builder idsToCodersBuilder = ImmutableMap.builder();
            for (Map.Entry<TupleTag<?>, Integer> entry : this.tagsToIds.entrySet()) {
                idsToCodersBuilder.put((Object)entry.getValue(), this.tagsToCoders.get(entry.getKey()));
            }
            return new TaggedKvCoder((Map<Integer, Coder<WindowedValue<?>>>)idsToCodersBuilder.build());
        }
    }

    private static class TaggedKvCoder
    extends StructuredCoder<KV<Integer, WindowedValue<?>>> {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> idsToCoders;

        TaggedKvCoder(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> idsToCoders) {
            this.idsToCoders = idsToCoders;
        }

        public void encode(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> kv, @UnknownKeyFor @NonNull @Initialized OutputStream out) throws @UnknownKeyFor @NonNull @Initialized IOException {
            Coder<WindowedValue<?>> coder = this.idsToCoders.get(kv.getKey());
            VarIntCoder.of().encode((Integer)kv.getKey(), out);
            coder.encode((Object)((WindowedValue)kv.getValue()), out);
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> decode(@UnknownKeyFor @NonNull @Initialized InputStream in) throws @UnknownKeyFor @NonNull @Initialized IOException {
            Integer id = VarIntCoder.of().decode(in);
            Coder<WindowedValue<?>> coder = this.idsToCoders.get(id);
            WindowedValue value = (WindowedValue)coder.decode(in);
            return KV.of((Object)id, (Object)value);
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return new ArrayList(this.idsToCoders.values());
        }

        public void verifyDeterministic() throws // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
            for (Coder<WindowedValue<?>> coder : this.idsToCoders.values()) {
                TaggedKvCoder.verifyDeterministic((Coder)this, (String)"Coder must be deterministic", (Coder[])new Coder[]{coder});
            }
        }
    }

    public static class BufferedOutputManager<@UnknownKeyFor OutputT>
    implements DoFnRunners.OutputManager {
        private final @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> mainTag;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized OutputTag<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> tagsToOutputTags;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Integer> tagsToIds;
        private final @UnknownKeyFor @NonNull @Initialized Lock bufferLock;
        private /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> idsToTags;
        @VisibleForTesting
        final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PushedBackElementsHandler<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> pushedBackElementsHandler;
        protected final @UnknownKeyFor @NonNull @Initialized Output<@UnknownKeyFor @NonNull @Initialized StreamRecord<@UnknownKeyFor @NonNull @Initialized WindowedValue<OutputT>>> output;
        private @UnknownKeyFor @NonNull @Initialized boolean openBuffer = false;
        private @UnknownKeyFor @NonNull @Initialized boolean bufferIsEmpty = false;

        BufferedOutputManager(@UnknownKeyFor @NonNull @Initialized Output<@UnknownKeyFor @NonNull @Initialized StreamRecord<@UnknownKeyFor @NonNull @Initialized WindowedValue<OutputT>>> output, @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> mainTag, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized OutputTag<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> tagsToOutputTags, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Integer> tagsToIds, @UnknownKeyFor @NonNull @Initialized Lock bufferLock, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PushedBackElementsHandler<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> pushedBackElementsHandler) {
            this.output = output;
            this.mainTag = mainTag;
            this.tagsToOutputTags = tagsToOutputTags;
            this.tagsToIds = tagsToIds;
            this.bufferLock = bufferLock;
            this.idsToTags = new HashMap();
            for (Map.Entry<TupleTag<?>, Integer> entry : tagsToIds.entrySet()) {
                this.idsToTags.put(entry.getValue(), entry.getKey());
            }
            this.pushedBackElementsHandler = pushedBackElementsHandler;
        }

        void openBuffer() {
            this.openBuffer = true;
        }

        void closeBuffer() {
            this.openBuffer = false;
        }

        public <T> void output(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag, @UnknownKeyFor @NonNull @Initialized WindowedValue<T> value) {
            if (!this.openBuffer) {
                this.emit(tag, value);
            } else {
                this.buffer(KV.of((Object)this.tagsToIds.get(tag), value));
            }
        }

        private void buffer(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> taggedValue) {
            this.bufferLock.lock();
            try {
                this.pushedBackElementsHandler.pushBack(taggedValue);
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't pushback element.", e);
            }
            finally {
                this.bufferLock.unlock();
                this.bufferIsEmpty = false;
            }
        }

        void flushBuffer() {
            if (this.openBuffer || this.bufferIsEmpty) {
                return;
            }
            try {
                this.pushedBackElementsHandler.getElements().forEach(element -> this.emit(this.idsToTags.get(element.getKey()), (WindowedValue)element.getValue()));
                this.pushedBackElementsHandler.clear();
                this.bufferIsEmpty = true;
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't flush pushed back elements.", e);
            }
        }

        private <T> void emit(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag, @UnknownKeyFor @NonNull @Initialized WindowedValue<T> value) {
            if (tag.equals(this.mainTag)) {
                WindowedValue<T> castValue = value;
                this.output.collect((Object)new StreamRecord(castValue));
            } else {
                OutputTag<WindowedValue<?>> outputTag = this.tagsToOutputTags.get(tag);
                this.output.collect(outputTag, new StreamRecord(value));
            }
        }
    }

    static interface OutputManagerFactory<@UnknownKeyFor OutputT>
    extends Serializable {
        public @UnknownKeyFor @NonNull @Initialized BufferedOutputManager<OutputT> create(@UnknownKeyFor @NonNull @Initialized Output<@UnknownKeyFor @NonNull @Initialized StreamRecord<@UnknownKeyFor @NonNull @Initialized WindowedValue<OutputT>>> var1, @UnknownKeyFor @NonNull @Initialized Lock var2, @UnknownKeyFor @NonNull @Initialized OperatorStateBackend var3) throws @UnknownKeyFor @NonNull @Initialized Exception;
    }
}

