/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.validator;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.pipeline.transform.TransformMeta;

public class Validation
implements Cloneable {
    public static final String XML_TAG = "validator_field";
    public static final String XML_TAG_ALLOWED = "allowed_value";
    @HopMetadataProperty(key="validation_name", injectionKey="NAME", injectionKeyDescription="Validator.Injection.NAME")
    private String name;
    @HopMetadataProperty(key="name", injectionKey="FIELD_NAME", injectionKeyDescription="Validator.Injection.FIELD_NAME")
    private String fieldName;
    @HopMetadataProperty(key="max_length", injectionKey="MAX_LENGTH", injectionKeyDescription="Validator.Injection.MAX_LENGTH")
    private String maximumLength;
    @HopMetadataProperty(key="min_length", injectionKey="MIN_LENGTH", injectionKeyDescription="Validator.Injection.MIN_LENGTH")
    private String minimumLength;
    @HopMetadataProperty(key="null_allowed", injectionKey="NULL_ALLOWED", injectionKeyDescription="Validator.Injection.NULL_ALLOWED")
    private boolean nullAllowed;
    @HopMetadataProperty(key="only_null_allowed", injectionKey="ONLY_NULL_ALLOWED", injectionKeyDescription="Validator.Injection.ONLY_NULL_ALLOWED")
    private boolean onlyNullAllowed;
    @HopMetadataProperty(key="only_numeric_allowed", injectionKey="ONLY_NUMERIC_ALLOWED", injectionKeyDescription="Validator.Injection.ONLY_NUMERIC_ALLOWED")
    private boolean onlyNumericAllowed;
    @HopMetadataProperty(key="data_type", injectionKey="DATA_TYPE", injectionKeyDescription="Validator.Injection.DATA_TYPE")
    private String dataType;
    @HopMetadataProperty(key="data_type_verified", injectionKey="DATA_TYPE_VERIFIED", injectionKeyDescription="Validator.Injection.DATA_TYPE_VERIFIED")
    private boolean dataTypeVerified;
    @HopMetadataProperty(key="conversion_mask", injectionKey="CONVERSION_MASK", injectionKeyDescription="Validator.Injection.CONVERSION_MASK")
    private String conversionMask;
    @HopMetadataProperty(key="decimal_symbol", injectionKey="DECIMAL_SYMBOL", injectionKeyDescription="Validator.Injection.DECIMAL_SYMBOL")
    private String decimalSymbol;
    @HopMetadataProperty(key="grouping_symbol", injectionKey="GROUPING_SYMBOL", injectionKeyDescription="Validator.Injection.GROUPING_SYMBOL")
    private String groupingSymbol;
    @HopMetadataProperty(key="is_sourcing_values", injectionKey="SOURCING_VALUES", injectionKeyDescription="Validator.Injection.SOURCING_VALUES")
    private boolean sourcingValues;
    @HopMetadataProperty(key="sourcing_transform", injectionKey="SOURCING_TRANSFORM_NAME", injectionKeyDescription="Validator.Injection.SOURCING_TRANSFORM_NAME")
    private String sourcingTransformName;
    @HopMetadataProperty(key="sourcing_field", injectionKey="SOURCING_FIELD", injectionKeyDescription="Validator.Injection.SOURCING_FIELD")
    private String sourcingField;
    @HopMetadataProperty(key="min_value", injectionKey="MIN_VALUE", injectionKeyDescription="Validator.Injection.MIN_VALUE")
    private String minimumValue;
    @HopMetadataProperty(key="max_value", injectionKey="MAX_VALUE", injectionKeyDescription="Validator.Injection.MAX_VALUE")
    private String maximumValue;
    @HopMetadataProperty(key="start_string", injectionKey="START_STRING", injectionKeyDescription="Validator.Injection.START_STRING")
    private String startString;
    @HopMetadataProperty(key="start_string_not_allowed", injectionKey="START_STRING_NOT_ALLOWED", injectionKeyDescription="Validator.Injection.START_STRING_NOT_ALLOWED")
    private String startStringNotAllowed;
    @HopMetadataProperty(key="end_string", injectionKey="END_STRING", injectionKeyDescription="Validator.Injection.END_STRING")
    private String endString;
    @HopMetadataProperty(key="end_string_not_allowed", injectionKey="END_STRING_NOT_ALLOWED", injectionKeyDescription="Validator.Injection.END_STRING_NOT_ALLOWED")
    private String endStringNotAllowed;
    @HopMetadataProperty(key="regular_expression", injectionKey="REGULAR_EXPRESSION_EXPECTED", injectionKeyDescription="Validator.Injection.REGULAR_EXPRESSION_EXPECTED")
    private String regularExpression;
    @HopMetadataProperty(key="regular_expression_not_allowed", injectionKey="REGULAR_EXPRESSION_NOT_ALLOWED", injectionKeyDescription="Validator.Injection.REGULAR_EXPRESSION_NOT_ALLOWED")
    private String regularExpressionNotAllowed;
    @HopMetadataProperty(key="error_code", injectionKey="ERROR_CODE", injectionKeyDescription="Validator.Injection.ERROR_CODE")
    private String errorCode;
    @HopMetadataProperty(key="error_description", injectionKey="ERROR_CODE_DESCRIPTION", injectionKeyDescription="Validator.Injection.ERROR_CODE_DESCRIPTION")
    private String errorDescription;
    @HopMetadataProperty(groupKey="allowed_value", key="value")
    private List<String> allowedValues;
    private TransformMeta sourcingTransform;

    public Validation() {
        this.maximumLength = "";
        this.minimumLength = "";
        this.nullAllowed = true;
        this.onlyNullAllowed = false;
        this.onlyNumericAllowed = false;
        this.allowedValues = new ArrayList<String>();
    }

    public Validation(Validation v) {
        this.name = v.name;
        this.fieldName = v.fieldName;
        this.maximumLength = v.maximumLength;
        this.minimumLength = v.minimumLength;
        this.nullAllowed = v.nullAllowed;
        this.onlyNullAllowed = v.onlyNullAllowed;
        this.onlyNumericAllowed = v.onlyNumericAllowed;
        this.dataType = v.dataType;
        this.dataTypeVerified = v.dataTypeVerified;
        this.conversionMask = v.conversionMask;
        this.decimalSymbol = v.decimalSymbol;
        this.groupingSymbol = v.groupingSymbol;
        this.sourcingValues = v.sourcingValues;
        this.sourcingTransformName = v.sourcingTransformName;
        this.sourcingField = v.sourcingField;
        this.minimumValue = v.minimumValue;
        this.maximumValue = v.maximumValue;
        this.startString = v.startString;
        this.startStringNotAllowed = v.startStringNotAllowed;
        this.endString = v.endString;
        this.endStringNotAllowed = v.endStringNotAllowed;
        this.regularExpression = v.regularExpression;
        this.regularExpressionNotAllowed = v.regularExpressionNotAllowed;
        this.errorCode = v.errorCode;
        this.errorDescription = v.errorDescription;
        this.allowedValues = new ArrayList<String>(v.allowedValues);
        this.sourcingTransform = v.sourcingTransform;
    }

    public Validation(String name) {
        this();
        this.fieldName = name;
    }

    public Validation clone() {
        return new Validation(this);
    }

    public boolean equals(Validation validation) {
        return validation.getName().equalsIgnoreCase(this.name);
    }

    public static Validation findValidation(List<Validation> validations, String name) {
        for (Validation validation : validations) {
            if (!validation.getName().equalsIgnoreCase(name)) continue;
            return validation;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getMaximumLength() {
        return this.maximumLength;
    }

    public void setMaximumLength(String maximumLength) {
        this.maximumLength = maximumLength;
    }

    public String getMinimumLength() {
        return this.minimumLength;
    }

    public void setMinimumLength(String minimumLength) {
        this.minimumLength = minimumLength;
    }

    public boolean isNullAllowed() {
        return this.nullAllowed;
    }

    public void setNullAllowed(boolean nullAllowed) {
        this.nullAllowed = nullAllowed;
    }

    public boolean isOnlyNullAllowed() {
        return this.onlyNullAllowed;
    }

    public void setOnlyNullAllowed(boolean onlyNullAllowed) {
        this.onlyNullAllowed = onlyNullAllowed;
    }

    public boolean isOnlyNumericAllowed() {
        return this.onlyNumericAllowed;
    }

    public void setOnlyNumericAllowed(boolean onlyNumericAllowed) {
        this.onlyNumericAllowed = onlyNumericAllowed;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public boolean isDataTypeVerified() {
        return this.dataTypeVerified;
    }

    public void setDataTypeVerified(boolean dataTypeVerified) {
        this.dataTypeVerified = dataTypeVerified;
    }

    public String getConversionMask() {
        return this.conversionMask;
    }

    public void setConversionMask(String conversionMask) {
        this.conversionMask = conversionMask;
    }

    public String getDecimalSymbol() {
        return this.decimalSymbol;
    }

    public void setDecimalSymbol(String decimalSymbol) {
        this.decimalSymbol = decimalSymbol;
    }

    public String getGroupingSymbol() {
        return this.groupingSymbol;
    }

    public void setGroupingSymbol(String groupingSymbol) {
        this.groupingSymbol = groupingSymbol;
    }

    public boolean isSourcingValues() {
        return this.sourcingValues;
    }

    public void setSourcingValues(boolean sourcingValues) {
        this.sourcingValues = sourcingValues;
    }

    public String getSourcingTransformName() {
        return this.sourcingTransformName;
    }

    public void setSourcingTransformName(String sourcingTransformName) {
        this.sourcingTransformName = sourcingTransformName;
    }

    public String getSourcingField() {
        return this.sourcingField;
    }

    public void setSourcingField(String sourcingField) {
        this.sourcingField = sourcingField;
    }

    public String getMinimumValue() {
        return this.minimumValue;
    }

    public void setMinimumValue(String minimumValue) {
        this.minimumValue = minimumValue;
    }

    public String getMaximumValue() {
        return this.maximumValue;
    }

    public void setMaximumValue(String maximumValue) {
        this.maximumValue = maximumValue;
    }

    public String getStartString() {
        return this.startString;
    }

    public void setStartString(String startString) {
        this.startString = startString;
    }

    public String getStartStringNotAllowed() {
        return this.startStringNotAllowed;
    }

    public void setStartStringNotAllowed(String startStringNotAllowed) {
        this.startStringNotAllowed = startStringNotAllowed;
    }

    public String getEndString() {
        return this.endString;
    }

    public void setEndString(String endString) {
        this.endString = endString;
    }

    public String getEndStringNotAllowed() {
        return this.endStringNotAllowed;
    }

    public void setEndStringNotAllowed(String endStringNotAllowed) {
        this.endStringNotAllowed = endStringNotAllowed;
    }

    public String getRegularExpression() {
        return this.regularExpression;
    }

    public void setRegularExpression(String regularExpression) {
        this.regularExpression = regularExpression;
    }

    public String getRegularExpressionNotAllowed() {
        return this.regularExpressionNotAllowed;
    }

    public void setRegularExpressionNotAllowed(String regularExpressionNotAllowed) {
        this.regularExpressionNotAllowed = regularExpressionNotAllowed;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public List<String> getAllowedValues() {
        return this.allowedValues;
    }

    public void setAllowedValues(List<String> allowedValues) {
        this.allowedValues = allowedValues;
    }

    public TransformMeta getSourcingTransform() {
        return this.sourcingTransform;
    }

    public void setSourcingTransform(TransformMeta sourcingTransform) {
        this.sourcingTransform = sourcingTransform;
    }
}

