/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security.token;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.hadoop.HadoopDependency;
import org.apache.flink.runtime.security.token.DelegationTokenManager;
import org.apache.flink.runtime.security.token.KerberosDelegationTokenManager;
import org.apache.flink.runtime.security.token.KerberosLoginProvider;
import org.apache.flink.runtime.security.token.NoOpDelegationTokenManager;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosDelegationTokenManagerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosDelegationTokenManagerFactory.class);

    public static DelegationTokenManager create(ClassLoader classLoader, Configuration configuration, @Nullable ScheduledExecutor scheduledExecutor, @Nullable ExecutorService ioExecutor) throws IOException {
        if (configuration.getBoolean(SecurityOptions.KERBEROS_FETCH_DELEGATION_TOKEN)) {
            if (HadoopDependency.isHadoopCommonOnClasspath(classLoader)) {
                KerberosLoginProvider kerberosLoginProvider = new KerberosLoginProvider(configuration);
                if (kerberosLoginProvider.isLoginPossible()) {
                    return new KerberosDelegationTokenManager(configuration, scheduledExecutor, ioExecutor);
                }
                LOG.info("Cannot use kerberos delegation token manager no valid kerberos credentials provided.");
                return new NoOpDelegationTokenManager();
            }
            LOG.info("Cannot use kerberos delegation token manager because Hadoop cannot be found in the Classpath.");
            return new NoOpDelegationTokenManager();
        }
        return new NoOpDelegationTokenManager();
    }
}

