/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

public final class FluentBackoff {
    private static final @UnknownKeyFor @NonNull @Initialized double DEFAULT_EXPONENT = 1.5;
    private static final @UnknownKeyFor @NonNull @Initialized double DEFAULT_RANDOMIZATION_FACTOR = 0.5;
    private static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_MIN_BACKOFF = Duration.standardSeconds((long)1L);
    private static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_MAX_BACKOFF = Duration.standardDays((long)1000L);
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_MAX_RETRIES = Integer.MAX_VALUE;
    private static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_MAX_CUM_BACKOFF = Duration.standardDays((long)1000L);
    private final @UnknownKeyFor @NonNull @Initialized double exponent;
    private final @UnknownKeyFor @NonNull @Initialized Duration initialBackoff;
    private final @UnknownKeyFor @NonNull @Initialized Duration maxBackoff;
    private final @UnknownKeyFor @NonNull @Initialized Duration maxCumulativeBackoff;
    private final @UnknownKeyFor @NonNull @Initialized int maxRetries;
    public static final @UnknownKeyFor @NonNull @Initialized FluentBackoff DEFAULT = new FluentBackoff(1.5, DEFAULT_MIN_BACKOFF, DEFAULT_MAX_BACKOFF, DEFAULT_MAX_CUM_BACKOFF, Integer.MAX_VALUE);

    public @UnknownKeyFor @NonNull @Initialized BackOff backoff() {
        return new BackoffImpl(this);
    }

    public @UnknownKeyFor @NonNull @Initialized FluentBackoff withExponent(@UnknownKeyFor @NonNull @Initialized double exponent) {
        Preconditions.checkArgument((exponent > 0.0 ? 1 : 0) != 0, (String)"exponent %s must be greater than 0", (Object)exponent);
        return new FluentBackoff(exponent, this.initialBackoff, this.maxBackoff, this.maxCumulativeBackoff, this.maxRetries);
    }

    public @UnknownKeyFor @NonNull @Initialized FluentBackoff withInitialBackoff(@UnknownKeyFor @NonNull @Initialized Duration initialBackoff) {
        Preconditions.checkArgument((boolean)initialBackoff.isLongerThan((ReadableDuration)Duration.ZERO), (String)"initialBackoff %s must be at least 1 millisecond", (Object)initialBackoff);
        return new FluentBackoff(this.exponent, initialBackoff, this.maxBackoff, this.maxCumulativeBackoff, this.maxRetries);
    }

    public @UnknownKeyFor @NonNull @Initialized FluentBackoff withMaxBackoff(@UnknownKeyFor @NonNull @Initialized Duration maxBackoff) {
        Preconditions.checkArgument((maxBackoff.getMillis() > 0L ? 1 : 0) != 0, (String)"maxBackoff %s must be at least 1 millisecond", (Object)maxBackoff);
        return new FluentBackoff(this.exponent, this.initialBackoff, maxBackoff, this.maxCumulativeBackoff, this.maxRetries);
    }

    public @UnknownKeyFor @NonNull @Initialized FluentBackoff withMaxCumulativeBackoff(@UnknownKeyFor @NonNull @Initialized Duration maxCumulativeBackoff) {
        Preconditions.checkArgument((boolean)maxCumulativeBackoff.isLongerThan((ReadableDuration)Duration.ZERO), (String)"maxCumulativeBackoff %s must be at least 1 millisecond", (Object)maxCumulativeBackoff);
        return new FluentBackoff(this.exponent, this.initialBackoff, this.maxBackoff, maxCumulativeBackoff, this.maxRetries);
    }

    public @UnknownKeyFor @NonNull @Initialized FluentBackoff withMaxRetries(@UnknownKeyFor @NonNull @Initialized int maxRetries) {
        Preconditions.checkArgument((maxRetries >= 0 ? 1 : 0) != 0, (String)"maxRetries %s cannot be negative", (int)maxRetries);
        return new FluentBackoff(this.exponent, this.initialBackoff, this.maxBackoff, this.maxCumulativeBackoff, maxRetries);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return MoreObjects.toStringHelper(FluentBackoff.class).add("exponent", this.exponent).add("initialBackoff", (Object)this.initialBackoff).add("maxBackoff", (Object)this.maxBackoff).add("maxRetries", this.maxRetries).add("maxCumulativeBackoff", (Object)this.maxCumulativeBackoff).toString();
    }

    private FluentBackoff(@UnknownKeyFor @NonNull @Initialized double exponent, @UnknownKeyFor @NonNull @Initialized Duration initialBackoff, @UnknownKeyFor @NonNull @Initialized Duration maxBackoff, @UnknownKeyFor @NonNull @Initialized Duration maxCumulativeBackoff, @UnknownKeyFor @NonNull @Initialized int maxRetries) {
        this.exponent = exponent;
        this.initialBackoff = initialBackoff;
        this.maxBackoff = maxBackoff;
        this.maxRetries = maxRetries;
        this.maxCumulativeBackoff = maxCumulativeBackoff;
    }

    private static class BackoffImpl
    implements BackOff {
        private final @UnknownKeyFor @NonNull @Initialized FluentBackoff backoffConfig;
        private @UnknownKeyFor @NonNull @Initialized Duration currentCumulativeBackoff;
        private @UnknownKeyFor @NonNull @Initialized int currentRetry;

        @Override
        public void reset() {
            this.currentRetry = 0;
            this.currentCumulativeBackoff = Duration.ZERO;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized long nextBackOffMillis() {
            if (this.currentRetry >= this.backoffConfig.maxRetries) {
                return -1L;
            }
            if (this.currentCumulativeBackoff.compareTo((ReadableDuration)this.backoffConfig.maxCumulativeBackoff) >= 0) {
                return -1L;
            }
            double currentIntervalMillis = Math.min((double)this.backoffConfig.initialBackoff.getMillis() * Math.pow(this.backoffConfig.exponent, this.currentRetry), (double)this.backoffConfig.maxBackoff.getMillis());
            double randomOffset = (Math.random() * 2.0 - 1.0) * 0.5 * currentIntervalMillis;
            long nextBackoffMillis = Math.round(currentIntervalMillis + randomOffset);
            Duration remainingCumulative = this.backoffConfig.maxCumulativeBackoff.minus((ReadableDuration)this.currentCumulativeBackoff);
            nextBackoffMillis = Math.min(nextBackoffMillis, remainingCumulative.getMillis());
            this.currentCumulativeBackoff = this.currentCumulativeBackoff.plus((ReadableDuration)Duration.millis((long)nextBackoffMillis));
            ++this.currentRetry;
            return nextBackoffMillis;
        }

        private BackoffImpl(@UnknownKeyFor @NonNull @Initialized FluentBackoff backoffConfig) {
            this.backoffConfig = backoffConfig;
            this.reset();
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(BackoffImpl.class).add("backoffConfig", (Object)this.backoffConfig).add("currentRetry", this.currentRetry).add("currentCumulativeBackoff", (Object)this.currentCumulativeBackoff).toString();
        }
    }
}

