/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.coders.RowCoderGenerator;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoderHelpers;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class SchemaCoder<@UnknownKeyFor T>
extends CustomCoder<T> {
    protected final @UnknownKeyFor @NonNull @Initialized Schema schema;
    private final @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor;
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> toRowFunction;
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, T> fromRowFunction;
    private transient @Nullable @UnknownKeyFor @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Row> delegateCoder;

    protected SchemaCoder(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> toRowFunction, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, T> fromRowFunction) {
        Preconditions.checkArgument((!typeDescriptor.hasUnresolvedParameters() ? 1 : 0) != 0, (String)"Cannot create SchemaCoder with a TypeDescriptor that has unresolved parameters: %s", typeDescriptor);
        if (schema.getUUID() == null) {
            schema = SerializableUtils.clone(schema);
            SchemaCoder.setSchemaIds(schema);
        }
        this.toRowFunction = toRowFunction;
        this.fromRowFunction = fromRowFunction;
        this.typeDescriptor = typeDescriptor;
        this.schema = schema;
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SchemaCoder<T> of(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> toRowFunction, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, T> fromRowFunction) {
        return new SchemaCoder<T>(schema, typeDescriptor, toRowFunction, fromRowFunction);
    }

    public static @UnknownKeyFor @NonNull @Initialized SchemaCoder<@UnknownKeyFor @NonNull @Initialized Row> of(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return RowCoder.of(schema);
    }

    public static void overrideEncodingPositions(@UnknownKeyFor @NonNull @Initialized UUID uuid, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> encodingPositions) {
        RowCoderGenerator.overrideEncodingPositions(uuid, encodingPositions);
    }

    public @UnknownKeyFor @NonNull @Initialized Schema getSchema() {
        return this.schema;
    }

    public @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, T> getFromRowFunction() {
        return this.fromRowFunction;
    }

    public @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> getToRowFunction() {
        return this.toRowFunction;
    }

    private @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Row> getDelegateCoder() {
        if (this.delegateCoder == null) {
            this.delegateCoder = RowCoderGenerator.generate(this.schema);
        }
        return this.delegateCoder;
    }

    @Override
    public void encode(T value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.getDelegateCoder().encode(this.toRowFunction.apply(value), outStream);
    }

    @Override
    public T decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.fromRowFunction.apply(this.getDelegateCoder().decode(inStream));
    }

    @Override
    public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        this.verifyDeterministic(this.schema);
    }

    private void verifyDeterministic(@UnknownKeyFor @NonNull @Initialized Schema schema) throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        ImmutableList coders = (ImmutableList)schema.getFields().stream().map(Schema.Field::getType).map(SchemaCoderHelpers::coderForFieldType).collect(ImmutableList.toImmutableList());
        Coder.verifyDeterministic(this, "All fields must have deterministic encoding", coders);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
        return true;
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Coder<T> coderForFieldType(@UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        return SchemaCoderHelpers.coderForFieldType(fieldType);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "SchemaCoder<Schema: " + this.schema + "  UUID: " + this.schema.getUUID() + " delegateCoder: " + this.getDelegateCoder();
    }

    private static void setSchemaIds(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        if (schema.getUUID() == null) {
            schema.setUUID(UUID.randomUUID());
        }
        for (Schema.Field field : schema.getFields()) {
            SchemaCoder.setSchemaIds(field.getType());
        }
    }

    private static void setSchemaIds(@UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        switch (fieldType.getTypeName()) {
            case ROW: {
                SchemaCoder.setSchemaIds(fieldType.getRowSchema());
                return;
            }
            case MAP: {
                SchemaCoder.setSchemaIds(fieldType.getMapKeyType());
                SchemaCoder.setSchemaIds(fieldType.getMapValueType());
                return;
            }
            case LOGICAL_TYPE: {
                SchemaCoder.setSchemaIds(fieldType.getLogicalType().getBaseType());
                return;
            }
            case ARRAY: 
            case ITERABLE: {
                SchemaCoder.setSchemaIds(fieldType.getCollectionElementType());
                return;
            }
        }
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaCoder that = (SchemaCoder)o;
        return this.schema.equals(that.schema) && this.typeDescriptor.equals(that.typeDescriptor) && this.toRowFunction.equals(that.toRowFunction) && this.fromRowFunction.equals(that.fromRowFunction);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.schema, this.typeDescriptor, this.toRowFunction, this.fromRowFunction);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> getEncodedTypeDescriptor() {
        return this.typeDescriptor;
    }
}

