/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hop.core.Const;
import org.apache.hop.core.gui.plugin.GuiRegistry;
import org.apache.hop.core.gui.plugin.key.KeyboardShortcut;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiPipelineGraph;
import org.apache.hop.ui.hopgui.perspective.IHopPerspective;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Control;

public class HopGuiKeyHandler
extends KeyAdapter {
    private static HopGuiKeyHandler singleton;
    public Set<Object> parentObjects = new HashSet<Object>();
    private KeyboardShortcut lastShortcut;
    private long lastShortcutTime;

    private HopGuiKeyHandler() {
    }

    public static HopGuiKeyHandler getInstance() {
        if (singleton == null) {
            singleton = new HopGuiKeyHandler();
        }
        return singleton;
    }

    public void addParentObjectToHandle(Object parentObject) {
        this.parentObjects.add(parentObject);
    }

    public void removeParentObjectToHandle(Object parentObject) {
        this.parentObjects.remove(parentObject);
    }

    public void keyPressed(KeyEvent event) {
        for (Object parentObject : this.parentObjects) {
            List shortcuts = GuiRegistry.getInstance().getKeyboardShortcuts(parentObject.getClass().getName());
            if (shortcuts == null) continue;
            for (KeyboardShortcut shortcut : shortcuts) {
                if (!this.handleKey(parentObject, event, shortcut)) continue;
                event.doit = false;
                return;
            }
        }
    }

    private boolean handleKey(Object parentObject, KeyEvent event, KeyboardShortcut shortcut) {
        boolean commandMatch;
        boolean matchOS;
        if (parentObject instanceof Control) {
            Control control = (Control)parentObject;
            try {
                if (!control.isVisible()) {
                    return false;
                }
            }
            catch (SWTException e) {
                return false;
            }
        }
        if (parentObject instanceof IHopPerspective) {
            IHopPerspective perspective = (IHopPerspective)parentObject;
            try {
                if (!perspective.isActive()) {
                    return false;
                }
            }
            catch (Exception ex) {
                return false;
            }
        }
        if (parentObject instanceof HopGuiPipelineGraph) {
            HopGuiPipelineGraph graph = (HopGuiPipelineGraph)parentObject;
            try {
                if (!graph.isVisible()) {
                    return false;
                }
            }
            catch (SWTException e) {
                return false;
            }
        }
        int keyCode = event.keyCode & 0x100FFFF;
        boolean alt = (event.stateMask & 0x10000) != 0;
        boolean shift = (event.stateMask & 0x20000) != 0;
        boolean control = (event.stateMask & 0x40000) != 0;
        boolean command = (event.stateMask & 0x400000) != 0;
        boolean bl = matchOS = Const.isOSX() == shortcut.isOsx();
        if (keyCode == 16777259) {
            keyCode = 43;
        } else if (keyCode == 16777261) {
            keyCode = 45;
        } else if (keyCode == 16777258) {
            keyCode = 42;
        } else if (keyCode == 16777263) {
            keyCode = 47;
        } else if (keyCode == 16777277) {
            keyCode = 61;
        }
        boolean keyMatch = keyCode == shortcut.getKeyCode();
        boolean altMatch = shortcut.isAlt() == alt;
        boolean shiftMatch = shortcut.isShift() == shift;
        boolean controlMatch = shortcut.isControl() == control;
        boolean bl2 = commandMatch = shortcut.isCommand() == command;
        if (matchOS && keyMatch && altMatch && shiftMatch && controlMatch && commandMatch) {
            try {
                Class<?> parentClass = parentObject.getClass();
                Method method = parentClass.getMethod(shortcut.getParentMethodName(), new Class[0]);
                if (method != null) {
                    method.invoke(parentObject, new Object[0]);
                    return true;
                }
            }
            catch (Exception ex) {
                LogChannel.UI.logError("Error calling keyboard shortcut method on parent object " + parentObject.toString(), (Throwable)ex);
            }
        }
        return false;
    }
}

