/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.data;

import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.sdk.fn.data.CloseableFnDataReceiver;
import org.apache.beam.sdk.fn.stream.OutboundObserverFactory;
import org.apache.beam.vendor.grpc.v1p54p0.io.grpc.Status;
import org.apache.beam.vendor.grpc.v1p54p0.io.grpc.stub.StreamObserver;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamFnDataGrpcMultiplexer
implements AutoCloseable {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BeamFnDataGrpcMultiplexer.class);
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable @UnknownKeyFor @Initialized Endpoints.ApiServiceDescriptor apiServiceDescriptor;
    private final @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.Elements> inboundObserver;
    private final @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.Elements> outboundObserver;
    private final @UnknownKeyFor @NonNull @Initialized ConcurrentMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized CloseableFnDataReceiver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.Elements>>> receivers;
    private final @UnknownKeyFor @NonNull @Initialized ConcurrentMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Boolean> erroredInstructionIds;

    public BeamFnDataGrpcMultiplexer(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable @UnknownKeyFor @Initialized Endpoints.ApiServiceDescriptor apiServiceDescriptor, @UnknownKeyFor @NonNull @Initialized OutboundObserverFactory outboundObserverFactory, @UnknownKeyFor @NonNull @Initialized OutboundObserverFactory.BasicFactory<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.Elements, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.Elements> baseOutboundObserverFactory) {
        this.apiServiceDescriptor = apiServiceDescriptor;
        this.receivers = new ConcurrentHashMap<String, CompletableFuture<CloseableFnDataReceiver<BeamFnApi.Elements>>>();
        this.erroredInstructionIds = new ConcurrentHashMap<String, Boolean>();
        this.inboundObserver = new InboundObserver();
        this.outboundObserver = outboundObserverFactory.outboundObserverFor(baseOutboundObserverFactory, this.inboundObserver);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("apiServiceDescriptor", (Object)this.apiServiceDescriptor).add("consumers", this.receivers).toString();
    }

    public @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.Elements> getInboundObserver() {
        return this.inboundObserver;
    }

    public @UnknownKeyFor @NonNull @Initialized StreamObserver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.Elements> getOutboundObserver() {
        return this.outboundObserver;
    }

    private @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized CloseableFnDataReceiver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.Elements>> receiverFuture(@UnknownKeyFor @NonNull @Initialized String instructionId) {
        return this.receivers.computeIfAbsent(instructionId, unused -> new CompletableFuture());
    }

    public void registerConsumer(@UnknownKeyFor @NonNull @Initialized String instructionId, @UnknownKeyFor @NonNull @Initialized CloseableFnDataReceiver<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized BeamFnApi.Elements> receiver) {
        this.receiverFuture(instructionId).complete(receiver);
    }

    public void unregisterConsumer(@UnknownKeyFor @NonNull @Initialized String instructionId) {
        this.receivers.remove(instructionId);
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized boolean hasConsumer(@UnknownKeyFor @NonNull @Initialized String instructionId) {
        return this.receivers.containsKey(instructionId);
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
        Exception exception = null;
        for (CompletableFuture receiver : ImmutableList.copyOf(this.receivers.values())) {
            receiver.cancel(true);
            if (receiver.isCompletedExceptionally()) continue;
            try {
                ((CloseableFnDataReceiver)receiver.get()).close();
            }
            catch (Exception e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        this.outboundObserver.onError((Throwable)Status.CANCELLED.withDescription("Multiplexer hanging up").asException());
        this.inboundObserver.onCompleted();
        if (exception != null) {
            throw exception;
        }
    }

    private final class InboundObserver
    implements StreamObserver<BeamFnApi.Elements> {
        private InboundObserver() {
        }

        public void onNext(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.Elements value) {
            block10: {
                String instructionId = null;
                for (BeamFnApi.Elements.Data data : value.getDataList()) {
                    if (instructionId == null) {
                        instructionId = data.getInstructionId();
                        continue;
                    }
                    if (instructionId.equals(data.getInstructionId())) continue;
                    break block10;
                }
                for (BeamFnApi.Elements.Timers timers : value.getTimersList()) {
                    if (instructionId == null) {
                        instructionId = timers.getInstructionId();
                        continue;
                    }
                    if (instructionId.equals(timers.getInstructionId())) continue;
                    break block10;
                }
                if (instructionId == null) {
                    return;
                }
                this.forwardToConsumerForInstructionId(instructionId, value);
                return;
            }
            HashSet<String> instructionIds = new HashSet<String>();
            for (BeamFnApi.Elements.Data data : value.getDataList()) {
                instructionIds.add(data.getInstructionId());
            }
            for (BeamFnApi.Elements.Timers timers : value.getTimersList()) {
                instructionIds.add(timers.getInstructionId());
            }
            for (String instructionId : instructionIds) {
                BeamFnApi.Elements.Builder builder = BeamFnApi.Elements.newBuilder();
                for (BeamFnApi.Elements.Data data : value.getDataList()) {
                    if (!instructionId.equals(data.getInstructionId())) continue;
                    builder.addData(data);
                }
                for (BeamFnApi.Elements.Timers timers : value.getTimersList()) {
                    if (!instructionId.equals(timers.getInstructionId())) continue;
                    builder.addTimers(timers);
                }
                this.forwardToConsumerForInstructionId(instructionId, builder.build());
            }
        }

        private void forwardToConsumerForInstructionId(@UnknownKeyFor @NonNull @Initialized String instructionId, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BeamFnApi.Elements value) {
            CloseableFnDataReceiver consumer;
            if (BeamFnDataGrpcMultiplexer.this.erroredInstructionIds.containsKey(instructionId)) {
                LOG.debug("Ignoring inbound data for failed instruction {}", (Object)instructionId);
                return;
            }
            CompletableFuture consumerFuture = BeamFnDataGrpcMultiplexer.this.receiverFuture(instructionId);
            if (!consumerFuture.isDone()) {
                LOG.debug("Received data for instruction {} without consumer ready. Waiting for consumer to be registered.", (Object)instructionId);
            }
            try {
                consumer = (CloseableFnDataReceiver)consumerFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("Client interrupted during handling of data for instruction {}", (Object)instructionId, (Object)e);
                BeamFnDataGrpcMultiplexer.this.outboundObserver.onError((Throwable)e);
                return;
            }
            catch (RuntimeException e) {
                LOG.error("Client failed to handle data for instruction {}", (Object)instructionId, (Object)e);
                BeamFnDataGrpcMultiplexer.this.outboundObserver.onError((Throwable)e);
                return;
            }
            try {
                consumer.accept(value);
            }
            catch (Exception e) {
                BeamFnDataGrpcMultiplexer.this.erroredInstructionIds.put(instructionId, true);
            }
        }

        public void onError(@UnknownKeyFor @NonNull @Initialized Throwable t) {
            LOG.error("Failed to handle for {}", (Object)(BeamFnDataGrpcMultiplexer.this.apiServiceDescriptor == null ? "unknown endpoint" : BeamFnDataGrpcMultiplexer.this.apiServiceDescriptor), (Object)t);
        }

        public void onCompleted() {
            LOG.warn("Hanged up for {}.", (Object)(BeamFnDataGrpcMultiplexer.this.apiServiceDescriptor == null ? "unknown endpoint" : BeamFnDataGrpcMultiplexer.this.apiServiceDescriptor));
        }
    }
}

