/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Servlet;
import org.apache.hop.core.Const;
import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.plugins.HopServerPluginType;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.server.HopServer;
import org.apache.hop.www.DefaultWebServerShutdownHandler;
import org.apache.hop.www.GetRootServlet;
import org.apache.hop.www.IHopServerPlugin;
import org.apache.hop.www.IWebServerShutdownHandler;
import org.apache.hop.www.PipelineMap;
import org.apache.hop.www.SslConfiguration;
import org.apache.hop.www.WebServerShutdownHook;
import org.apache.hop.www.WorkflowMap;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.jaas.JAASLoginService;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.PropertyUserStore;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.ConnectionLimit;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.LowResourceMonitor;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.security.Password;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.glassfish.jersey.servlet.ServletContainer;

public class WebServer {
    public static final int PORT = 80;
    public static final int SHUTDOWN_PORT = 8079;
    private static final int DEFAULT_DETECTION_TIMER = 20000;
    private static final Class<?> PKG = WebServer.class;
    private ILogChannel log;
    private IVariables variables;
    private Server server;
    private PipelineMap pipelineMap;
    private WorkflowMap workflowMap;
    private String hostname;
    private int port;
    private int shutdownPort;
    private String passwordFile;
    private WebServerShutdownHook webServerShutdownHook;
    private IWebServerShutdownHandler webServerShutdownHandler = new DefaultWebServerShutdownHandler();
    private SslConfiguration sslConfig;

    public WebServer(ILogChannel log, PipelineMap pipelineMap, WorkflowMap workflowMap, String hostname, int port, int shutdownPort, boolean join, String passwordFile) throws Exception {
        this(log, pipelineMap, workflowMap, hostname, port, shutdownPort, join, passwordFile, null);
    }

    public WebServer(ILogChannel log, PipelineMap pipelineMap, WorkflowMap workflowMap, String hostname, int port, int shutdownPort, boolean join, String passwordFile, SslConfiguration sslConfig) throws Exception {
        this.log = log;
        this.pipelineMap = pipelineMap;
        this.workflowMap = workflowMap;
        this.variables = pipelineMap != null ? pipelineMap.getHopServerConfig().getVariables() : (workflowMap != null ? workflowMap.getHopServerConfig().getVariables() : Variables.getADefaultVariableSpace());
        this.hostname = hostname;
        this.port = port;
        this.shutdownPort = shutdownPort;
        this.passwordFile = passwordFile;
        this.sslConfig = sslConfig;
        this.startServer();
        this.webServerShutdownHook = new WebServerShutdownHook(this);
        Runtime.getRuntime().addShutdownHook(this.webServerShutdownHook);
        try {
            ExtensionPointHandler.callExtensionPoint((ILogChannel)log, (IVariables)this.variables, (String)HopExtensionPoint.HopServerStartup.id, (Object)this);
        }
        catch (HopException e) {
            log.logError("Error calling extension point HopServerStartup", (Throwable)e);
        }
        if (join) {
            this.server.join();
        }
    }

    public WebServer(ILogChannel log, PipelineMap pipelineMap, WorkflowMap workflowMap, String hostname, int port, int shutdownPort) throws Exception {
        this(log, pipelineMap, workflowMap, hostname, port, shutdownPort, true);
    }

    public WebServer(ILogChannel log, PipelineMap pipelineMap, WorkflowMap workflowMap, String hostname, int port, int shutdownPort, boolean join) throws Exception {
        this(log, pipelineMap, workflowMap, hostname, port, shutdownPort, join, null, null);
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public void startServer() throws Exception {
        this.server = new Server();
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("*");
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        if (System.getProperty("loginmodulename") != null && System.getProperty("java.security.auth.login.config") != null) {
            JAASLoginService jaasLoginService = new JAASLoginService("Hop");
            jaasLoginService.setLoginModuleName(System.getProperty("loginmodulename"));
            securityHandler.setLoginService((LoginService)jaasLoginService);
        } else {
            UserStore userStore;
            HashLoginService hashLoginService;
            roles.add("default");
            HopServer hopServer = this.pipelineMap.getHopServerConfig().getHopServer();
            if (!Utils.isEmpty((CharSequence)hopServer.getPassword())) {
                hashLoginService = new HashLoginService("Hop");
                userStore = new UserStore();
                userStore.addUser(hopServer.getUsername(), (Credential)new Password(hopServer.getPassword()), new String[]{"default"});
                hashLoginService.setUserStore(userStore);
            } else {
                if (Utils.isEmpty((CharSequence)this.passwordFile)) {
                    this.passwordFile = Const.getHopLocalServerPasswordFile();
                }
                hashLoginService = new HashLoginService("Hop");
                userStore = new PropertyUserStore();
                userStore.setConfig(this.passwordFile);
                hashLoginService.setUserStore(userStore);
            }
            securityHandler.setLoginService((LoginService)hashLoginService);
        }
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(roles.toArray(new String[roles.size()]));
        constraint.setAuthenticate(true);
        ConstraintMapping constraintMapping = new ConstraintMapping();
        constraintMapping.setConstraint(constraint);
        constraintMapping.setPathSpec("/*");
        securityHandler.setConstraintMappings(new ConstraintMapping[]{constraintMapping});
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/", 1);
        GetRootServlet rootServlet = new GetRootServlet();
        rootServlet.setJettyMode(true);
        root.addServlet(new ServletHolder((Servlet)rootServlet), "/*");
        boolean graphicsEnvironment = this.supportGraphicEnvironment();
        PluginRegistry pluginRegistry = PluginRegistry.getInstance();
        List plugins = pluginRegistry.getPlugins(HopServerPluginType.class);
        for (IPlugin plugin : plugins) {
            IHopServerPlugin servlet = (IHopServerPlugin)pluginRegistry.loadClass(plugin, IHopServerPlugin.class);
            servlet.setup(this.pipelineMap, this.workflowMap);
            servlet.setJettyMode(true);
            ServletContextHandler servletContext = new ServletContextHandler((HandlerContainer)contexts, this.getContextPath(servlet), 1);
            ServletHolder servletHolder = new ServletHolder((Servlet)servlet);
            servletContext.addServlet(servletHolder, "/*");
            servletContext.setAttribute("GraphicsEnvironment", (Object)graphicsEnvironment);
        }
        ServletHolder jerseyServletHolder = new ServletHolder(ServletContainer.class);
        jerseyServletHolder.setInitParameter("com.sun.jersey.config.property.resourceConfigClass", "com.sun.jersey.api.core.PackagesResourceConfig");
        jerseyServletHolder.setInitParameter("com.sun.jersey.config.property.packages", "org.apache.hop.www.jaxrs");
        root.addServlet(jerseyServletHolder, "/api/*");
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setResourceBase("temp");
        ServletHolder staticHolder = new ServletHolder("static", DefaultServlet.class);
        staticHolder.setInitParameter("resourceBase", "./static/");
        staticHolder.setInitParameter("dirAllowed", "true");
        staticHolder.setInitParameter("pathInfoOnly", "true");
        root.addServlet(staticHolder, "/static/*");
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{resourceHandler, contexts});
        securityHandler.setHandler((Handler)handlers);
        this.server.setHandler((Handler)securityHandler);
        this.createListeners();
        this.server.start();
    }

    public String getContextPath(IHopServerPlugin servlet) {
        String contextPath = servlet.getContextPath();
        return contextPath;
    }

    public void join() throws InterruptedException {
        this.server.join();
    }

    public void stopServer() {
        this.webServerShutdownHook.setShuttingDown(true);
        this.log.logBasic(BaseMessages.getString(PKG, (String)"WebServer.Log.ShuttingDown", (String[])new String[0]));
        try {
            ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this.variables, (String)HopExtensionPoint.HopServerShutdown.id, (Object)this);
        }
        catch (HopException e) {
            this.log.logError("Error calling extension point HopServerStartup", (Throwable)e);
        }
        try {
            if (this.server != null) {
                this.server.stop();
                HopEnvironment.shutdown();
                if (this.webServerShutdownHandler != null) {
                    this.webServerShutdownHandler.shutdownWebServer();
                }
            }
        }
        catch (Exception e) {
            this.log.logError(BaseMessages.getString(PKG, (String)"WebServer.Error.FailedToStop.Title", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"WebServer.Error.FailedToStop.Msg", (String[])new String[]{"" + e})});
        }
    }

    private void createListeners() {
        ServerConnector connector = this.getConnector();
        this.setupJettyOptions(connector);
        connector.setPort(this.port);
        connector.setHost(this.hostname);
        connector.setName(BaseMessages.getString(PKG, (String)"WebServer.Log.HopHTTPListener", (String[])new String[]{this.hostname}));
        this.log.logBasic(BaseMessages.getString(PKG, (String)"WebServer.Log.CreateListener", (String[])new String[]{this.hostname, "" + this.port}));
        this.server.setConnectors(new Connector[]{connector});
    }

    private ServerConnector getConnector() {
        if (this.sslConfig != null) {
            this.log.logBasic(BaseMessages.getString(PKG, (String)"WebServer.Log.SslModeUsing", (String[])new String[0]));
            HttpConfiguration httpConfig = new HttpConfiguration();
            httpConfig.setSecureScheme("https");
            httpConfig.setSecurePort(this.port);
            String keyStorePassword = Encr.decryptPasswordOptionallyEncrypted((String)this.sslConfig.getKeyStorePassword());
            String keyPassword = Encr.decryptPasswordOptionallyEncrypted((String)this.sslConfig.getKeyPassword());
            SslContextFactory.Client factory = new SslContextFactory.Client();
            factory.setKeyStoreResource((Resource)new PathResource(new File(this.sslConfig.getKeyStore())));
            factory.setKeyStorePassword(keyStorePassword);
            factory.setKeyManagerPassword(keyPassword);
            factory.setKeyStoreType(this.sslConfig.getKeyStoreType());
            factory.setTrustStoreResource((Resource)new PathResource(new File(this.sslConfig.getKeyStore())));
            factory.setTrustStorePassword(keyStorePassword);
            HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
            httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            ServerConnector sslConnector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory((SslContextFactory)factory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
            sslConnector.setPort(this.port);
            return sslConnector;
        }
        return new ServerConnector(this.server);
    }

    protected void setupJettyOptions(ServerConnector connector) {
        LowResourceMonitor lowResourceMonitor = new LowResourceMonitor(this.server);
        if (this.validProperty("HOP_SERVER_JETTY_ACCEPTORS")) {
            this.server.addBean((Object)new ConnectionLimit(Integer.parseInt(System.getProperty("HOP_SERVER_JETTY_ACCEPTORS")), new Connector[0]));
            this.log.logBasic(BaseMessages.getString(PKG, (String)"WebServer.Log.ConfigOptions", (Object[])new Object[]{"acceptors", connector.getAcceptors()}));
        }
        if (this.validProperty("HOP_SERVER_JETTY_ACCEPT_QUEUE_SIZE")) {
            connector.setAcceptQueueSize(Integer.parseInt(System.getProperty("HOP_SERVER_JETTY_ACCEPT_QUEUE_SIZE")));
            this.log.logBasic(BaseMessages.getString(PKG, (String)"WebServer.Log.ConfigOptions", (Object[])new Object[]{"acceptQueueSize", connector.getAcceptQueueSize()}));
        }
        if (this.validProperty("HOP_SERVER_JETTY_RES_MAX_IDLE_TIME")) {
            connector.setIdleTimeout((long)Integer.parseInt(System.getProperty("HOP_SERVER_JETTY_RES_MAX_IDLE_TIME")));
            this.log.logBasic(BaseMessages.getString(PKG, (String)"WebServer.Log.ConfigOptions", (Object[])new Object[]{"lowResourcesMaxIdleTime", connector.getIdleTimeout()}));
        }
    }

    private boolean validProperty(String property) {
        boolean isValid = false;
        if (System.getProperty(property) != null && System.getProperty(property).length() > 0) {
            try {
                Integer.parseInt(System.getProperty(property));
                isValid = true;
            }
            catch (NumberFormatException nmbfExc) {
                this.log.logBasic(BaseMessages.getString(PKG, (String)"WebServer.Log.ConfigOptionsInvalid", (String[])new String[]{property, System.getProperty(property)}));
            }
        }
        return isValid;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getPasswordFile() {
        return this.passwordFile;
    }

    public void setPasswordFile(String passwordFile) {
        this.passwordFile = passwordFile;
    }

    public ILogChannel getLog() {
        return this.log;
    }

    public void setLog(ILogChannel log) {
        this.log = log;
    }

    public PipelineMap getPipelineMap() {
        return this.pipelineMap;
    }

    public void setPipelineMap(PipelineMap pipelineMap) {
        this.pipelineMap = pipelineMap;
    }

    public WorkflowMap getWorkflowMap() {
        return this.workflowMap;
    }

    public void setWorkflowMap(WorkflowMap workflowMap) {
        this.workflowMap = workflowMap;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public IVariables getVariables() {
        return this.variables;
    }

    public void setVariables(IVariables variables) {
        this.variables = variables;
    }

    public void setWebServerShutdownHandler(IWebServerShutdownHandler webServerShutdownHandler) {
        this.webServerShutdownHandler = webServerShutdownHandler;
    }

    public int defaultDetectionTimer() {
        String sDetectionTimer = System.getProperty("HOP_SERVER_DETECTION_TIMER");
        if (sDetectionTimer != null) {
            return Integer.parseInt(sDetectionTimer);
        }
        return 20000;
    }

    private boolean supportGraphicEnvironment() {
        try {
            return GraphicsEnvironment.getLocalGraphicsEnvironment() != null;
        }
        catch (Error error) {
            return false;
        }
    }

    private static class MonitorThread
    extends Thread {
        private ServerSocket socket;
        private Server server;

        public MonitorThread(Server server, String hostname, int shutdownPort) {
            this.server = server;
            this.setDaemon(true);
            this.setName("StopMonitor");
            try {
                this.socket = new ServerSocket(shutdownPort, 1, InetAddress.getByName(hostname));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void run() {
            try {
                Socket accept = this.socket.accept();
                BufferedReader reader = new BufferedReader(new InputStreamReader(accept.getInputStream()));
                reader.readLine();
                this.server.stop();
                accept.close();
                this.socket.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

