/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.window;

import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.windowing.AfterWatermark;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.apache.beam.sdk.transforms.windowing.SlidingWindows;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PCollection;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.fn.WindowInfoFn;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.pipeline.IBeamPipelineTransformHandler;
import org.apache.hop.beam.transforms.window.BeamWindowDialog;
import org.apache.hop.beam.transforms.window.WindowTriggerType;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dummy.Dummy;
import org.apache.hop.pipeline.transforms.dummy.DummyData;
import org.joda.time.Duration;

@Transform(id="BeamWindow", name="Beam Window", description="Create a Beam Window", image="beam-window.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.BigData", keywords={"i18n::BeamWindowMeta.keyword"}, documentationUrl="/pipeline/transforms/beamwindow.html")
public class BeamWindowMeta
extends BaseTransformMeta<Dummy, DummyData>
implements IBeamPipelineTransformHandler {
    @HopMetadataProperty(key="window_type")
    private String windowType;
    @HopMetadataProperty
    private String duration;
    @HopMetadataProperty
    private String every;
    @HopMetadataProperty(key="max_window_field")
    private String maxWindowField;
    @HopMetadataProperty(key="start_window_field")
    private String startWindowField;
    @HopMetadataProperty(key="end_window_field")
    private String endWindowField;
    @HopMetadataProperty(key="allowed_lateness")
    private String allowedLateness;
    @HopMetadataProperty(key="discarding_fired_panes")
    private boolean discardingFiredPanes;
    @HopMetadataProperty(key="trigger_type")
    private WindowTriggerType triggeringType = WindowTriggerType.None;

    public void setDefault() {
        this.windowType = "Fixed";
        this.duration = "60";
        this.every = "";
        this.startWindowField = "startWindow";
        this.endWindowField = "endWindow";
        this.maxWindowField = "maxWindow";
        this.allowedLateness = "0";
        this.discardingFiredPanes = false;
        this.triggeringType = WindowTriggerType.None;
    }

    public String getDialogClassName() {
        return BeamWindowDialog.class.getName();
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        ValueMetaDate valueMeta;
        if (StringUtils.isNotEmpty((String)this.startWindowField)) {
            valueMeta = new ValueMetaDate(variables.resolve(this.startWindowField));
            valueMeta.setOrigin(name);
            valueMeta.setConversionMask(ValueMetaBase.DEFAULT_DATE_FORMAT_MASK);
            inputRowMeta.addValueMeta((IValueMeta)valueMeta);
        }
        if (StringUtils.isNotEmpty((String)this.endWindowField)) {
            valueMeta = new ValueMetaDate(variables.resolve(this.endWindowField));
            valueMeta.setOrigin(name);
            valueMeta.setConversionMask(ValueMetaBase.DEFAULT_DATE_FORMAT_MASK);
            inputRowMeta.addValueMeta((IValueMeta)valueMeta);
        }
        if (StringUtils.isNotEmpty((String)this.maxWindowField)) {
            valueMeta = new ValueMetaDate(variables.resolve(this.maxWindowField));
            valueMeta.setOrigin(name);
            valueMeta.setConversionMask(ValueMetaBase.DEFAULT_DATE_FORMAT_MASK);
            inputRowMeta.addValueMeta((IValueMeta)valueMeta);
        }
    }

    public boolean isInput() {
        return false;
    }

    public boolean isOutput() {
        return false;
    }

    public void handleTransform(ILogChannel log, IVariables variables, String runConfigurationName, IBeamPipelineEngineRunConfiguration runConfiguration, String dataSamplersJson, IHopMetadataProvider metadataProvider, PipelineMeta pipelineMeta, TransformMeta transformMeta, Map<String, PCollection<HopRow>> transformCollectionMap, Pipeline pipeline, IRowMeta rowMeta, List<TransformMeta> previousTransforms, PCollection<HopRow> input, String parentLogChannelId) throws HopException {
        long seconds;
        Window window;
        if (StringUtils.isEmpty((String)this.windowType)) {
            throw new HopException("Please specify a window type in Beam Window transform '" + transformMeta.getName() + "'");
        }
        String realDuration = variables.resolve(this.duration);
        long durationSeconds = Const.toLong((String)realDuration, (long)-1L);
        if ("Fixed".equals(this.windowType)) {
            if (durationSeconds <= 0L) {
                throw new HopException("Please specify a valid positive window size (duration) for Beam window transform '" + transformMeta.getName() + "'");
            }
            FixedWindows fixedWindows = FixedWindows.of((Duration)Duration.standardSeconds((long)durationSeconds));
            window = Window.into((WindowFn)fixedWindows);
        } else if ("Sliding".equals(this.windowType)) {
            if (durationSeconds <= 0L) {
                throw new HopException("Please specify a valid positive window size (duration) for Beam window transform '" + transformMeta.getName() + "'");
            }
            String realEvery = variables.resolve(this.every);
            long everySeconds = Const.toLong((String)realEvery, (long)-1L);
            SlidingWindows slidingWindows = SlidingWindows.of((Duration)Duration.standardSeconds((long)durationSeconds)).every(Duration.standardSeconds((long)everySeconds));
            window = Window.into((WindowFn)slidingWindows);
        } else if ("Session".equals(this.windowType)) {
            if (durationSeconds < 600L) {
                throw new HopException("Please specify a window size (duration) of at least 600 (10 minutes) for Beam window transform '" + transformMeta.getName() + "'.  This is the minimum gap between session windows.");
            }
            Sessions sessionWindows = Sessions.withGapDuration((Duration)Duration.standardSeconds((long)durationSeconds));
            window = Window.into((WindowFn)sessionWindows);
        } else if ("Global".equals(this.windowType)) {
            window = Window.into((WindowFn)new GlobalWindows());
        } else {
            throw new HopException("Beam Window type '" + this.windowType + " is not supported in transform '" + transformMeta.getName() + "'");
        }
        if (StringUtils.isNotEmpty((String)this.allowedLateness) && (seconds = (long)Const.toInt((String)variables.resolve(this.allowedLateness), (int)-1)) >= 0L) {
            window = window.withAllowedLateness(Duration.standardSeconds((long)seconds));
        }
        if (this.discardingFiredPanes) {
            window = window.discardingFiredPanes();
        }
        if (this.triggeringType != null) {
            switch (this.triggeringType) {
                case None: {
                    break;
                }
                case RepeatedlyForeverAfterWatermarkPastEndOfWindow: {
                    window = window.triggering((Trigger)Repeatedly.forever((Trigger)AfterWatermark.pastEndOfWindow()));
                }
            }
        }
        PCollection transformPCollection = (PCollection)input.apply((PTransform)window);
        if (StringUtils.isNotEmpty((String)this.startWindowField) || StringUtils.isNotEmpty((String)this.endWindowField) || StringUtils.isNotEmpty((String)this.maxWindowField)) {
            WindowInfoFn windowInfoFn = new WindowInfoFn(transformMeta.getName(), variables.resolve(this.maxWindowField), variables.resolve(this.startWindowField), variables.resolve(this.endWindowField), JsonRowMeta.toJson((IRowMeta)rowMeta));
            transformPCollection = (PCollection)transformPCollection.apply((PTransform)ParDo.of((DoFn)windowInfoFn));
        }
        transformCollectionMap.put(transformMeta.getName(), (PCollection<HopRow>)transformPCollection);
        log.logBasic("Handled transform (WINDOW) : " + transformMeta.getName() + ", gets data from " + previousTransforms.size() + " previous transform(s)");
    }

    public String getWindowType() {
        return this.windowType;
    }

    public void setWindowType(String windowType) {
        this.windowType = windowType;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public String getEvery() {
        return this.every;
    }

    public void setEvery(String every) {
        this.every = every;
    }

    public String getMaxWindowField() {
        return this.maxWindowField;
    }

    public void setMaxWindowField(String maxWindowField) {
        this.maxWindowField = maxWindowField;
    }

    public String getStartWindowField() {
        return this.startWindowField;
    }

    public void setStartWindowField(String startWindowField) {
        this.startWindowField = startWindowField;
    }

    public String getEndWindowField() {
        return this.endWindowField;
    }

    public void setEndWindowField(String endWindowField) {
        this.endWindowField = endWindowField;
    }

    public String getAllowedLateness() {
        return this.allowedLateness;
    }

    public void setAllowedLateness(String allowedLateness) {
        this.allowedLateness = allowedLateness;
    }

    public boolean isDiscardingFiredPanes() {
        return this.discardingFiredPanes;
    }

    public void setDiscardingFiredPanes(boolean discardingFiredPanes) {
        this.discardingFiredPanes = discardingFiredPanes;
    }

    public WindowTriggerType getTriggeringType() {
        return this.triggeringType;
    }

    public void setTriggeringType(WindowTriggerType triggeringType) {
        this.triggeringType = triggeringType;
    }
}

