/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.hop.core.BaseRowSet;
import org.apache.hop.core.Const;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.row.IRowMeta;

public class BlockingRowSet
extends BaseRowSet
implements Comparable<IRowSet>,
IRowSet {
    private BlockingQueue<Object[]> queArray;
    private int timeoutPut;
    private int timeoutGet;

    public BlockingRowSet(int maxSize) {
        this.queArray = new ArrayBlockingQueue<Object[]>(maxSize, false);
        this.timeoutGet = Const.toInt(System.getProperty("HOP_ROWSET_GET_TIMEOUT"), 50);
        this.timeoutPut = Const.toInt(System.getProperty("HOP_ROWSET_PUT_TIMEOUT"), 50);
    }

    @Override
    public boolean putRow(IRowMeta rowMeta, Object[] rowData) {
        return this.putRowWait(rowMeta, rowData, this.timeoutPut, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean putRowWait(IRowMeta rowMeta, Object[] rowData, long time, TimeUnit tu) {
        this.rowMeta = rowMeta;
        try {
            return this.queArray.offer(rowData, time, tu);
        }
        catch (InterruptedException | NullPointerException e) {
            return false;
        }
    }

    @Override
    public Object[] getRow() {
        return this.getRowWait(this.timeoutGet, TimeUnit.MILLISECONDS);
    }

    @Override
    public Object[] getRowImmediate() {
        return (Object[])this.queArray.poll();
    }

    @Override
    public Object[] getRowWait(long timeout, TimeUnit tu) {
        try {
            return this.queArray.poll(timeout, tu);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public int size() {
        return this.queArray.size();
    }

    @Override
    public void clear() {
        this.queArray.clear();
        this.done.set(false);
    }
}

