/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.HTMLTagAttributes;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class SelectOption
extends HTMLTagAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = -3056147198368434425L;
    private String value_;
    private boolean selected_;
    private String text_;
    private String lang_;
    private String dir_;
    private transient VetoableChangeSupport vetos_;

    public SelectOption() {
        this.selected_ = false;
    }

    public SelectOption(String text, String value) {
        try {
            this.setValue(value);
            this.setText(text);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public SelectOption(String text, String value, boolean selected) {
        try {
            this.setValue(value);
            this.setSelected(selected);
            this.setText(text);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(listener);
    }

    public String getDirection() {
        return this.dir_;
    }

    public String getLanguage() {
        return this.lang_;
    }

    @Override
    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- A SelectOption was here -->";
    }

    @Override
    public String getTag() {
        return this.getTag(this.text_);
    }

    public String getTag(String text) {
        StringBuffer s = new StringBuffer("<option");
        if (this.value_ != null) {
            s.append(" value=\"");
            s.append(this.value_);
            s.append("\"");
        }
        if (this.selected_) {
            s.append(" selected=\"selected\"");
        }
        if (this.lang_ != null && this.lang_.length() > 0) {
            if (Trace.isTraceOn()) {
                Trace.log(3, "   Using language attribute.");
            }
            s.append(" lang=\"");
            s.append(this.lang_);
            s.append("\"");
        }
        if (this.dir_ != null && this.dir_.length() > 0) {
            if (Trace.isTraceOn()) {
                Trace.log(3, "   Using direction attribute.");
            }
            s.append(" dir=\"");
            s.append(this.dir_);
            s.append("\"");
        }
        s.append(this.getAttributeString());
        s.append(">");
        if (text == null) {
            Trace.log(2, "Parameter 'text' is null.");
            throw new ExtendedIllegalStateException("text", 4);
        }
        s.append(text);
        s.append("</option>");
        return s.toString();
    }

    public String getText() {
        return this.text_;
    }

    public String getValue() {
        return this.value_;
    }

    public boolean isSelected() {
        return this.selected_;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(listener);
        }
    }

    public void setDirection(String dir) throws PropertyVetoException {
        if (dir == null) {
            throw new NullPointerException("dir");
        }
        if (!dir.equals("ltr") && !dir.equals("rtl")) {
            throw new ExtendedIllegalArgumentException("dir", 2);
        }
        String old = this.dir_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("dir", old, dir);
        }
        this.dir_ = dir;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("dir", old, dir);
        }
    }

    public void setLanguage(String lang) throws PropertyVetoException {
        if (lang == null) {
            throw new NullPointerException("lang");
        }
        String old = this.lang_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("lang", old, lang);
        }
        this.lang_ = lang;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("lang", old, lang);
        }
    }

    public void setSelected(boolean selected) throws PropertyVetoException {
        boolean old = this.selected_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("selected", (Object)old, (Object)selected);
        }
        this.selected_ = selected;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("selected", (Object)old, (Object)selected);
        }
    }

    public void setText(String text) throws PropertyVetoException {
        if (text == null) {
            throw new NullPointerException("text");
        }
        String old = this.text_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("text", old, text);
        }
        this.text_ = text;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("text", old, text);
        }
    }

    public void setValue(String value) throws PropertyVetoException {
        if (value == null) {
            throw new NullPointerException("value");
        }
        String old = this.value_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("value", old, value);
        }
        this.value_ = value;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("value", old, value);
        }
    }

    public String toString() {
        return this.getTag();
    }
}

