/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.Trace;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.KeyAgreement;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;

class DDMTerm {
    static final int ACCSEC = 4205;
    static final int ACCRDBRM = 8705;
    static final int ACCSECRD = 5292;
    static final int AGENT = 5123;
    static final int AGNPRMRM = 4658;
    static final int ALTINDF = 5155;
    static final int BYTDR = 67;
    static final int BYTSTRDR = 68;
    static final int CHRSTRDR = 9;
    static final int CMBACCAM = 5125;
    static final int CMBKEYAM = 5126;
    static final int CMBRNBAM = 5127;
    static final int CMDATHRM = 4636;
    static final int CMDCHKRM = 4692;
    static final int CMDCMPRM = 4683;
    static final int CMDNSPRM = 4688;
    static final int CMMCTLTYP = 4538;
    static final int CMMUOW = 4186;
    static final int CMNAPPC = 5188;
    static final int CMNTCPIP = 5236;
    static final int CODPNTDR = 100;
    static final int DCLFIL = 4140;
    static final int DCLNAM = 4406;
    static final int DCLNAMRM = 4694;
    static final int DICTIONARY = 5208;
    static final int DIRECTORY = 5207;
    static final int DIRFIL = 5132;
    static final int DRCAM = 5145;
    static final int DRCNAM = 4453;
    static final int DUPDCLRM = 4693;
    static final int ENDUOWRM = 8716;
    static final int FILISOLVL = 5234;
    static final int FILNAM = 4366;
    static final int EXCSAT = 4161;
    static final int EXCSATRD = 5187;
    static final int EXTNAM = 4446;
    static final int KEYFIL = 5150;
    static final int KEYORD = 5213;
    static final int LCKMGR = 5154;
    static final int LUWHLDCSR = 4533;
    static final int MGRDEPRM = 4632;
    static final int MGRLVLLS = 5124;
    static final int NAMDR = 102;
    static final int NAMSYMDR = 97;
    static final int PASSWORD = 4513;
    static final int PRCCNVRM = 4677;
    static final int PRMNSPRM = 4689;
    static final int RDB = 9231;
    static final int RDBACCRM = 8711;
    static final int RDBAFLRM = 8730;
    static final int RDBATHRM = 8707;
    static final int RDBNAM = 8464;
    static final int RDBNFNRM = 8721;
    static final int RECAL = 5168;
    static final int RELKEYAM = 5170;
    static final int RELRNBAM = 5171;
    static final int RLLBCKUOW = 4187;
    static final int RLSFILLK = 4419;
    static final int RNBORD = 5214;
    static final int RNDKEYAM = 5172;
    static final int RNDRNBAM = 5173;
    static final int RQSFILLK = 4421;
    static final int RSCLMTRM = 4659;
    static final int RSCRCVM = 5280;
    static final int RTNINA = 4437;
    static final int SECCHK = 4206;
    static final int SECCHKCD = 4516;
    static final int SECCHKRD = 4633;
    static final int SECMEC = 4514;
    static final int SECMGR = 5184;
    static final int SECTKN = 4572;
    static final int SEQFIL = 5179;
    static final int SQLAM = 9223;
    static final int SRVCLSNM = 4423;
    static final int SRVDGN = 4435;
    static final int STRAM = 5219;
    static final int STRFIL = 5221;
    static final int STRCMMCTL = 4188;
    static final int SUPERVISOR = 5180;
    static final int SVRCOD = 4425;
    static final int SYNTAXRM = 4684;
    static final int SYSCMDMGR = 5247;
    static final int S38ALCOB = 53250;
    static final int S38BUF = 54277;
    static final int S38CLOSE = 53252;
    static final int S38CLOST = 53537;
    static final int S38CMD = 53254;
    static final int S38CMDST = 53507;
    static final int S38CTLL = 53509;
    static final int S38DEL = 53255;
    static final int S38DLCOB = 53256;
    static final int S38FEOD = 53259;
    static final int S38GET = 53260;
    static final int S38GETD = 53261;
    static final int S38GETK = 53262;
    static final int S38GETM = 53263;
    static final int S38IOFB = 54274;
    static final int S38LCNRD = 54278;
    static final int S38LRLS = 53525;
    static final int S38LRQS = 53515;
    static final int S38LWAIT = 53516;
    static final int S38MDATA = 53518;
    static final int S38MFILE = 53521;
    static final int S38MID = 53522;
    static final int S38MTEXT = 53526;
    static final int S38MTYPE = 53527;
    static final int S38MSGRM = 53761;
    static final int S38OPEN = 53265;
    static final int S38OPNFB = 54276;
    static final int S38OPTL = 53529;
    static final int S38PUT = 53266;
    static final int S38PUTM = 53267;
    static final int S38UFCB = 53535;
    static final int S38UPDAT = 53273;
    static final int SXXASPRQ = 53290;
    static final int SXXPUTDR = 53276;
    static final int TRGNSPRM = 4703;
    static final int UOWDSP = 8469;
    static final int USRID = 4512;
    static final int VALNSPRM = 4690;
    static final int ENCALC = 6409;
    static final int EUSRIDPWD = 9;
    static final int USRSBSPWD = 6;
    static final int AES = 2;
    static final int SECMECHVALUE_NOT_SUPPORTED = 1;
    static final int DCEINFORMATIONAL_STATUS_ISSUED = 2;
    static final int DCERETRYABLE_ERROR = 3;
    static final int DCENON_RETRYABLE_ERROR = 4;
    static final int GSSAPI_INFORMATIONAL_STATUS_ISSUED = 5;
    static final int GSSAPI_RETRYABLE_ERROR = 6;
    static final int GSSAPI_NON_RETRYABLE_ERROR = 7;
    static final int LOCALSECURITY_SERVICE_INFORMATIONAL_STATUS_ISSUED = 8;
    static final int LOCALSECURITY_SERVICE_RETRYABLE_ERROR = 9;
    static final int LOCALSECURITY_SERVICE_NON_RETRYABLE_ERROR = 10;
    static final int SECTKN_MISSING_WHEN_IT_IS_REQUIRED_OR_IT_IS_INVALID = 11;
    static final int PASSWORD_EXPIRED = 14;
    static final int PASSWORD_INVALID = 15;
    static final int PASSWORD_MISSING = 16;
    static final int USERID_MISSING = 18;
    static final int USERID_INVALID = 19;
    static final int USERID_REVOKED = 20;
    static final int NEWPASSWORD_INVALID = 21;
    static final int AUTHENTICATION_FAILED_BECAUSE_OF_CONNECTIVITY_RESTRICTIONS_ENFORCED_BY_THE_SECURITY_PLUG_IN = 22;
    static final int INVALID_GSS_API_SERVER_CREDENTIAL = 23;
    static final int GSS_API_SERVER_CREDENTIAL_EXPIRED_ON_THE_DATABASE_SERVER = 24;
    static final int CONTINUE__REQUIRE_MORE_SECURITY_CONTEXT_INFORMATION_FOR_AUTHENTICATION = 25;
    static final int SWITCHUSER_IS_INVALID = 26;
    static final int THEENCALG_VALUE_IS_NOT_SUPPORTED_BY_THE_SERVER = 27;
    static final byte[] DESprime = new byte[]{0, -58, 33, 18, -41, 62, -26, 19, -16, -108, 122, -77, 31, 15, 104, 70, -95, -65, -11, -77, -92, -54, 13, 96, -68, 30, 76, 122, 13, -116, 22, -77, -29};
    static final byte[] DESgenerator = new byte[]{70, -112, -6, 31, 123, -98, 29, 68, 66, -56, 108, -111, 20, 96, 63, -34, -49, 7, 30, -36, -20, 95, 98, 110, 33, -30, 86, -82, -39, -22, 52, -28};
    static final byte[] AESprime = new byte[]{0, -14, 79, 99, 21, 14, -86, -105, -52, -25, -113, 87, 16, -60, 95, -81, -66, -73, 28, -10, -88, 114, 79, 99, 20, 14, -86, -105, -52, -25, -113, 87, 16, -60, 95, -81, -66, -73, 28, -10, -88, 114, 79, 99, 19, 8, -29, 43, 38, -22, 21, -108, -120, -100, -69, -4, -111, -10, -33, 117, 36, 53, 46, -7, 121};
    static final byte[] AESgenerator = new byte[]{0, -24, -50, -98, 8, 68, -58, 122, 0, -97, -73, -124, 60, -39, 69, -96, 88, -109, 93, -91, 27, 2, -118, 73, -27, -87, 31, -125, 27, 120, 54, 68, -111, -51, 14, 10, -113, 114, 52, 93, -8, 7, 105, 84, -103, 38, -3, 22, -20, -42, -10, -123, -108, -127, 100, 124, -87, -17, -78, -70, -84, 123, -64, -102, -110};
    static KeyPairGenerator desKeyPairGenerator = null;
    static KeyPairGenerator aesKeyPairGenerator = null;

    DDMTerm() {
    }

    static KeyPair getDESKeyPair() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (desKeyPairGenerator == null) {
            desKeyPairGenerator = KeyPairGenerator.getInstance("DiffieHellman");
            BigInteger p = new BigInteger(DESprime);
            BigInteger g = new BigInteger(DESgenerator);
            DHParameterSpec dhParameterSpec = new DHParameterSpec(p, g, 256);
            try {
                desKeyPairGenerator.initialize(dhParameterSpec);
            }
            catch (InvalidAlgorithmParameterException e) {
                desKeyPairGenerator = null;
                throw e;
            }
        }
        return desKeyPairGenerator.genKeyPair();
    }

    static byte[] getSharedKey(KeyPair keyPair, byte[] publicKey) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException {
        BigInteger g;
        BigInteger p;
        Trace.log(1, "getSharedKey:  serverPublicKey:", publicKey);
        boolean isDes = publicKey.length == 32;
        KeyAgreement keyAgreement = null;
        keyAgreement = KeyAgreement.getInstance("DiffieHellman");
        keyAgreement.init(keyPair.getPrivate());
        KeyFactory keyFactory = null;
        keyFactory = KeyFactory.getInstance("DiffieHellman");
        if ((publicKey[0] & 0x80) == 128) {
            byte[] newPublicKey = new byte[publicKey.length + 1];
            newPublicKey[0] = 0;
            System.arraycopy(publicKey, 0, newPublicKey, 1, publicKey.length);
            publicKey = newPublicKey;
        }
        BigInteger publicKeyBigInt = new BigInteger(1, publicKey);
        if (isDes) {
            p = new BigInteger(DESprime);
            g = new BigInteger(DESgenerator);
        } else {
            p = new BigInteger(AESprime);
            g = new BigInteger(AESgenerator);
        }
        PublicKey publicKeyObject = null;
        publicKeyObject = keyFactory.generatePublic(new DHPublicKeySpec(publicKeyBigInt, p, g));
        keyAgreement.doPhase(publicKeyObject, true);
        byte[] sharedKey = keyAgreement.generateSecret();
        Trace.log(1, "getSharedKey:  sharedKey:", sharedKey);
        return sharedKey;
    }

    static KeyPair getAESKeyPair() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        if (aesKeyPairGenerator == null) {
            aesKeyPairGenerator = KeyPairGenerator.getInstance("DiffieHellman");
            BigInteger p = new BigInteger(AESprime);
            BigInteger g = new BigInteger(AESgenerator);
            DHParameterSpec dhParameterSpec = new DHParameterSpec(p, g, 512);
            try {
                aesKeyPairGenerator.initialize(dhParameterSpec);
            }
            catch (InvalidAlgorithmParameterException e) {
                aesKeyPairGenerator = null;
                throw e;
            }
        }
        return aesKeyPairGenerator.genKeyPair();
    }
}

