/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.KeyedWorkItem;
import org.apache.beam.runners.core.LateDataDroppingDoFnRunner;
import org.apache.beam.runners.core.ProcessFnRunner;
import org.apache.beam.runners.core.ReadyCheckingSideInputReader;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.core.SimpleDoFnRunner;
import org.apache.beam.runners.core.StatefulDoFnRunner;
import org.apache.beam.runners.core.StepContext;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class DoFnRunners {
    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized DoFnRunner<InputT, OutputT> simpleRunner(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> fn, @UnknownKeyFor @NonNull @Initialized SideInputReader sideInputReader, @UnknownKeyFor @NonNull @Initialized OutputManager outputManager, @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> mainOutputTag, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> additionalOutputTags, @UnknownKeyFor @NonNull @Initialized StepContext stepContext, @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputCoders, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation doFnSchemaInformation, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping) {
        return new SimpleDoFnRunner<InputT, OutputT>(options, fn, sideInputReader, outputManager, mainOutputTag, additionalOutputTags, stepContext, inputCoder, outputCoders, windowingStrategy, doFnSchemaInformation, sideInputMapping);
    }

    public static <K, InputT, OutputT, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized DoFnRunner<@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<K, InputT>, @UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> lateDataDroppingRunner(@UnknownKeyFor @NonNull @Initialized DoFnRunner<@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<K, InputT>, @UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> wrappedRunner, @UnknownKeyFor @NonNull @Initialized TimerInternals timerInternals, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy) {
        return new LateDataDroppingDoFnRunner(wrappedRunner, windowingStrategy, timerInternals);
    }

    public static <InputT, OutputT, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized DoFnRunner<InputT, OutputT> defaultStatefulDoFnRunner(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> fn, @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder, @UnknownKeyFor @NonNull @Initialized DoFnRunner<InputT, OutputT> doFnRunner, @UnknownKeyFor @NonNull @Initialized StepContext stepContext, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, @UnknownKeyFor @NonNull @Initialized StatefulDoFnRunner.CleanupTimer<InputT> cleanupTimer, @UnknownKeyFor @NonNull @Initialized StatefulDoFnRunner.StateCleaner<W> stateCleaner) {
        return DoFnRunners.defaultStatefulDoFnRunner(fn, inputCoder, doFnRunner, stepContext, windowingStrategy, cleanupTimer, stateCleaner, false);
    }

    public static <InputT, OutputT, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized DoFnRunner<InputT, OutputT> defaultStatefulDoFnRunner(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> fn, @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder, @UnknownKeyFor @NonNull @Initialized DoFnRunner<InputT, OutputT> doFnRunner, @UnknownKeyFor @NonNull @Initialized StepContext stepContext, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, @UnknownKeyFor @NonNull @Initialized StatefulDoFnRunner.CleanupTimer<InputT> cleanupTimer, @UnknownKeyFor @NonNull @Initialized StatefulDoFnRunner.StateCleaner<W> stateCleaner, @UnknownKeyFor @NonNull @Initialized boolean requiresTimeSortedInputSupported) {
        boolean doFnRequiresTimeSortedInput = DoFnSignatures.signatureForDoFn(doFnRunner.getFn()).processElement().requiresTimeSortedInput();
        if (doFnRequiresTimeSortedInput && !requiresTimeSortedInputSupported) {
            throw new UnsupportedOperationException("DoFn.RequiresTimeSortedInput not currently supported by this runner.");
        }
        return new StatefulDoFnRunner<InputT, OutputT, W>(doFnRunner, inputCoder, stepContext, windowingStrategy, cleanupTimer, stateCleaner, doFnRequiresTimeSortedInput);
    }

    public static <InputT, OutputT, RestrictionT> @UnknownKeyFor @NonNull @Initialized ProcessFnRunner<InputT, OutputT, RestrictionT> newProcessFnRunner(/*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @NonNull @Initialized SplittableParDoViaKeyedWorkItems.ProcessFn<InputT, OutputT, RestrictionT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> fn, @UnknownKeyFor @NonNull @Initialized PipelineOptions options, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> views, @UnknownKeyFor @NonNull @Initialized ReadyCheckingSideInputReader sideInputReader, @UnknownKeyFor @NonNull @Initialized OutputManager outputManager, @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> mainOutputTag, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> additionalOutputTags, @UnknownKeyFor @NonNull @Initialized StepContext stepContext, @Nullable @UnknownKeyFor @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KeyedWorkItem<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized KV<InputT, RestrictionT>>> inputCoder, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputCoders, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation doFnSchemaInformation, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping) {
        return new ProcessFnRunner<InputT, OutputT, RestrictionT>(DoFnRunners.simpleRunner(options, fn, sideInputReader, outputManager, mainOutputTag, additionalOutputTags, stepContext, inputCoder, outputCoders, windowingStrategy, doFnSchemaInformation, sideInputMapping), views, sideInputReader);
    }

    public static interface OutputManager {
        public <T> void output(@UnknownKeyFor @NonNull @Initialized TupleTag<T> var1, @UnknownKeyFor @NonNull @Initialized WindowedValue<T> var2);
    }
}

