/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.pipeline.fatjar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.jboss.jandex.IndexWriter;
import org.jboss.jandex.Indexer;

public class FatJarBuilder {
    private ILogChannel log;
    private IVariables variables;
    private String targetJarFile;
    private List<String> jarFiles = new ArrayList<String>();
    private String extraTransformPluginClasses = null;
    private String extraXpPluginClasses = null;
    private transient Map<String, String> fileContentMap;
    private transient Map<String, String> classCollisionMap;
    private transient Set<String> collisionFileSet;
    private transient Set<String> fileSet;

    public FatJarBuilder() {
    }

    public FatJarBuilder(ILogChannel log, IVariables variables, String targetJarFile, List<String> jarFiles) {
        this();
        this.log = log;
        this.variables = variables;
        this.targetJarFile = targetJarFile;
        this.jarFiles = jarFiles;
    }

    public void buildTargetJar() throws HopException {
        this.fileContentMap = new HashMap<String, String>();
        this.classCollisionMap = new HashMap<String, String>();
        this.collisionFileSet = new HashSet<String>();
        this.fileSet = new HashSet<String>();
        String realTargetJarFile = this.variables.resolve(this.targetJarFile);
        Indexer indexer = new Indexer();
        try {
            byte[] buffer = new byte[1024];
            try (JarOutputStream zipOutputStream = new JarOutputStream(new FileOutputStream(realTargetJarFile));){
                for (String jarFile : this.jarFiles) {
                    File jarFileFile = new File(jarFile);
                    String jarFileBaseName = jarFileFile.getName();
                    if (this.fileSet.contains(jarFileBaseName)) {
                        this.log.logDetailed("Skipping duplicate jar file: " + jarFile);
                        continue;
                    }
                    if (jarFileBaseName.contains("jersey-bundle")) continue;
                    this.fileSet.add(jarFileBaseName);
                    try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(jarFile));){
                        ZipEntry zipEntry = zipInputStream.getNextEntry();
                        while (zipEntry != null) {
                            try {
                                boolean skip = false;
                                boolean merge = false;
                                boolean index = false;
                                String entryName = zipEntry.getName();
                                if (zipEntry.isDirectory()) {
                                    skip = true;
                                } else if (entryName.contains("META-INF/INDEX.LIST")) {
                                    skip = true;
                                } else if (entryName.contains("META-INF/MANIFEST.MF")) {
                                    skip = true;
                                } else if (entryName.startsWith("META-INF") && entryName.endsWith(".SF")) {
                                    skip = true;
                                } else if (entryName.startsWith("META-INF") && entryName.endsWith(".DSA")) {
                                    skip = true;
                                } else if (entryName.startsWith("META-INF") && entryName.endsWith(".RSA")) {
                                    skip = true;
                                } else if (entryName.startsWith("META-INF/services/")) {
                                    merge = true;
                                    skip = true;
                                } else if (entryName.endsWith("module-info.class")) {
                                    skip = true;
                                } else if (entryName.endsWith("package-info.class")) {
                                    skip = true;
                                } else if (entryName.endsWith("UnusedStubClass.class")) {
                                    skip = true;
                                } else if (entryName.endsWith("META-INF/jandex.idx")) {
                                    skip = true;
                                } else if (entryName.endsWith(".class")) {
                                    index = true;
                                    String otherJar = this.classCollisionMap.get(entryName);
                                    if (otherJar != null) {
                                        skip = true;
                                        if (!this.collisionFileSet.contains(jarFile)) {
                                            this.collisionFileSet.add(jarFile);
                                            this.log.logDetailed("Duplicate class(es) detected in " + jarFile + " from : " + otherJar);
                                            this.log.logDetailed("    Example class: " + entryName);
                                        }
                                    } else {
                                        this.log.logDebug("Adding class " + entryName + " for " + jarFile);
                                        this.classCollisionMap.put(entryName, jarFile);
                                    }
                                }
                                if (zipEntry.getName().contains("$") || jarFileBaseName.startsWith("guava") || jarFileBaseName.startsWith("akka-") || jarFileBaseName.startsWith("scala-") || jarFileBaseName.startsWith("flink-runtime") || jarFileBaseName.startsWith("beam-sdks-java-io") || jarFileBaseName.startsWith("beam-runners-spark") || jarFileBaseName.startsWith("beam-runners-direct") || jarFileBaseName.startsWith("beam-runners-flink") || jarFileBaseName.startsWith("beam-sdks-java-core") || jarFileBaseName.startsWith("beam-runners-core")) {
                                    index = false;
                                }
                                if (!skip) {
                                    try {
                                        zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
                                    }
                                    catch (ZipException ze) {
                                        skip = true;
                                    }
                                }
                                if (merge) {
                                    String fileContent = IOUtils.toString((InputStream)zipInputStream, (String)"UTF-8");
                                    this.fileContentMap.merge(entryName, fileContent, (a, b) -> a + Const.CR + b);
                                } else if (!skip) {
                                    int len;
                                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                    while ((len = zipInputStream.read(buffer)) > 0) {
                                        zipOutputStream.write(buffer, 0, len);
                                        if (!index) continue;
                                        baos.write(buffer, 0, len);
                                    }
                                    if (index) {
                                        indexer.index((InputStream)new ByteArrayInputStream(baos.toByteArray()));
                                    }
                                }
                                zipInputStream.closeEntry();
                                if (!skip) {
                                    zipOutputStream.closeEntry();
                                }
                                zipEntry = zipInputStream.getNextEntry();
                            }
                            catch (Exception e) {
                                throw new HopException("Error adding jar file entry: " + zipEntry.getName(), (Throwable)e);
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new HopException("Error adding jar file: " + jarFile, (Throwable)e);
                    }
                }
                for (String entryName : this.fileContentMap.keySet()) {
                    String fileContent = this.fileContentMap.get(entryName);
                    zipOutputStream.putNextEntry(new ZipEntry(entryName));
                    zipOutputStream.write(fileContent.getBytes("UTF-8"));
                    zipOutputStream.closeEntry();
                }
                this.log.logBasic("Adding Jandex index");
                zipOutputStream.putNextEntry(new ZipEntry("META-INF/jandex.idx"));
                IndexWriter indexWriter = new IndexWriter((OutputStream)zipOutputStream);
                indexWriter.write(indexer.complete());
                zipOutputStream.closeEntry();
            }
        }
        catch (Exception e) {
            throw new HopException("Unable to build far jar file '" + realTargetJarFile + "'", (Throwable)e);
        }
        finally {
            this.fileContentMap.clear();
        }
    }

    public String getTargetJarFile() {
        return this.targetJarFile;
    }

    public void setTargetJarFile(String targetJarFile) {
        this.targetJarFile = targetJarFile;
    }

    public List<String> getJarFiles() {
        return this.jarFiles;
    }

    public void setJarFiles(List<String> jarFiles) {
        this.jarFiles = jarFiles;
    }

    public String getExtraTransformPluginClasses() {
        return this.extraTransformPluginClasses;
    }

    public void setExtraTransformPluginClasses(String extraTransformPluginClasses) {
        this.extraTransformPluginClasses = extraTransformPluginClasses;
    }

    public String getExtraXpPluginClasses() {
        return this.extraXpPluginClasses;
    }

    public void setExtraXpPluginClasses(String extraXpPluginClasses) {
        this.extraXpPluginClasses = extraXpPluginClasses;
    }

    public Map<String, String> getFileContentMap() {
        return this.fileContentMap;
    }

    public void setFileContentMap(Map<String, String> fileContentMap) {
        this.fileContentMap = fileContentMap;
    }
}

