/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.apache.calcite.util.Pair;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.ForwardWalker;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.PreOrderOnceWalker;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.lib.TypeRule;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFStruct;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointLookupOptimizer
extends Transform {
    private static final Logger LOG = LoggerFactory.getLogger(PointLookupOptimizer.class);
    private static final String IN_UDF = GenericUDFIn.class.getAnnotation(Description.class).name();
    private static final String STRUCT_UDF = GenericUDFStruct.class.getAnnotation(Description.class).name();
    public final int minOrExpr;

    public PointLookupOptimizer(int min) {
        this.minOrExpr = min;
    }

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", FilterOperator.getOperatorName() + "%"), new FilterTransformer());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, null);
        ForwardWalker ogw = new ForwardWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    private class OrExprProcessor
    implements NodeProcessor {
        private OrExprProcessor() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ExprNodeGenericFuncDesc fd = (ExprNodeGenericFuncDesc)nd;
            if (!FunctionRegistry.isOpOr(fd)) {
                return null;
            }
            List<ExprNodeDesc> children = fd.getChildren();
            if (children.size() < PointLookupOptimizer.this.minOrExpr) {
                return null;
            }
            ArrayListMultimap columnConstantsMap = ArrayListMultimap.create();
            boolean modeAnd = false;
            for (int i = 0; i < children.size(); ++i) {
                List<ExprNodeDesc> conjunctions;
                ExprNodeDesc child = children.get(i);
                if (FunctionRegistry.isOpAnd(child)) {
                    if (i == 0) {
                        modeAnd = true;
                    } else if (!modeAnd) {
                        return null;
                    }
                    conjunctions = child.getChildren();
                } else {
                    if (i == 0) {
                        modeAnd = false;
                    } else if (modeAnd) {
                        return null;
                    }
                    conjunctions = new ArrayList<ExprNodeDesc>(1);
                    conjunctions.add(child);
                }
                for (ExprNodeDesc conjunction : conjunctions) {
                    if (!(conjunction instanceof ExprNodeGenericFuncDesc)) {
                        return null;
                    }
                    ExprNodeGenericFuncDesc conjCall = (ExprNodeGenericFuncDesc)conjunction;
                    Class<?> genericUdfClass = conjCall.getGenericUDF().getClass();
                    if (GenericUDFOPEqual.class == genericUdfClass) {
                        String refString;
                        Object ref;
                        if (conjCall.getChildren().get(0) instanceof ExprNodeColumnDesc && conjCall.getChildren().get(1) instanceof ExprNodeConstantDesc) {
                            ref = (ExprNodeColumnDesc)conjCall.getChildren().get(0);
                            refString = ((ExprNodeColumnDesc)ref).toString();
                            columnConstantsMap.put((Object)refString, (Object)new Pair(ref, (Object)((ExprNodeConstantDesc)conjCall.getChildren().get(1))));
                            if (columnConstantsMap.get((Object)refString).size() == i + 1) continue;
                            return null;
                        }
                        if (conjCall.getChildren().get(1) instanceof ExprNodeColumnDesc && conjCall.getChildren().get(0) instanceof ExprNodeConstantDesc) {
                            ref = (ExprNodeColumnDesc)conjCall.getChildren().get(1);
                            refString = ((ExprNodeColumnDesc)ref).toString();
                            columnConstantsMap.put((Object)refString, (Object)new Pair(ref, (Object)((ExprNodeConstantDesc)conjCall.getChildren().get(0))));
                            if (columnConstantsMap.get((Object)refString).size() == i + 1) continue;
                            return null;
                        }
                        return null;
                    }
                    return null;
                }
            }
            ExprNodeGenericFuncDesc newPredicate = null;
            ArrayList<ExprNodeDesc> newChildren = new ArrayList<ExprNodeDesc>(children.size());
            ArrayList<ExprNodeDesc> columns = new ArrayList<ExprNodeDesc>();
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<TypeInfo> typeInfos = new ArrayList<TypeInfo>();
            for (int i = 0; i < children.size(); ++i) {
                ArrayList<ExprNodeDesc> constantFields = new ArrayList<ExprNodeDesc>(children.size());
                for (String keyString : columnConstantsMap.keySet()) {
                    Pair columnConstant = (Pair)columnConstantsMap.get((Object)keyString).get(i);
                    if (i == 0) {
                        columns.add((ExprNodeDesc)columnConstant.left);
                        names.add(((ExprNodeColumnDesc)columnConstant.left).getColumn());
                        typeInfos.add(((ExprNodeColumnDesc)columnConstant.left).getTypeInfo());
                    }
                    constantFields.add((ExprNodeDesc)columnConstant.right);
                }
                if (i == 0) {
                    ExprNodeDesc columnsRefs = columns.size() == 1 ? (ExprNodeDesc)columns.get(0) : new ExprNodeGenericFuncDesc(TypeInfoFactory.getStructTypeInfo(names, typeInfos), FunctionRegistry.getFunctionInfo(STRUCT_UDF).getGenericUDF(), columns);
                    newChildren.add(columnsRefs);
                }
                ExprNodeDesc values = constantFields.size() == 1 ? (ExprNodeDesc)constantFields.get(0) : new ExprNodeGenericFuncDesc(TypeInfoFactory.getStructTypeInfo(names, typeInfos), FunctionRegistry.getFunctionInfo(STRUCT_UDF).getGenericUDF(), constantFields);
                newChildren.add(values);
            }
            newPredicate = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getFunctionInfo(IN_UDF).getGenericUDF(), newChildren);
            return newPredicate;
        }
    }

    private class FilterTransformer
    implements NodeProcessor {
        private FilterTransformer() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            FilterOperator filterOp = (FilterOperator)nd;
            ExprNodeDesc predicate = ((FilterDesc)filterOp.getConf()).getPredicate();
            ExprNodeDesc newPredicate = this.generateInClause(predicate);
            if (newPredicate != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Generated new predicate with IN clause: " + newPredicate);
                }
                ((FilterDesc)filterOp.getConf()).setPredicate(newPredicate);
            }
            return null;
        }

        private ExprNodeDesc generateInClause(ExprNodeDesc predicate) throws SemanticException {
            LinkedHashMap<Rule, NodeProcessor> exprRules = new LinkedHashMap<Rule, NodeProcessor>();
            exprRules.put(new TypeRule(ExprNodeGenericFuncDesc.class), new OrExprProcessor());
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, exprRules, null);
            PreOrderOnceWalker egw = new PreOrderOnceWalker(disp);
            ArrayList<Node> startNodes = new ArrayList<Node>();
            startNodes.add(predicate);
            HashMap<Node, Object> outputMap = new HashMap<Node, Object>();
            egw.startWalking(startNodes, outputMap);
            return (ExprNodeDesc)outputMap.get(predicate);
        }
    }
}

