/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.core.construction.TransformInputs;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.translation.BoundedDataset;
import org.apache.beam.runners.spark.translation.Dataset;
import org.apache.beam.runners.spark.translation.SparkPCollectionView;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class EvaluationContext {
    private final @UnknownKeyFor @NonNull @Initialized JavaSparkContext jsc;
    private @UnknownKeyFor @NonNull @Initialized JavaStreamingContext jssc;
    private final @UnknownKeyFor @NonNull @Initialized Pipeline pipeline;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PValue, @UnknownKeyFor @NonNull @Initialized Dataset> datasets = new LinkedHashMap<PValue, Dataset>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PValue, @UnknownKeyFor @NonNull @Initialized Dataset> pcollections = new LinkedHashMap<PValue, Dataset>();
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Dataset> leaves = new LinkedHashSet<Dataset>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PValue, @UnknownKeyFor @NonNull @Initialized Object> pobjects = new LinkedHashMap<PValue, Object>();
    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> currentTransform;
    private final @UnknownKeyFor @NonNull @Initialized SparkPCollectionView pviews = new SparkPCollectionView();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection, @UnknownKeyFor @NonNull @Initialized Long> cacheCandidates = new HashMap<PCollection, Long>();
    private final @UnknownKeyFor @NonNull @Initialized PipelineOptions options;
    private final @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions serializableOptions;

    public EvaluationContext(@UnknownKeyFor @NonNull @Initialized JavaSparkContext jsc, @UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        this.jsc = jsc;
        this.pipeline = pipeline;
        this.options = options;
        this.serializableOptions = new SerializablePipelineOptions(options);
    }

    public EvaluationContext(@UnknownKeyFor @NonNull @Initialized JavaSparkContext jsc, @UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized JavaStreamingContext jssc) {
        this(jsc, pipeline, options);
        this.jssc = jssc;
    }

    public @UnknownKeyFor @NonNull @Initialized JavaSparkContext getSparkContext() {
        return this.jsc;
    }

    public @UnknownKeyFor @NonNull @Initialized JavaStreamingContext getStreamingContext() {
        return this.jssc;
    }

    public @UnknownKeyFor @NonNull @Initialized Pipeline getPipeline() {
        return this.pipeline;
    }

    public @UnknownKeyFor @NonNull @Initialized PipelineOptions getOptions() {
        return this.options;
    }

    public @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions getSerializableOptions() {
        return this.serializableOptions;
    }

    public void setCurrentTransform(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
        this.currentTransform = transform;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getCurrentTransform() {
        return this.currentTransform;
    }

    public <T extends PValue> T getInput(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<T, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
        PValue input = (PValue)Iterables.getOnlyElement((Iterable)TransformInputs.nonAdditionalInputs(this.getCurrentTransform()));
        return (T)input;
    }

    public <T> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getInputs(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
        Preconditions.checkArgument((this.currentTransform != null ? 1 : 0) != 0, (Object)"can only be called with non-null currentTransform");
        Preconditions.checkArgument((this.currentTransform.getTransform() == transform ? 1 : 0) != 0, (Object)"can only be called with current transform");
        return this.currentTransform.getInputs();
    }

    public <T extends PValue> T getOutput(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, T> transform) {
        PValue output = (PValue)Iterables.getOnlyElement(this.getOutputs(transform).values());
        return (T)output;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getOutputs(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
        Preconditions.checkArgument((this.currentTransform != null ? 1 : 0) != 0, (Object)"can only be called with non-null currentTransform");
        Preconditions.checkArgument((this.currentTransform.getTransform() == transform ? 1 : 0) != 0, (Object)"can only be called with current transform");
        return this.currentTransform.getOutputs();
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getOutputCoders() {
        return this.currentTransform.getOutputs().entrySet().stream().filter(e -> e.getValue() instanceof PCollection).collect(Collectors.toMap(Map.Entry::getKey, e -> ((PCollection)e.getValue()).getCoder()));
    }

    public @UnknownKeyFor @NonNull @Initialized boolean shouldCache(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PValue> transform, @UnknownKeyFor @NonNull @Initialized PValue pvalue) {
        if (((SparkPipelineOptions)this.serializableOptions.get().as(SparkPipelineOptions.class)).isCacheDisabled() || transform instanceof GroupByKey) {
            return false;
        }
        return pvalue instanceof PCollection && this.cacheCandidates.getOrDefault(pvalue, 0L) > 1L;
    }

    public void putDataset(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PValue> transform, @UnknownKeyFor @NonNull @Initialized Dataset dataset) {
        this.putDataset(transform, this.getOutput(transform), dataset);
    }

    public void putDataset(@UnknownKeyFor @NonNull @Initialized PValue pvalue, @UnknownKeyFor @NonNull @Initialized Dataset dataset) {
        this.putDataset(null, pvalue, dataset);
    }

    private void putDataset(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PValue> transform, @UnknownKeyFor @NonNull @Initialized PValue pvalue, @UnknownKeyFor @NonNull @Initialized Dataset dataset) {
        try {
            dataset.setName(pvalue.getName());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (this.shouldCache(transform, pvalue)) {
            Coder coder = ((PCollection)pvalue).getCoder();
            Coder wCoder = ((PCollection)pvalue).getWindowingStrategy().getWindowFn().windowCoder();
            dataset.cache(this.storageLevel(), (Coder<?>)WindowedValue.getFullCoder((Coder)coder, (Coder)wCoder));
        }
        this.datasets.put(pvalue, dataset);
        this.leaves.add(dataset);
    }

    public @UnknownKeyFor @NonNull @Initialized Dataset borrowDataset(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PValue, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
        return this.borrowDataset(this.getInput(transform));
    }

    public @UnknownKeyFor @NonNull @Initialized Dataset borrowDataset(@UnknownKeyFor @NonNull @Initialized PValue pvalue) {
        Dataset dataset = this.datasets.get(pvalue);
        this.leaves.remove(dataset);
        return dataset;
    }

    public void computeOutputs() {
        for (Dataset dataset : this.leaves) {
            dataset.action();
        }
    }

    public <T> T get(@UnknownKeyFor @NonNull @Initialized PValue value) {
        if (this.pobjects.containsKey(value)) {
            return (T)this.pobjects.get(value);
        }
        if (this.pcollections.containsKey(value)) {
            JavaRDD rdd = ((BoundedDataset)this.pcollections.get(value)).getRDD();
            Object res = Iterables.getOnlyElement((Iterable)rdd.collect());
            this.pobjects.put(value, res);
            return (T)res;
        }
        throw new IllegalStateException("Cannot resolve un-known PObject: " + value);
    }

    public @UnknownKeyFor @NonNull @Initialized SparkPCollectionView getPViews() {
        return this.pviews;
    }

    public void putPView(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> view, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> value, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> coder) {
        this.pviews.putPView(view, value, coder);
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection, @UnknownKeyFor @NonNull @Initialized Long> getCacheCandidates() {
        return this.cacheCandidates;
    }

    <T> @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> getWindowedValues(@UnknownKeyFor @NonNull @Initialized PCollection<T> pcollection) {
        BoundedDataset boundedDataset = (BoundedDataset)this.datasets.get(pcollection);
        this.leaves.remove(boundedDataset);
        return boundedDataset.getValues(pcollection);
    }

    public @UnknownKeyFor @NonNull @Initialized String storageLevel() {
        return ((SparkPipelineOptions)this.serializableOptions.get().as(SparkPipelineOptions.class)).getStorageLevel();
    }
}

