/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.state;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.beam.runners.core.InMemoryStateInternals;
import org.apache.beam.runners.core.StateInternals;
import org.apache.beam.runners.core.StateNamespace;
import org.apache.beam.runners.core.StateNamespaces;
import org.apache.beam.runners.core.StateTag;
import org.apache.beam.runners.core.StateTags;
import org.apache.beam.runners.fnexecution.state.StateRequestHandlers;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.state.BagState;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class InMemoryBagUserStateFactory<@UnknownKeyFor K, @UnknownKeyFor V, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
implements StateRequestHandlers.BagUserStateHandlerFactory<K, V, W> {
    final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized InMemorySingleKeyBagState> handlers = new ArrayList<InMemorySingleKeyBagState>();

    @Override
    public  @UnknownKeyFor @NonNull @Initialized StateRequestHandlers.BagUserStateHandler<K, V, W> forUserState(@UnknownKeyFor @NonNull @Initialized String pTransformId, @UnknownKeyFor @NonNull @Initialized String userStateId, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder, @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder) {
        InMemorySingleKeyBagState bagUserStateHandler = new InMemorySingleKeyBagState(userStateId, valueCoder, windowCoder);
        this.handlers.add(bagUserStateHandler);
        return bagUserStateHandler;
    }

    public void resetForNewKey() {
        for (InMemorySingleKeyBagState stateBags : this.handlers) {
            stateBags.reset();
        }
    }

    static class InMemorySingleKeyBagState<@UnknownKeyFor K, @UnknownKeyFor V, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
    implements StateRequestHandlers.BagUserStateHandler<K, V, W> {
        private final @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized BagState<V>> stateTag;
        private final @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder;
        private volatile @UnknownKeyFor @NonNull @Initialized StateInternals stateInternals;

        InMemorySingleKeyBagState(@UnknownKeyFor @NonNull @Initialized String userStateId, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder, @UnknownKeyFor @NonNull @Initialized Coder<W> windowCoder) {
            this.windowCoder = windowCoder;
            this.stateTag = StateTags.bag((String)userStateId, valueCoder);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Iterable<V> get(K key, W window) {
            this.initStateInternals(key);
            StateNamespace namespace = StateNamespaces.window(this.windowCoder, window);
            BagState bagState = (BagState)this.stateInternals.state(namespace, this.stateTag);
            return bagState.read();
        }

        @Override
        public void append(K key, W window, @UnknownKeyFor @NonNull @Initialized Iterator<V> values) {
            this.initStateInternals(key);
            StateNamespace namespace = StateNamespaces.window(this.windowCoder, window);
            BagState bagState = (BagState)this.stateInternals.state(namespace, this.stateTag);
            while (values.hasNext()) {
                bagState.add(values.next());
            }
        }

        @Override
        public void clear(K key, W window) {
            this.initStateInternals(key);
            StateNamespace namespace = StateNamespaces.window(this.windowCoder, window);
            BagState bagState = (BagState)this.stateInternals.state(namespace, this.stateTag);
            bagState.clear();
        }

        private void initStateInternals(K key) {
            if (this.stateInternals == null) {
                this.stateInternals = InMemoryStateInternals.forKey(key);
            }
        }

        void reset() {
            this.stateInternals = null;
        }
    }
}

