/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.grpc.okhttp;

import com.clickhouse.client.internal.google.common.base.Preconditions;
import com.clickhouse.client.internal.grpc.ExperimentalApi;
import com.clickhouse.client.internal.grpc.okhttp.OkHttpChannelBuilder;
import com.clickhouse.client.internal.grpc.okhttp.Utils;
import com.clickhouse.client.internal.grpc.okhttp.internal.ConnectionSpec;
import javax.net.ssl.SSLSocketFactory;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1785")
public final class SslSocketFactoryServerCredentials {
    private SslSocketFactoryServerCredentials() {
    }

    public static com.clickhouse.client.internal.grpc.ServerCredentials create(SSLSocketFactory factory) {
        return new ServerCredentials(factory);
    }

    public static com.clickhouse.client.internal.grpc.ServerCredentials create(SSLSocketFactory factory, com.squareup.okhttp.ConnectionSpec connectionSpec) {
        return new ServerCredentials(factory, Utils.convertSpec(connectionSpec));
    }

    static final class ServerCredentials
    extends com.clickhouse.client.internal.grpc.ServerCredentials {
        private final SSLSocketFactory factory;
        private final ConnectionSpec connectionSpec;

        ServerCredentials(SSLSocketFactory factory) {
            this(factory, OkHttpChannelBuilder.INTERNAL_DEFAULT_CONNECTION_SPEC);
        }

        ServerCredentials(SSLSocketFactory factory, ConnectionSpec connectionSpec) {
            this.factory = Preconditions.checkNotNull(factory, "factory");
            this.connectionSpec = Preconditions.checkNotNull(connectionSpec, "connectionSpec");
        }

        public SSLSocketFactory getFactory() {
            return this.factory;
        }

        public ConnectionSpec getConnectionSpec() {
            return this.connectionSpec;
        }
    }
}

