/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.metrics;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.DirtyState;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.GaugeData;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.MetricCell;
import org.apache.beam.sdk.metrics.Gauge;
import org.apache.beam.sdk.metrics.MetricName;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class GaugeCell
implements Gauge,
MetricCell<GaugeData> {
    private final @UnknownKeyFor @NonNull @Initialized DirtyState dirty = new DirtyState();
    private final @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized GaugeData> gaugeValue = new AtomicReference<GaugeData>(GaugeData.empty());
    private final @UnknownKeyFor @NonNull @Initialized MetricName name;

    public GaugeCell(@UnknownKeyFor @NonNull @Initialized MetricName name) {
        this.name = name;
    }

    @Override
    public void reset() {
        this.gaugeValue.set(GaugeData.empty());
        this.dirty.reset();
    }

    public void set(@UnknownKeyFor @NonNull @Initialized long value) {
        this.update(GaugeData.create(value));
    }

    void update(@UnknownKeyFor @NonNull @Initialized GaugeData data) {
        GaugeData original;
        while (!this.gaugeValue.compareAndSet(original = this.gaugeValue.get(), original.combine(data))) {
        }
        this.dirty.afterModification();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized DirtyState getDirty() {
        return this.dirty;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized GaugeData getCumulative() {
        return this.gaugeValue.get();
    }

    public @UnknownKeyFor @NonNull @Initialized MetricName getName() {
        return this.name;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object object) {
        if (object instanceof GaugeCell) {
            GaugeCell gaugeCell = (GaugeCell)object;
            return Objects.equals(this.dirty, gaugeCell.dirty) && Objects.equals(this.gaugeValue.get(), gaugeCell.gaugeValue.get()) && Objects.equals(this.name, gaugeCell.name);
        }
        return false;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.dirty, this.gaugeValue.get(), this.name);
    }
}

