/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.ssh;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.HTTPProxyData;
import com.trilead.ssh2.ProxyData;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transform.BaseTransformData;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transforms.ssh.SshMeta;

public class SshData
extends BaseTransformData
implements ITransformData {
    public int indexOfCommand = -1;
    public Connection conn = null;
    public boolean wroteOneRow = false;
    public String commands = null;
    public int nrInputFields;
    public int nrOutputFields;
    public String stdOutField = null;
    public String stdTypeField = null;
    public IRowMeta outputRowMeta;

    public static Connection openConnection(IVariables variables, SshMeta meta) throws HopException {
        Connection connection = null;
        char[] content = null;
        String hostname = variables.resolve(meta.getServerName());
        int port = Const.toInt((String)variables.resolve(meta.getPort()), (int)22);
        String username = variables.resolve(meta.getUserName());
        String password = Encr.decryptPasswordOptionallyEncrypted((String)variables.resolve(meta.getPassword()));
        String passPhrase = Encr.decryptPasswordOptionallyEncrypted((String)variables.resolve(meta.getPassPhrase()));
        try {
            int timeOut;
            if (meta.isUsePrivateKey()) {
                String keyFilename = variables.resolve(meta.getKeyFileName());
                if (StringUtils.isEmpty((String)keyFilename)) {
                    throw new HopException(BaseMessages.getString(SshMeta.PKG, (String)"SSH.Error.PrivateKeyFileMissing", (String[])new String[0]));
                }
                FileObject keyFileObject = HopVfs.getFileObject((String)keyFilename);
                if (!keyFileObject.exists()) {
                    throw new HopException(BaseMessages.getString(SshMeta.PKG, (String)"SSH.Error.PrivateKeyNotExist", (String[])new String[]{keyFilename}));
                }
                FileContent keyFileContent = keyFileObject.getContent();
                CharArrayWriter charArrayWriter = new CharArrayWriter((int)keyFileContent.getSize());
                try (InputStream in = keyFileContent.getInputStream();){
                    IOUtils.copy((InputStream)in, (Writer)charArrayWriter, (Charset)StandardCharsets.UTF_8);
                }
                content = charArrayWriter.toCharArray();
            }
            connection = new Connection(hostname, port);
            String proxyHost = variables.resolve(meta.getProxyHost());
            int proxyPort = Const.toInt((String)variables.resolve(meta.getProxyPort()), (int)23);
            String proxyUsername = variables.resolve(meta.getProxyUsername());
            String proxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)variables.resolve(meta.getProxyPassword()));
            if (!Utils.isEmpty((CharSequence)proxyHost)) {
                if (!Utils.isEmpty((CharSequence)proxyUsername)) {
                    connection.setProxyData((ProxyData)new HTTPProxyData(proxyHost, proxyPort, proxyUsername, proxyPassword));
                } else {
                    connection.setProxyData((ProxyData)new HTTPProxyData(proxyHost, proxyPort));
                }
            }
            if ((timeOut = Const.toInt((String)variables.resolve(meta.getTimeOut()), (int)0)) == 0) {
                connection.connect();
            } else {
                connection.connect(null, 0, timeOut * 1000);
            }
            boolean isAuthenticated = meta.isUsePrivateKey() ? connection.authenticateWithPublicKey(username, content, variables.resolve(passPhrase)) : connection.authenticateWithPassword(username, password);
            if (!isAuthenticated) {
                throw new HopException(BaseMessages.getString(SshMeta.PKG, (String)"SSH.Error.AuthenticationFailed", (String[])new String[]{username}));
            }
        }
        catch (Exception e) {
            if (connection != null) {
                connection.close();
            }
            throw new HopException(BaseMessages.getString(SshMeta.PKG, (String)"SSH.Error.ErrorConnecting", (String[])new String[]{hostname, username}), (Throwable)e);
        }
        return connection;
    }
}

