/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.cassandrasstableoutput.writer;

import org.apache.cassandra.config.YamlConfigurationLoader;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.pipeline.transforms.cassandrasstableoutput.writer.AbstractSSTableWriter;
import org.apache.hop.pipeline.transforms.cassandrasstableoutput.writer.Cql3SSTableWriter;

public class SSTableWriterBuilder {
    private String configFilePath;
    private String directory;
    private String keyspace;
    private String table;
    private String primaryKey;
    private int bufferSize;
    private IRowMeta rowMeta;

    public SSTableWriterBuilder withConfig(String configFilePath) {
        this.configFilePath = !configFilePath.startsWith("file:") ? "file:" + configFilePath : configFilePath;
        return this;
    }

    public SSTableWriterBuilder withDirectory(String outputDirectoryPath) {
        this.directory = outputDirectoryPath;
        return this;
    }

    public SSTableWriterBuilder withKeyspace(String keyspaceName) {
        this.keyspace = keyspaceName;
        return this;
    }

    public SSTableWriterBuilder withTable(String tableName) {
        this.table = tableName;
        return this;
    }

    public SSTableWriterBuilder withPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
        return this;
    }

    public SSTableWriterBuilder withBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public SSTableWriterBuilder withRowMeta(IRowMeta rowMeta) {
        this.rowMeta = rowMeta;
        return this;
    }

    public SSTableWriterBuilder withCqlVersion(int cqlVersion) {
        return this;
    }

    public AbstractSSTableWriter build() throws Exception {
        System.setProperty("cassandra.config", this.configFilePath);
        Cql3SSTableWriter writer = this.getCql3SSTableWriter();
        writer.setRowMeta(this.rowMeta);
        Cql3SSTableWriter result = writer;
        result.setDirectory(this.directory);
        result.setKeyspace(this.keyspace);
        result.setTable(this.table);
        result.setPrimaryKey(this.primaryKey);
        result.setBufferSize(this.bufferSize);
        result.setPartitionerClass(this.getPartitionerClass());
        return result;
    }

    String getPartitionerClass() throws ConfigurationException {
        return new YamlConfigurationLoader().loadConfig().partitioner;
    }

    Cql3SSTableWriter getCql3SSTableWriter() {
        return new Cql3SSTableWriter();
    }
}

